/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import one.edee.babylon.export.stats.MessageFileExportStats;
import one.edee.babylon.snapshot.TranslationSnapshotReadContract;

public class MessageFileProcessor {
    private final TranslationSnapshotReadContract snapshotReadContract;

    public MessageFileProcessor(TranslationSnapshotReadContract snapshotReadContract) {
        this.snapshotReadContract = snapshotReadContract;
    }

    public Pair<SheetContent, MessageFileExportStats> prepareTranslationSheet(String msgFile, Map<String, String> primaryMsgs, Map<String, Map<String, String>> translations, List<String> translationLangs) {
        Set<String> newMessageKeys = this.determineNewMessageKeysUsingComparisonWithTranslation(primaryMsgs, translations);
        HashMap<String, String> existingMessages = new HashMap<String, String>(primaryMsgs);
        newMessageKeys.forEach(existingMessages::remove);
        Set<String> changedKeys = this.determineChangedPrimaryMsgs(msgFile, existingMessages);
        Set<String> missingTranslations = this.determineMissingTranslatedMsgs(existingMessages, translations.values());
        LinkedHashMap<String, Integer> primaryMsgKeyOrdering = new LinkedHashMap<String, Integer>();
        int index = 0;
        for (String key : primaryMsgs.keySet()) {
            primaryMsgKeyOrdering.put(key, index++);
        }
        missingTranslations.removeAll(changedKeys);
        SheetContent translationSheet = this.createTranslationSheet(primaryMsgs, translations, translationLangs, newMessageKeys, changedKeys, missingTranslations, primaryMsgKeyOrdering);
        MessageFileExportStats stats = new MessageFileExportStats(msgFile, newMessageKeys.size(), changedKeys.size(), missingTranslations.size(), translationSheet.getDataRowCount());
        return new Pair<SheetContent, MessageFileExportStats>(translationSheet, stats);
    }

    private Set<String> determineNewMessageKeysUsingComparisonWithTranslation(Map<String, String> primaryMsgs, Map<String, Map<String, String>> translations) {
        Set allTranslationKeys = translations.values().stream().flatMap(map -> map.keySet().stream()).collect(Collectors.toSet());
        return primaryMsgs.keySet().stream().filter(k -> !allTranslationKeys.contains(k)).collect(Collectors.toSet());
    }

    private Set<String> determineChangedPrimaryMsgs(String msgFile, Map<String, String> existingPrimaryMsgs) {
        return existingPrimaryMsgs.entrySet().stream().filter(entry -> !this.snapshotReadContract.containsMessage((String)entry.getKey(), msgFile) || !this.snapshotReadContract.hasSameMessage((String)entry.getKey(), msgFile, (String)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private Set<String> determineMissingTranslatedMsgs(Map<String, String> primaryMsgs, Collection<Map<String, String>> translations) {
        List translationKeys = translations.stream().map(Map::keySet).collect(Collectors.toList());
        HashSet keysInEveryTranslation = translationKeys.isEmpty() ? Collections.emptySet() : new HashSet((Collection)translationKeys.get(0));
        for (int i = 1; i < translationKeys.size(); ++i) {
            keysInEveryTranslation.retainAll((Collection)translationKeys.get(i));
        }
        return primaryMsgs.keySet().stream().filter(key -> !keysInEveryTranslation.contains(key)).collect(Collectors.toSet());
    }

    private SheetContent createTranslationSheet(Map<String, String> primaryMsgs, Map<String, Map<String, String>> translations, List<String> translationLangs, Set<String> newMsgKeys, Set<String> changedMsgKeys, Set<String> missingTransKeys, Map<String, Integer> msgKeyOrdering) {
        List populatedRows = missingTransKeys.stream().map(key -> this.populateSheetRow(primaryMsgs, translations, translationLangs, (String)key)).collect(Collectors.toList());
        HashSet<String> noUsableTranslations = new HashSet<String>(newMsgKeys);
        noUsableTranslations.addAll(changedMsgKeys);
        List blankRows = noUsableTranslations.stream().map(key -> this.populateSheetRow(primaryMsgs, translations, translationLangs, (String)key)).collect(Collectors.toList());
        ArrayList<List<String>> allRows = new ArrayList<List<String>>();
        allRows.addAll(blankRows);
        allRows.addAll(populatedRows);
        allRows.sort(Comparator.comparing(row -> (Integer)msgKeyOrdering.get(row.get(0))));
        List<String> header = this.createSheetHeader(translationLangs);
        return new SheetContent(header, allRows, changedMsgKeys);
    }

    private List<String> populateSheetRow(Map<String, String> primaryMsgs, Map<String, Map<String, String>> translations, List<String> translationLangs, String messageKey) {
        String primaryMsg = primaryMsgs.get(messageKey);
        List<String> translatedMsgs = translationLangs.stream().map(lang -> {
            Map langMap = (Map)translations.get(lang);
            return langMap != null ? (String)langMap.get(messageKey) : null;
        }).collect(Collectors.toList());
        return primaryMsg != null ? this.createRow(messageKey, primaryMsg, translatedMsgs) : Collections.singletonList(messageKey);
    }

    private List<String> createRow(String msgKey, String primaryMsg, List<String> translations) {
        ArrayList<String> row = new ArrayList<String>();
        row.add(msgKey);
        row.add(primaryMsg);
        row.addAll(translations);
        return row;
    }

    private List<String> createSheetHeader(List<String> targetLangs) {
        ArrayList<String> header = new ArrayList<String>();
        header.add("key");
        header.add("primary");
        header.addAll(targetLangs);
        return header;
    }

    public static class Pair<K, V> {
        public final K first;
        public final V second;

        public Pair(K first, V second) {
            this.first = first;
            this.second = second;
        }

        public K getFirst() {
            return this.first;
        }

        public V getSecond() {
            return this.second;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair other = (Pair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            K this$first = this.getFirst();
            K other$first = other.getFirst();
            if (this$first == null ? other$first != null : !this$first.equals(other$first)) {
                return false;
            }
            V this$second = this.getSecond();
            V other$second = other.getSecond();
            return !(this$second == null ? other$second != null : !this$second.equals(other$second));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Pair;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            K $first = this.getFirst();
            result = result * 59 + ($first == null ? 43 : $first.hashCode());
            V $second = this.getSecond();
            result = result * 59 + ($second == null ? 43 : $second.hashCode());
            return result;
        }

        public String toString() {
            return "MessageFileProcessor.Pair(first=" + this.getFirst() + ", second=" + this.getSecond() + ")";
        }
    }

    public static class SheetContent {
        private final List<String> header;
        private final List<List<String>> dataRows;
        private final Set<String> translatedHistorically;
        private final int dataRowCount;

        public SheetContent(List<String> header, List<List<String>> dataRows, Set<String> translatedHistorically) {
            this.header = header;
            this.dataRows = dataRows;
            this.dataRowCount = dataRows.size();
            this.translatedHistorically = translatedHistorically;
        }

        public List<String> getHeader() {
            return this.header;
        }

        public List<List<String>> getDataRows() {
            return this.dataRows;
        }

        public Set<String> getTranslatedHistorically() {
            return this.translatedHistorically;
        }

        public int getDataRowCount() {
            return this.dataRowCount;
        }
    }
}

