/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.sheets.gsheets;

import com.google.api.services.sheets.v4.model.Sheet;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import one.edee.babylon.config.TranslationConfiguration;
import one.edee.babylon.export.Exporter;
import one.edee.babylon.sheets.SheetsException;
import one.edee.babylon.sheets.gsheets.LightGSheetService;
import one.edee.babylon.sheets.gsheets.model.ASheet;
import one.edee.babylon.sheets.gsheets.model.SheetAdaptor;
import org.springframework.util.StringUtils;

public class LightGSheetServiceExporterContractAdaptor
implements Exporter.SheetContract {
    private final LightGSheetService lightGSheetService;

    public LightGSheetServiceExporterContractAdaptor(LightGSheetService lightGSheetService) {
        this.lightGSheetService = lightGSheetService;
    }

    @Override
    public List<ASheet> listSheets(String spreadsheetId) throws SheetsException {
        try {
            return this.lightGSheetService.listSheetsLazily(spreadsheetId).stream().map(SheetAdaptor::new).collect(Collectors.toList());
        }
        catch (IOException | GeneralSecurityException e) {
            throw new SheetsException("Error when listing all sheets of spreadsheet '" + spreadsheetId + "'", e);
        }
    }

    @Override
    public void deleteSheets(String spreadsheetId, Collection<Integer> sheetIds) throws SheetsException {
        try {
            this.lightGSheetService.deleteSheets(spreadsheetId, sheetIds);
        }
        catch (IOException | GeneralSecurityException e) {
            String errMsg = "Error when deleting sheets '" + sheetIds + "' of spreadsheet '" + spreadsheetId + "'";
            throw new SheetsException(errMsg, e);
        }
    }

    @Override
    public void createSheet(String spreadsheetId, String sheetTitle, List<List<String>> sheetRows, TranslationConfiguration configuration, Map<String, List<String>> translatedAutomatically, Set<String> translatedHistorically) throws SheetsException {
        try {
            Sheet existingSheet = this.lightGSheetService.loadSheet(spreadsheetId, sheetTitle);
            if (existingSheet != null) {
                throw new SheetsException("Sheet '" + sheetTitle + "' already exists.");
            }
            LinkedList<String> translatedAutomaticallyMap = new LinkedList<String>();
            if (configuration.isMarkMovedKeys()) {
                for (int i = 0; i < sheetRows.size(); ++i) {
                    List<String> row = sheetRows.get(i);
                    if (!translatedHistorically.contains(row.get(0))) continue;
                    for (int l = 2; l < row.size(); ++l) {
                        if (!StringUtils.hasText((String)row.get(l))) continue;
                        translatedAutomaticallyMap.add(i + "_" + l);
                    }
                }
            }
            this.lightGSheetService.uploadDataToGoogleSheet(spreadsheetId, sheetTitle, sheetRows);
            Sheet sheet = this.lightGSheetService.loadSheet(spreadsheetId, sheetTitle);
            Integer sheetId = sheet.getProperties().getSheetId();
            this.lightGSheetService.updateSheetStyle(spreadsheetId, sheetId, configuration.getLockedCellEditors(), translatedAutomatically.get(sheetTitle), translatedAutomaticallyMap);
        }
        catch (IOException | GeneralSecurityException e) {
            String errMsg = "Error when creating sheet '" + sheetTitle + "' in spreadsheet '" + spreadsheetId + "'";
            throw new SheetsException(errMsg, e);
        }
    }
}

