/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.entity;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import one.edee.babylon.entity.PropertiesMap;
import one.edee.babylon.enums.PropertyStatus;

@JsonFilter(value="MessageFileFilter")
public class MessageFileContent
implements Serializable {
    private static final long serialVersionUID = 2426359297082283380L;
    private Integer id;
    @JsonProperty(value="properties")
    private PropertiesMap properties = new PropertiesMap();
    @JsonIgnore
    private Map<String, PropertiesMap> mutationProperties = new LinkedHashMap();

    public boolean hasSameValue(String msgKey, String currentMsg) {
        currentMsg = this.normalizeContent(currentMsg);
        return ((String)this.properties.get((Object)msgKey)).equals(currentMsg);
    }

    public String putProperty(String key, String value) {
        String result = this.properties.put(key, value = this.normalizeContent(value));
        if (result == null) {
            this.putPropertyStatus(key, PropertyStatus.NEW);
        } else if (!result.equals(value)) {
            this.putPropertyStatus(key, PropertyStatus.CHANGED);
        } else {
            this.putPropertyStatus(key, PropertyStatus.UNCHANGED);
        }
        return result;
    }

    public String putProperty(String key, String value, PropertyStatus propertyStatus) {
        return this.properties.put(key, this.normalizeContent(value), propertyStatus);
    }

    public String putMutationProperty(String mutation, String key, String value) {
        PropertiesMap propertiesMap = (PropertiesMap)this.mutationProperties.get(mutation);
        if (propertiesMap == null) {
            propertiesMap = new PropertiesMap();
            this.mutationProperties.put(mutation, propertiesMap);
        }
        return propertiesMap.put(key, this.normalizeContent(value));
    }

    public String getPropertyValue(String propertyKey) {
        return (String)this.properties.get((Object)propertyKey);
    }

    public PropertyStatus putPropertyStatus(String key, PropertyStatus propertyStatus) {
        return this.properties.putPropertyStatus(key, propertyStatus);
    }

    public PropertyStatus getPropertyStatus(String key) {
        return this.properties.getPropertyStatus(key);
    }

    public PropertiesMap putMutationProperties(String mutation, PropertiesMap properties) {
        return this.mutationProperties.put(mutation, properties);
    }

    public PropertiesMap getMutationProperties(String mutation) {
        return (PropertiesMap)this.mutationProperties.get(mutation);
    }

    private String normalizeContent(String value) {
        String lineSeparator = System.lineSeparator();
        if (lineSeparator.equals("\r\n")) {
            return value;
        }
        return value == null ? null : value.replace(lineSeparator, "\r\n");
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey((Object)key);
    }

    @JsonIgnore
    public Integer getPropertiesSize() {
        return this.properties.size();
    }

    public Integer getId() {
        return this.id;
    }

    public Map<String, PropertiesMap> getMutationProperties() {
        return this.mutationProperties;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @JsonIgnore
    public void setMutationProperties(Map<String, PropertiesMap> mutationProperties) {
        this.mutationProperties = mutationProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageFileContent)) {
            return false;
        }
        MessageFileContent other = (MessageFileContent)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        PropertiesMap this$properties = this.getProperties();
        PropertiesMap other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
            return false;
        }
        Map this$mutationProperties = this.getMutationProperties();
        Map other$mutationProperties = other.getMutationProperties();
        return !(this$mutationProperties == null ? other$mutationProperties != null : !((Object)this$mutationProperties).equals(other$mutationProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageFileContent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        PropertiesMap $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        Map $mutationProperties = this.getMutationProperties();
        result = result * 59 + ($mutationProperties == null ? 43 : ((Object)$mutationProperties).hashCode());
        return result;
    }

    public String toString() {
        return "MessageFileContent(id=" + this.getId() + ", properties=" + this.getProperties() + ", mutationProperties=" + this.getMutationProperties() + ")";
    }

    private PropertiesMap getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    private void setProperties(PropertiesMap properties) {
        this.properties = properties;
    }
}

