/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import one.edee.babylon.enums.PropertyStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertiesMap
extends LinkedHashMap<String, String> {
    private static final Log log = LogFactory.getLog(PropertiesMap.class);
    private static final long serialVersionUID = -9182848589118944788L;
    @JsonIgnore
    private final Map<String, PropertyStatus> propertiesStatus = new HashMap<String, PropertyStatus>();

    @Override
    public String put(String key, String value) {
        if (value == null) {
            value = "";
        }
        return super.put(key, value);
    }

    public String put(String key, String value, PropertyStatus propertyStatus) {
        String result = this.put(key, value);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Put property value: " + key + " = " + value));
        }
        this.putPropertyStatus(key, propertyStatus);
        return result;
    }

    public PropertyStatus putPropertyStatus(String key, PropertyStatus propertyStatus) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Put property status: " + key + " = " + propertyStatus.name()));
        }
        return this.propertiesStatus.put(key, propertyStatus);
    }

    public PropertyStatus getPropertyStatus(String key) {
        return this.propertiesStatus.get(key);
    }

    public Map<String, PropertyStatus> getPropertiesStatus() {
        return this.propertiesStatus;
    }
}

