/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.properties;

import one.edee.babylon.enums.PropertyType;

public abstract class AbstractProperty {
    private PropertyType type;

    protected AbstractProperty(PropertyType type) {
        this.type = type;
    }

    public abstract String getValue();

    public String getQuotedValue() {
        return this.getValue();
    }

    public abstract void setValue(String var1);

    public boolean isPropValue() {
        return this.type == PropertyType.VALUE;
    }

    public boolean isPropValueMultiLine() {
        return this.type == PropertyType.MULTILINE;
    }

    public boolean isPropEmptyLine() {
        return this.type == PropertyType.EMPTY;
    }

    public boolean isPropComment() {
        return this.type == PropertyType.COMMENT;
    }

    public String toString() {
        return "Property{type=" + (Object)((Object)this.getType()) + ", value='" + this.getValue() + '\'' + '}';
    }

    public PropertyType getType() {
        return this.type;
    }

    public void setType(PropertyType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractProperty)) {
            return false;
        }
        AbstractProperty other = (AbstractProperty)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PropertyType this$type = this.getType();
        PropertyType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PropertyType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }
}

