/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.properties;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import one.edee.babylon.enums.PropertyType;
import one.edee.babylon.export.TsMessageLoader;
import one.edee.babylon.export.ts.TypeScriptBabylonParserListener;
import one.edee.babylon.properties.AbstractProperty;
import one.edee.babylon.properties.FileActiveRecord;
import one.edee.babylon.properties.TsAttribute;
import one.edee.babylon.util.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.springframework.util.Assert;

public class TsFileActiveRecord
extends FileActiveRecord {
    private static final String DEFAULT_LANG_DEF_IMPORT = "import type { LangDef } from '@edeeone/juan-core/i18n/LangDef';";

    @Override
    public void load(Reader reader) throws IOException {
        Map<String, String> result = TsMessageLoader.dumpTsFile(reader);
        for (Map.Entry<String, String> entry : result.entrySet()) {
            String input = entry.getValue();
            TsAttribute property = new TsAttribute(input.contains("\n") || input.contains("\r") ? PropertyType.MULTILINE : PropertyType.VALUE, input);
            this.put(entry.getKey(), property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Writer writer, String primaryPropFilePath, String mutation) throws IOException {
        TypeScriptBabylonParserListener loadedFile = TsMessageLoader.loadFile(primaryPropFilePath);
        Assert.notNull((Object)loadedFile, (String)("Cannot load primary file on path:" + primaryPropFilePath));
        List<String> imports = loadedFile.getImports();
        imports.add(DEFAULT_LANG_DEF_IMPORT);
        String baseName = FilenameUtils.getBaseName((String)primaryPropFilePath);
        baseName = baseName.contains(".") ? baseName.substring(0, baseName.indexOf(".")) : baseName;
        Assert.isTrue((loadedFile.getPropertyListDefName().size() <= 1 ? 1 : 0) != 0, (String)("There has to be only one property list declaration name in file:" + primaryPropFilePath));
        String propertyListDefName = loadedFile.getPropertyListDefName().stream().findFirst().orElse(baseName);
        imports.add("import type " + propertyListDefName + " from './" + FilenameUtils.removeExtension((String)FileUtils.fileFromPathOrCreate(primaryPropFilePath).getName()) + "';");
        BufferedWriter bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        for (String tsImport : imports) {
            bufferedWriter.write(tsImport);
            bufferedWriter.newLine();
        }
        bufferedWriter.newLine();
        String finalLocalizationName = propertyListDefName + TsFileActiveRecord.firstLetterToUppercase(mutation);
        bufferedWriter.write("const " + finalLocalizationName + ": LangDef<typeof " + propertyListDefName + "> = {");
        bufferedWriter.newLine();
        TsFileActiveRecord tsFileActiveRecord = this;
        synchronized (tsFileActiveRecord) {
            for (Map.Entry entry : this.entrySet()) {
                String key = (String)entry.getKey();
                AbstractProperty value = (AbstractProperty)entry.getValue();
                String keyDelimiter = key.matches("\\[.*]") ? "" : "'";
                bufferedWriter.write("  " + keyDelimiter + key + keyDelimiter + ": " + value.getQuotedValue() + ",");
                bufferedWriter.newLine();
            }
        }
        bufferedWriter.write("};");
        bufferedWriter.newLine();
        bufferedWriter.write("export default " + finalLocalizationName + ";");
        bufferedWriter.flush();
    }

    public static String firstLetterToUppercase(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        char firstChar = Character.toUpperCase(input.charAt(0));
        String restOfString = input.substring(1);
        return firstChar + restOfString;
    }
}

