/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.statistics;

import java.util.LinkedHashMap;
import one.edee.babylon.enums.Action;
import one.edee.babylon.statistics.ImportFileStatistic;
import one.edee.babylon.statistics.StatisticsField;
import one.edee.babylon.statistics.TranslationStatisticsBase;

public class TranslationStatisticsOfImport
extends TranslationStatisticsBase {
    @StatisticsField(value="Action")
    private Action action;
    @StatisticsField(value="Total updated keys")
    private int totalUpdatedCnt;
    @StatisticsField(value="Total keys not found in primary file")
    private int totalNotFoundInPrimaryFile;
    private LinkedHashMap<String, ImportFileStatistic> fileStatistics = new LinkedHashMap();

    public void incTotalUpdatedCnt() {
        ++this.totalUpdatedCnt;
    }

    public void incTotalNotFoundInPrimaryFile(int inc) {
        this.totalNotFoundInPrimaryFile += inc;
    }

    public ImportFileStatistic putFileStatistic(String fileName, ImportFileStatistic exportFileStatistic) {
        return this.fileStatistics.put(fileName, exportFileStatistic);
    }

    public ImportFileStatistic getFileStatistic(String fileName) {
        return this.fileStatistics.get(fileName);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public Action getAction() {
        return this.action;
    }

    public int getTotalUpdatedCnt() {
        return this.totalUpdatedCnt;
    }

    public int getTotalNotFoundInPrimaryFile() {
        return this.totalNotFoundInPrimaryFile;
    }

    public LinkedHashMap<String, ImportFileStatistic> getFileStatistics() {
        return this.fileStatistics;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setTotalUpdatedCnt(int totalUpdatedCnt) {
        this.totalUpdatedCnt = totalUpdatedCnt;
    }

    public void setTotalNotFoundInPrimaryFile(int totalNotFoundInPrimaryFile) {
        this.totalNotFoundInPrimaryFile = totalNotFoundInPrimaryFile;
    }

    public void setFileStatistics(LinkedHashMap<String, ImportFileStatistic> fileStatistics) {
        this.fileStatistics = fileStatistics;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TranslationStatisticsOfImport)) {
            return false;
        }
        TranslationStatisticsOfImport other = (TranslationStatisticsOfImport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getTotalUpdatedCnt() != other.getTotalUpdatedCnt()) {
            return false;
        }
        if (this.getTotalNotFoundInPrimaryFile() != other.getTotalNotFoundInPrimaryFile()) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        LinkedHashMap<String, ImportFileStatistic> this$fileStatistics = this.getFileStatistics();
        LinkedHashMap<String, ImportFileStatistic> other$fileStatistics = other.getFileStatistics();
        return !(this$fileStatistics == null ? other$fileStatistics != null : !((Object)this$fileStatistics).equals(other$fileStatistics));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TranslationStatisticsOfImport;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getTotalUpdatedCnt();
        result = result * 59 + this.getTotalNotFoundInPrimaryFile();
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        LinkedHashMap<String, ImportFileStatistic> $fileStatistics = this.getFileStatistics();
        result = result * 59 + ($fileStatistics == null ? 43 : ((Object)$fileStatistics).hashCode());
        return result;
    }
}

