/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.export.ts;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.edee.babylon.export.ts.gen.TypeScriptParser;
import one.edee.babylon.export.ts.gen.TypeScriptParserBaseListener;
import org.antlr.v4.runtime.ParserRuleContext;
import org.springframework.util.Assert;

public class TypeScriptBabylonParserListener
extends TypeScriptParserBaseListener {
    private static final String APOSTROPHE_CLEANING_REGEX = "['`].*?";
    private final Set<String> propertyListDefName = new HashSet();
    private final Map<String, String> propertyDefinitions = new LinkedHashMap();
    private final List<String> imports = new LinkedList();

    public void enterIdentifierOrKeyWord(TypeScriptParser.IdentifierOrKeyWordContext ctx) {
        this.propertyListDefName.add(ctx.getText());
    }

    public void enterPropertyExpressionAssignment(TypeScriptParser.PropertyExpressionAssignmentContext ctx) {
        int childCount = ctx.getChildCount();
        Assert.isTrue((childCount == 3 ? 1 : 0) != 0, (String)("There has to be property name, delimiter (:) and value! In: " + ctx.getText()));
        String propertyName = this.cleanText(ctx.getChild(0).getText());
        String propertyValue = this.cleanText(ctx.getChild(2).getText());
        this.propertyDefinitions.put(propertyName, propertyValue);
    }

    public void enterComputedPropertyExpressionAssignment(TypeScriptParser.ComputedPropertyExpressionAssignmentContext ctx) {
        String[] split = ctx.getText().split(":");
        Assert.isTrue((split.length == 2 ? 1 : 0) != 0, (String)("There has to be property name, delimiter (:) and value! In: " + ctx.getText()));
        String propertyName = this.cleanText(split[0]);
        String propertyValue = this.cleanText(split[1]);
        this.propertyDefinitions.put(propertyName, propertyValue);
    }

    public void enterImportStatement(TypeScriptParser.ImportStatementContext ctx) {
        this.imports.add(this.getNodeText((ParserRuleContext)ctx));
    }

    private String cleanText(String text) {
        if (text.matches(APOSTROPHE_CLEANING_REGEX) || text.contains("\n") || text.contains("\r")) {
            text = text.replaceAll("(?<!\\\\)['`]", "");
        }
        return text;
    }

    private String getNodeText(ParserRuleContext ctx) {
        int childCount = ctx.getChildCount();
        if (childCount == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < childCount; ++i) {
            if (i != 0) {
                builder.append(" ");
            }
            builder.append(ctx.getChild(i).getText());
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeScriptBabylonParserListener)) {
            return false;
        }
        TypeScriptBabylonParserListener other = (TypeScriptBabylonParserListener)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Set this$propertyListDefName = this.getPropertyListDefName();
        Set other$propertyListDefName = other.getPropertyListDefName();
        if (this$propertyListDefName == null ? other$propertyListDefName != null : !((Object)this$propertyListDefName).equals(other$propertyListDefName)) {
            return false;
        }
        Map this$propertyDefinitions = this.getPropertyDefinitions();
        Map other$propertyDefinitions = other.getPropertyDefinitions();
        if (this$propertyDefinitions == null ? other$propertyDefinitions != null : !((Object)this$propertyDefinitions).equals(other$propertyDefinitions)) {
            return false;
        }
        List this$imports = this.getImports();
        List other$imports = other.getImports();
        return !(this$imports == null ? other$imports != null : !((Object)this$imports).equals(other$imports));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TypeScriptBabylonParserListener;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Set $propertyListDefName = this.getPropertyListDefName();
        result = result * 59 + ($propertyListDefName == null ? 43 : ((Object)$propertyListDefName).hashCode());
        Map $propertyDefinitions = this.getPropertyDefinitions();
        result = result * 59 + ($propertyDefinitions == null ? 43 : ((Object)$propertyDefinitions).hashCode());
        List $imports = this.getImports();
        result = result * 59 + ($imports == null ? 43 : ((Object)$imports).hashCode());
        return result;
    }

    public Set<String> getPropertyListDefName() {
        return this.propertyListDefName;
    }

    public Map<String, String> getPropertyDefinitions() {
        return this.propertyDefinitions;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public String toString() {
        return "TypeScriptBabylonParserListener(propertyListDefName=" + this.getPropertyListDefName() + ", propertyDefinitions=" + this.getPropertyDefinitions() + ", imports=" + this.getImports() + ")";
    }
}

