/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.export.ts;

import java.util.ArrayDeque;
import java.util.Deque;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Token;

public abstract class TypeScriptLexerBase
extends Lexer {
    private final Deque<Boolean> scopeStrictModes = new ArrayDeque();
    private Token lastToken = null;
    private boolean useStrictDefault = false;
    private boolean useStrictCurrent = false;
    private int templateDepth = 0;
    private int bracesDepth = 0;

    public TypeScriptLexerBase(CharStream input) {
        super(input);
    }

    public boolean getStrictDefault() {
        return this.useStrictDefault;
    }

    public void setUseStrictDefault(boolean value) {
        this.useStrictDefault = value;
        this.useStrictCurrent = value;
    }

    public boolean IsStrictMode() {
        return this.useStrictCurrent;
    }

    public void StartTemplateString() {
        this.bracesDepth = 0;
    }

    public boolean IsInTemplateString() {
        return this.templateDepth > 0 && this.bracesDepth == 0;
    }

    public Token nextToken() {
        Token next = super.nextToken();
        if (next.getChannel() == 0) {
            this.lastToken = next;
        }
        return next;
    }

    protected void ProcessOpenBrace() {
        ++this.bracesDepth;
        this.useStrictCurrent = this.scopeStrictModes.size() > 0 && (Boolean)this.scopeStrictModes.peek() != false ? true : this.useStrictDefault;
        this.scopeStrictModes.push(this.useStrictCurrent);
    }

    protected void ProcessCloseBrace() {
        --this.bracesDepth;
        this.useStrictCurrent = this.scopeStrictModes.size() > 0 ? (Boolean)this.scopeStrictModes.pop() : this.useStrictDefault;
    }

    protected void ProcessStringLiteral() {
        String text;
        if ((this.lastToken == null || this.lastToken.getType() == 8) && ((text = this.getText()).equals("\"use strict\"") || text.equals("'use strict'"))) {
            if (this.scopeStrictModes.size() > 0) {
                this.scopeStrictModes.pop();
            }
            this.useStrictCurrent = true;
            this.scopeStrictModes.push(this.useStrictCurrent);
        }
    }

    protected void IncreaseTemplateDepth() {
        ++this.templateDepth;
    }

    protected void DecreaseTemplateDepth() {
        --this.templateDepth;
    }

    protected boolean IsRegexPossible() {
        if (this.lastToken == null) {
            return true;
        }
        switch (this.lastToken.getType()) {
            case 5: 
            case 7: 
            case 18: 
            case 19: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 80: 
            case 124: 
            case 125: {
                return false;
            }
        }
        return true;
    }
}

