/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.sheets.gsheets;

import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetRequest;
import com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetResponse;
import com.google.api.services.sheets.v4.model.BatchUpdateValuesRequest;
import com.google.api.services.sheets.v4.model.BatchUpdateValuesResponse;
import com.google.api.services.sheets.v4.model.Color;
import com.google.api.services.sheets.v4.model.Request;
import com.google.api.services.sheets.v4.model.Sheet;
import com.google.api.services.sheets.v4.model.Spreadsheet;
import com.google.api.services.sheets.v4.model.ValueRange;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import one.edee.babylon.sheets.gsheets.GSheetApiRequestFactory;
import one.edee.babylon.sheets.gsheets.GSheetsClient;
import one.edee.babylon.sheets.gsheets.executor.SpreadsheetUpdateRQE;
import one.edee.babylon.sheets.gsheets.executor.SpreadsheetValuesUpdateRQE;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LightGSheetService {
    private static final Log log = LogFactory.getLog(LightGSheetService.class);
    private final GSheetApiRequestFactory gSheetsRequestFactory;
    private final GSheetsClient gsClient;
    private static final Integer COLUMN_WIDTH = 350;

    public LightGSheetService(GSheetApiRequestFactory gSheetApiRequestFactory, GSheetsClient gsClient) {
        this.gSheetsRequestFactory = gSheetApiRequestFactory;
        this.gsClient = gsClient;
    }

    public List<Sheet> listSheetsLazily(String spreadsheetId) throws GeneralSecurityException, IOException {
        Sheets.Spreadsheets.Get listRequest = this.getSheetsClient().spreadsheets().get(spreadsheetId);
        Spreadsheet spreadSheet = (Spreadsheet)listRequest.execute();
        return spreadSheet.getSheets();
    }

    public List<Sheet> listSheetsEagerly(String spreadsheetId) throws GeneralSecurityException, IOException {
        Sheets.Spreadsheets.Get listRequest = this.getSheetsClient().spreadsheets().get(spreadsheetId).setIncludeGridData(Boolean.valueOf(true));
        Spreadsheet spreadSheet = (Spreadsheet)listRequest.execute();
        return spreadSheet.getSheets();
    }

    public Sheet loadSheet(String spreadsheetId, String sheetTitle) throws GeneralSecurityException, IOException {
        Sheets.Spreadsheets.Get loadRequest = this.getSheetsClient().spreadsheets().get(spreadsheetId);
        Spreadsheet spreadSheet = (Spreadsheet)loadRequest.execute();
        return spreadSheet.getSheets().stream().filter(sheet -> sheet.getProperties().getTitle().equals(sheetTitle)).findFirst().orElse(null);
    }

    public void uploadDataToGoogleSheet(String spreadsheetId, String sheetTitle, List<List<String>> sheetRows) throws GeneralSecurityException, IOException {
        this.uploadDataToGoogleSheet(spreadsheetId, sheetTitle, sheetRows, 0, 0);
    }

    public void uploadDataToGoogleSheet(String spreadsheetId, String sheetTitle, List<List<String>> sheetRows, int rowsToFreeze, int colsToFreeze) throws GeneralSecurityException, IOException {
        Integer rows = sheetRows.size();
        Integer cols = sheetRows.size() > 0 ? sheetRows.get(0).size() : 0;
        Request addSheet = this.gSheetsRequestFactory.addSheet(sheetTitle, rows, cols, rowsToFreeze, colsToFreeze);
        this.executeRequests(spreadsheetId, addSheet);
        this.writeDataToGoogleSheet(spreadsheetId, sheetTitle, sheetRows);
    }

    private void writeDataToGoogleSheet(String spreadsheetId, String range, List<? extends List<? extends Object>> values) throws GeneralSecurityException, IOException {
        List<? extends List<? extends Object>> convertedValues = this.convertNullsToEmptyString(values);
        ValueRange valueRange = new ValueRange().setValues(convertedValues).setRange(range);
        BatchUpdateValuesRequest update = new BatchUpdateValuesRequest().setValueInputOption("RAW").setData(Collections.singletonList(valueRange));
        BatchUpdateValuesResponse result = this.executeRequest(spreadsheetId, update);
        log.info((Object)String.format("%d cells written.", result.getTotalUpdatedCells()));
    }

    private List<? extends List<? extends Object>> convertNullsToEmptyString(List<? extends List<? extends Object>> values) {
        return values.stream().map(row -> row.stream().map(cell -> cell == null ? "" : cell).collect(Collectors.toList())).collect(Collectors.toList());
    }

    public void updateSheetStyle(String spreadsheetId, Integer sheetId, List<String> lockedCellEditors, List<String> translatedAutomatically, List<String> translatedHistorically) throws GeneralSecurityException, IOException {
        LinkedList<Request> requests = new LinkedList<Request>();
        requests.add(this.gSheetsRequestFactory.setWrapWrappingStrategyForAllCells(sheetId));
        requests.add(this.gSheetsRequestFactory.resizeAllColumns(sheetId, COLUMN_WIDTH));
        if (!lockedCellEditors.isEmpty()) {
            requests.add(this.gSheetsRequestFactory.protectCellsInFirstTwoColumns(sheetId, lockedCellEditors));
        }
        requests.add(this.gSheetsRequestFactory.hideFirstColumn(sheetId));
        requests.addAll(this.gSheetsRequestFactory.changeCellColor(sheetId, translatedAutomatically, new Color().setRed(Float.valueOf(1.0f)).setGreen(Float.valueOf(0.8f)).setBlue(Float.valueOf(0.61f))));
        requests.addAll(this.gSheetsRequestFactory.changeCellColor(sheetId, translatedHistorically, new Color().setRed(Float.valueOf(0.64f)).setGreen(Float.valueOf(0.77f)).setBlue(Float.valueOf(0.96f))));
        this.executeRequests(spreadsheetId, requests.toArray(new Request[0]));
    }

    public void deleteSheets(String spreadsheetId, Collection<Integer> sheetIds) throws GeneralSecurityException, IOException {
        Request[] deleteSheetRequests = (Request[])sheetIds.stream().map(this.gSheetsRequestFactory::deleteSheet).toArray(Request[]::new);
        this.executeRequests(spreadsheetId, deleteSheetRequests);
    }

    private BatchUpdateValuesResponse executeRequest(String spreadsheetId, BatchUpdateValuesRequest request) throws GeneralSecurityException, IOException {
        SpreadsheetValuesUpdateRQE requestQueueExecutor = new SpreadsheetValuesUpdateRQE(this.gsClient, spreadsheetId, request);
        return (BatchUpdateValuesResponse)requestQueueExecutor.executeRequest();
    }

    private BatchUpdateSpreadsheetResponse executeRequests(String spreadsheetId, Request ... requests) throws GeneralSecurityException, IOException {
        BatchUpdateSpreadsheetRequest req = new BatchUpdateSpreadsheetRequest().setRequests(Arrays.asList(requests)).setIncludeSpreadsheetInResponse(Boolean.valueOf(false));
        SpreadsheetUpdateRQE requestQueueExecutor = new SpreadsheetUpdateRQE(this.gsClient, spreadsheetId, req);
        return (BatchUpdateSpreadsheetResponse)requestQueueExecutor.executeRequest();
    }

    private Sheets getSheetsClient() throws GeneralSecurityException, IOException {
        return this.gsClient.getSheetService();
    }
}

