/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.imp0rt;

import com.google.api.services.sheets.v4.model.CellData;
import com.google.api.services.sheets.v4.model.GridData;
import com.google.api.services.sheets.v4.model.RowData;
import com.google.api.services.sheets.v4.model.Sheet;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.PatternSyntaxException;
import one.edee.babylon.entity.MessageFileContent;
import one.edee.babylon.imp0rt.MessageWriter;
import one.edee.babylon.imp0rt.legacy.MessageFileContentMessageWriter;
import one.edee.babylon.snapshot.Snapshot;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportSheetProcessor {
    private static final Log log = LogFactory.getLog(ImportSheetProcessor.class);

    public void processSheet(Sheet sheet, Snapshot snapshot) throws IOException {
        String sheetTitle = sheet.getProperties().getTitle();
        log.info((Object)("Processing sheet \"" + sheetTitle + "\"..."));
        Integer fileId = this.parseFileIdFromSheetTitle(sheetTitle);
        MessageFileContentMessageWriter messageWriter = new MessageFileContentMessageWriter(this.getPropFileById(fileId, snapshot));
        List sheetData = sheet.getData();
        if (sheetData == null || sheetData.isEmpty()) {
            log.warn((Object)("Sheet " + sheetTitle + " not contains any data in grid."));
            return;
        }
        for (GridData gridData : sheetData) {
            this.processGridDataOfSheet(sheetTitle, gridData, (MessageWriter)messageWriter);
        }
    }

    private MessageFileContent getPropFileById(Integer fileId, Snapshot snapshot) {
        MessageFileContent propFile = snapshot.getPropFileById(fileId);
        if (propFile == null) {
            String msg = "No record found by id='" + fileId + "' in DB file";
            throw new IllegalArgumentException(msg);
        }
        return propFile;
    }

    private void processGridDataOfSheet(String sheetTitle, GridData gridData, MessageWriter messageWriter) throws IOException {
        List rowsData = gridData.getRowData();
        if (rowsData == null) {
            log.warn((Object)("Sheet \"" + sheetTitle + " \" is empty"));
            return;
        }
        Map header = this.createHeader((RowData)rowsData.get(0));
        for (RowData rowData : rowsData.subList(1, rowsData.size())) {
            if (!rowData.getValues().stream().anyMatch(i -> i.getFormattedValue() != null && !Objects.equals(i.getFormattedValue(), "null"))) continue;
            this.processRowData(header, rowData, messageWriter);
        }
    }

    private Map<Integer, String> createHeader(RowData headerData) {
        int col = 0;
        LinkedHashMap<Integer, String> header = new LinkedHashMap<Integer, String>();
        for (CellData cellData : headerData.getValues()) {
            String cellValue = cellData.getFormattedValue().trim();
            header.put(col++, cellValue);
        }
        return header;
    }

    private void processRowData(Map<Integer, String> header, RowData rowData, MessageWriter messageWriter) {
        int col = 0;
        List values = rowData.getValues();
        String propKey = "";
        for (CellData cellData : values) {
            String colTitle = header.get(col);
            String propValue = cellData.getFormattedValue();
            if (col == 0) {
                propKey = propValue;
            } else if (col == 1) {
                messageWriter.storePrimaryMessage(propKey, propValue);
            } else {
                messageWriter.storeTranslation(colTitle, propKey, propValue);
            }
            ++col;
        }
    }

    private Integer parseFileIdFromSheetTitle(String sheetTitle) {
        try {
            String[] split = sheetTitle.split("#");
            if (split.length != 2) {
                throw new IllegalArgumentException("Cannot parse unique id from string \"" + sheetTitle + "\"");
            }
            return Integer.parseInt(split[0]);
        }
        catch (NumberFormatException | PatternSyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

