/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.sheets.gsheets;

import com.google.api.services.sheets.v4.model.AddProtectedRangeRequest;
import com.google.api.services.sheets.v4.model.AddSheetRequest;
import com.google.api.services.sheets.v4.model.CellData;
import com.google.api.services.sheets.v4.model.CellFormat;
import com.google.api.services.sheets.v4.model.Color;
import com.google.api.services.sheets.v4.model.DeleteSheetRequest;
import com.google.api.services.sheets.v4.model.DimensionProperties;
import com.google.api.services.sheets.v4.model.DimensionRange;
import com.google.api.services.sheets.v4.model.Editors;
import com.google.api.services.sheets.v4.model.GridProperties;
import com.google.api.services.sheets.v4.model.GridRange;
import com.google.api.services.sheets.v4.model.ProtectedRange;
import com.google.api.services.sheets.v4.model.RepeatCellRequest;
import com.google.api.services.sheets.v4.model.Request;
import com.google.api.services.sheets.v4.model.RowData;
import com.google.api.services.sheets.v4.model.SheetProperties;
import com.google.api.services.sheets.v4.model.UpdateCellsRequest;
import com.google.api.services.sheets.v4.model.UpdateDimensionPropertiesRequest;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class GSheetApiRequestFactory {
    private static final String DIMENSION_RANGE__DIMENSION__COLUMNS = "COLUMNS";

    public Request addSheet(String newSheetTitle, Integer rowCount, Integer colCount, Integer rowsToFreeze, Integer colsToFreeze) {
        return new Request().setAddSheet(this.doAddSheet(newSheetTitle, rowCount, colCount, rowsToFreeze, colsToFreeze));
    }

    private AddSheetRequest doAddSheet(String newSheetTitle, Integer rowCount, Integer colCount, Integer rowsToFreeze, Integer colsToFreeze) {
        GridProperties gridProperties = new GridProperties().setRowCount(rowCount).setColumnCount(colCount).setFrozenRowCount(rowsToFreeze).setFrozenColumnCount(colsToFreeze);
        SheetProperties sheetProperties = new SheetProperties().setTitle(newSheetTitle).setGridProperties(gridProperties);
        return new AddSheetRequest().setProperties(sheetProperties);
    }

    public Request setWrapWrappingStrategyForAllCells(Integer sheetId) {
        return new Request().setRepeatCell(this.wrappingStrategyCellUpdate(this.allCellsRange(sheetId)));
    }

    private RepeatCellRequest wrappingStrategyCellUpdate(GridRange gridRange) {
        return new RepeatCellRequest().setFields("userEnteredFormat.wrapStrategy").setCell(new CellData().setUserEnteredFormat(new CellFormat().setWrapStrategy("WRAP"))).setRange(gridRange);
    }

    private GridRange allCellsRange(Integer sheetId) {
        return new GridRange().setSheetId(sheetId).setStartRowIndex(Integer.valueOf(0)).setStartColumnIndex(Integer.valueOf(0));
    }

    public Request resizeAllColumns(Integer sheetId, Integer pixelSize) {
        return new Request().setUpdateDimensionProperties(this.resizeDimension(this.allColumns(sheetId), pixelSize));
    }

    private UpdateDimensionPropertiesRequest resizeDimension(DimensionRange dimensionRange, Integer pixelSize) {
        return new UpdateDimensionPropertiesRequest().setRange(dimensionRange).setFields("pixelSize").setProperties(new DimensionProperties().setPixelSize(pixelSize));
    }

    public Request hideFirstColumn(Integer sheetId) {
        return new Request().setUpdateDimensionProperties(this.hideDimension(this.firstColumn(sheetId)));
    }

    private UpdateDimensionPropertiesRequest hideDimension(DimensionRange dimensionRange) {
        return new UpdateDimensionPropertiesRequest().setRange(dimensionRange).setFields("hiddenByUser").setProperties(new DimensionProperties().setHiddenByUser(Boolean.TRUE));
    }

    private DimensionRange allColumns(Integer sheetId) {
        return new DimensionRange().setSheetId(sheetId).setDimension(DIMENSION_RANGE__DIMENSION__COLUMNS);
    }

    private DimensionRange firstColumn(Integer sheetId) {
        return new DimensionRange().setSheetId(sheetId).setDimension(DIMENSION_RANGE__DIMENSION__COLUMNS).setStartIndex(Integer.valueOf(0)).setEndIndex(Integer.valueOf(1));
    }

    public Request protectCellsInFirstTwoColumns(Integer sheetId, List<String> lockedCellEditors) {
        return new Request().setAddProtectedRange(this.protectCells(this.firstTwoColsCellsRange(sheetId), lockedCellEditors));
    }

    private AddProtectedRangeRequest protectCells(GridRange gridRange, List<String> lockedCellEditors) {
        return new AddProtectedRangeRequest().setProtectedRange(this.lockCells(gridRange, lockedCellEditors));
    }

    private ProtectedRange lockCells(GridRange gridRange, List<String> editorAccounts) {
        return new ProtectedRange().setRange(gridRange).setRequestingUserCanEdit(Boolean.valueOf(false)).setWarningOnly(Boolean.valueOf(false)).setEditors(new Editors().setUsers(editorAccounts));
    }

    private GridRange firstTwoColsCellsRange(Integer sheetId) {
        return new GridRange().setSheetId(sheetId).setStartColumnIndex(Integer.valueOf(0)).setEndColumnIndex(Integer.valueOf(2)).setStartRowIndex(Integer.valueOf(0));
    }

    public Request deleteSheet(Integer sheetId) {
        return new Request().setDeleteSheet(this.deleteSheetRequest(sheetId));
    }

    private DeleteSheetRequest deleteSheetRequest(Integer sheetId) {
        return new DeleteSheetRequest().setSheetId(sheetId);
    }

    public List<Request> changeCellColor(Integer sheetId, List<String> changed, Color color) {
        LinkedList<Request> reqs = new LinkedList<Request>();
        for (String change : Optional.ofNullable(changed).orElse(Collections.emptyList())) {
            String[] s = change.split("_");
            int row = Integer.parseInt(s[0]);
            int column = Integer.parseInt(s[1]);
            reqs.add(new Request().setUpdateCells(new UpdateCellsRequest().setRange(new GridRange().setSheetId(sheetId).setStartColumnIndex(Integer.valueOf(column)).setEndColumnIndex(Integer.valueOf(column + 1)).setStartRowIndex(Integer.valueOf(row)).setEndRowIndex(Integer.valueOf(row + 1))).setRows(Collections.singletonList(new RowData().setValues(Collections.singletonList(new CellData().setUserEnteredFormat(new CellFormat().setBackgroundColor(color)))))).setFields("userEnteredFormat.backgroundColor")));
        }
        return reqs;
    }
}

