/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.export.translator;

import com.deepl.api.TextResult;
import com.deepl.api.TextTranslationOptions;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import one.edee.babylon.config.SupportedTranslators;
import one.edee.babylon.export.translator.Translator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class DeeplTranslator
implements Translator {
    private static final Logger log = LogManager.getLogger(DeeplTranslator.class);
    com.deepl.api.Translator service = null;

    public void init(@NotNull String apiKey) {
        this.service = new com.deepl.api.Translator(apiKey);
    }

    public List<String> translate(@Nullable String defaultLang, @NotNull List<String> original, @NotNull String lang) {
        Assert.notNull((Object)this.service, (String)"Init method with api key has to be called before translation!");
        if (lang.equals("en")) {
            lang = "en-GB";
        }
        String contextMessage = System.getProperty("babylon.deepl.context");
        try {
            return this.service.translateText(original, defaultLang, lang, new TextTranslationOptions().setContext(Optional.ofNullable(contextMessage).orElse("You are eshop translator. Do not translate text from other languages then source lang, or technical texts."))).stream().map(TextResult::getText).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("Cannot translate " + original + " to lang: " + lang);
            return null;
        }
    }

    public SupportedTranslators getSupportedTranslator() {
        return SupportedTranslators.DEEPL;
    }
}

