/*
 * Decompiled with CFR 0.152.
 */
package one.edee.babylon.git;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileSystems;
import one.edee.babylon.git.GitAdd;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RuntimeExecGitAdd
implements GitAdd {
    private static final Log log = LogFactory.getLog(RuntimeExecGitAdd.class);

    public void gitAddFile(String pathFileName) {
        try {
            this.doGitAddFile(pathFileName);
        }
        catch (Exception e) {
            throw new RuntimeException("Error when trying to perform Git add on file '" + pathFileName + "'.", e);
        }
    }

    private void doGitAddFile(String pathFileName) throws IOException, InterruptedException {
        Process p;
        log.info((Object)FileSystems.getDefault().getPath(".", new String[0]).toAbsolutePath());
        int exdCode = Runtime.getRuntime().exec("git add " + pathFileName).waitFor();
        log.info((Object)("file git add ended with code : " + exdCode + " for file : " + pathFileName));
        if (exdCode != 0 && (exdCode = (p = Runtime.getRuntime().exec("git add " + pathFileName)).waitFor()) != 0) {
            String line;
            log.info((Object)("Process exit code: " + exdCode));
            log.info((Object)"Result:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((line = reader.readLine()) != null) {
                log.warn((Object)line);
            }
        }
    }
}

