create table DARWIN
(
  component VARCHAR2(255) not null,
  modified TIMESTAMP not null,
  version VARCHAR2(20) null
);

create table DARWIN_LOCK
(
  processName VARCHAR2(255) not null,
  leaseUntil TIMESTAMP not null,
  unlockKey varchar(255) not null,
  constraint CNUN_DARWIN_LOCK unique (processName)
);

ALTER TABLE DARWIN ADD CONSTRAINT CNPK_DARWIN_COMPONENT PRIMARY KEY (component);

CREATE TABLE DARWIN_PATCH
(
  id INT NOT NULL,
  componentName VARCHAR(255) NOT NULL,
  patchName VARCHAR(100) NOT NULL,
  processTime INT,
  detectedOn DATE NOT NULL,
  finishedOn DATE,
  platform VARCHAR(10),
  CONSTRAINT CNPK_DARWIN_PATCH_ID PRIMARY KEY (id),
  CONSTRAINT CNFK_PACH_DARWIN FOREIGN KEY (componentName) REFERENCES DARWIN (component) ON DELETE CASCADE
);

CREATE INDEX CNIX_DARWIN_PATCH ON DARWIN_PATCH (componentName);
CREATE UNIQUE INDEX CNUN_UNIQUE_PATCH ON DARWIN_PATCH (patchName, componentName, platform);
CREATE SEQUENCE SQ_DARWIN_PATCH MINVALUE 1 START WITH 1 INCREMENT BY 1 NOCACHE;

CREATE TABLE DARWIN_SQL
(
    id INT NOT NULL,
    patchId INT NOT NULL,
    statementHash VARCHAR(64) NULL,
    statement CLOB NOT NULL,
    processTime INT,
    finishedOn DATE,
    exception CLOB,
    CONSTRAINT CNPK_DARWIN_SQL_ID PRIMARY KEY (id),
    CONSTRAINT CNFK_SQL_PATCH FOREIGN KEY (patchId) REFERENCES DARWIN_PATCH (id) ON DELETE CASCADE
);

CREATE INDEX CNIX_DARWIN_SQL ON DARWIN_SQL (patchId);
CREATE SEQUENCE SQ_DARWIN_SQL MINVALUE 1 START WITH 1 INCREMENT BY 1 NOCACHE;
CREATE INDEX IX_DARWIN_SQL_HASH ON DARWIN_SQL (statementHash);
