/*
 * Decompiled with CFR 0.152.
 */
package one.edee.darwin.resources;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.edee.darwin.model.Patch;
import one.edee.darwin.model.version.VersionDescriptor;
import one.edee.darwin.resources.ResourceNameAnalyzer;
import org.springframework.core.io.Resource;

public class DefaultResourceNameAnalyzer
implements ResourceNameAnalyzer {
    private static final long serialVersionUID = 3329089530167442837L;
    private static final Pattern VERSION_PATTERN = Pattern.compile("_(.*).sql$");
    private static final Pattern PLATFORM_AND_NAME_PATTERN = Pattern.compile("(.*)/(.*)");

    @Override
    public VersionDescriptor getVersionFromResource(Resource resource) {
        int index;
        String fileName = Objects.requireNonNull(resource.getFilename()).toLowerCase();
        int startIndex = fileName.lastIndexOf(95);
        if (startIndex > -1 && (index = fileName.lastIndexOf(46)) > -1 && fileName.length() > 6) {
            String version = fileName.substring(startIndex, index);
            return new VersionDescriptor(version);
        }
        return null;
    }

    @Override
    public VersionDescriptor getVersionFromPatch(Patch patch) {
        Matcher matcher = VERSION_PATTERN.matcher(patch.getPatchName());
        if (matcher.find()) {
            return new VersionDescriptor(matcher.group(1));
        }
        return null;
    }

    @Override
    public String getPatchNameFromResource(Resource resource) {
        return resource.getFilename();
    }

    @Override
    public String[] getPlatformAndNameFromResourcePath(String resourcePath) {
        Matcher matcher = PLATFORM_AND_NAME_PATTERN.matcher(resourcePath);
        if (matcher.find()) {
            return new String[]{matcher.group(1), matcher.group(2)};
        }
        return null;
    }
}

