/*
 * Decompiled with CFR 0.152.
 */
package one.edee.darwin.storage;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import one.edee.darwin.model.Patch;
import one.edee.darwin.model.SqlCommand;
import one.edee.darwin.storage.AbstractDatabaseStorage;
import one.edee.darwin.storage.DarwinStorage;
import one.edee.darwin.storage.StorageChecker;
import one.edee.darwin.storage.StorageUpdater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

public class DefaultDatabaseStorageUpdater
extends AbstractDatabaseStorage
implements StorageUpdater {
    private static final Log log = LogFactory.getLog(DefaultDatabaseStorageUpdater.class);
    private final StorageChecker storageChecker;

    public DefaultDatabaseStorageUpdater(StorageChecker storageChecker) {
        Assert.notNull((Object)storageChecker);
        this.storageChecker = storageChecker;
    }

    @Override
    public void executeScript(final String resourcePath, final String componentName, final DarwinStorage darwinStorage, StorageChecker storageChecker) {
        if (this.transactionManager != null) {
            new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    DefaultDatabaseStorageUpdater.this.performUpdate(resourcePath, componentName, darwinStorage);
                }
            });
        } else {
            this.performUpdate(resourcePath, componentName, darwinStorage);
        }
    }

    private void performUpdate(String resourcePath, String componentName, DarwinStorage darwinStorage) {
        List<String> sqlCommands = this.resourceAccessor.getTokenizedSQLScriptContentFromResource(resourcePath);
        Patch patch = darwinStorage.getPatchByResourcePath(resourcePath, componentName);
        boolean patchAndSqlTableExists = this.storageChecker.existPatchAndSqlTable();
        long start = System.currentTimeMillis();
        HashMap<String, Integer> executedCommands = new HashMap<String, Integer>(sqlCommands.size());
        for (String sqlCommand : sqlCommands) {
            DarwinStorage.SqlScriptStatus executionStatus;
            Integer occurrence = (Integer)executedCommands.get(sqlCommand);
            Integer newOccurrence = occurrence == null ? 1 : occurrence + 1;
            executedCommands.put(sqlCommand, newOccurrence);
            DarwinStorage.SqlScriptStatus sqlScriptStatus = executionStatus = patchAndSqlTableExists && patch.getPatchId() != null ? darwinStorage.wasSqlCommandAlreadyExecuted(patch.getPatchId(), sqlCommand, newOccurrence) : DarwinStorage.SqlScriptStatus.NOT_EXECUTED;
            if (executionStatus == DarwinStorage.SqlScriptStatus.EXECUTED_FINISHED) {
                log.info((Object)("Skipping (was already executed before) - occurrence " + newOccurrence + ":\n" + sqlCommand));
                continue;
            }
            log.info((Object)("Executing:\n" + sqlCommand));
            this.executeSqlCommand(patch, sqlCommand, darwinStorage, executionStatus);
        }
        long stop = System.currentTimeMillis();
        if (!patchAndSqlTableExists && this.storageChecker.existPatchAndSqlTable()) {
            Patch newPatch = darwinStorage.getPatchByResourcePath(resourcePath, componentName);
            newPatch.setProcessTime((int)(stop - start));
            newPatch.setFinishedOn(LocalDateTime.now());
            darwinStorage.markPatchAsFinished(newPatch);
        } else if (patchAndSqlTableExists) {
            patch.setProcessTime((int)(stop - start));
            patch.setFinishedOn(LocalDateTime.now());
            darwinStorage.markPatchAsFinished(patch);
        } else {
            throw new IllegalStateException("Infrastructural tables unexpectedly don't exist!");
        }
    }

    private void executeSqlCommand(final Patch patch, final String sqlStatement, final DarwinStorage darwinStorage, DarwinStorage.SqlScriptStatus executionStatus) {
        final long startScript = System.currentTimeMillis();
        try {
            String sqlCommandToExecute = this.removeCommentsFromContent(sqlStatement);
            if (patch.isInDb() && executionStatus == DarwinStorage.SqlScriptStatus.NOT_EXECUTED) {
                darwinStorage.insertSqlScriptToDB(patch, new SqlCommand(patch.getPatchId(), sqlStatement, 0L, LocalDateTime.now(), null));
            }
            this.jdbcTemplate.execute(sqlCommandToExecute);
            if (patch.isInDb()) {
                darwinStorage.updateSqlScriptInDB(patch, new SqlCommand(patch.getPatchId(), sqlStatement, System.currentTimeMillis() - startScript, LocalDateTime.now(), null));
            }
        }
        catch (DataAccessException ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Failed to execute script: " + sqlStatement), (Throwable)ex);
            }
            if (patch.isInDb()) {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                    public void afterCompletion(int status) {
                        if (status == 1) {
                            TransactionTemplate txTemplate = new TransactionTemplate(DefaultDatabaseStorageUpdater.this.transactionManager);
                            txTemplate.setPropagationBehavior(3);
                            txTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                                protected void doInTransactionWithoutResult(TransactionStatus status) {
                                    darwinStorage.updateSqlScriptInDB(patch, new SqlCommand(patch.getPatchId(), sqlStatement, System.currentTimeMillis() - startScript, null, (Exception)((Object)ex)));
                                }
                            });
                        }
                    }
                });
            }
            throw ex;
        }
    }

    protected String removeCommentsFromContent(String content) {
        if (content == null) {
            return null;
        }
        String processed = Pattern.compile("^\\s*+#.+?$", 8).matcher(content).replaceAll("");
        processed = Pattern.compile("^\\s*+--.+?$", 8).matcher(processed).replaceAll("");
        processed = Pattern.compile("^\\s*+/\\*.+?\\*/", 40).matcher(processed).replaceAll("");
        return processed;
    }
}

