/*
 * Decompiled with CFR 0.152.
 */
package one.edee.darwin.resources;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import one.edee.darwin.model.Platform;
import one.edee.darwin.model.ResourceVersionComparator;
import one.edee.darwin.resources.ResourceAccessor;
import one.edee.darwin.storage.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;

public class DefaultResourceAccessor
implements ResourceLoaderAware,
ResourceAccessor,
IOUtils {
    private static final Log log = LogFactory.getLog(DefaultResourceAccessor.class);
    private static final String DESCRIPTOR_FILE = "descriptor.txt";
    private static final char SEMICOLON = ';';
    private static final char SINGLE_APOSTROPHE = '\'';
    private static final char DOUBLE_APOSTROPHE = '\"';
    private static final char ESCAPE_CHAR = '\\';
    private static final char SLASH_CHAR = '/';
    private static final char HASH_CHAR = '#';
    private static final char DASH_CHAR = '-';
    private static final char STAR_CHAR = '*';
    private static final char EXCLAMATION_CHAR = '!';
    protected ResourceLoader resourceLoader;
    protected String encoding = "UTF-8";
    protected String resourcePath = "classpath:/META-INF/darwin/sql/";

    public DefaultResourceAccessor() {
    }

    public DefaultResourceAccessor(ResourceLoader resourceLoader, String encoding, String resourcePath) {
        this.resourceLoader = resourceLoader;
        this.encoding = encoding;
        this.resourcePath = resourcePath;
    }

    @Override
    public Resource[] getSortedResourceList(Platform platform) {
        String normalizedPath = this.normalizePath(this.resourcePath, platform.getFolderName(), true);
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.resourceLoader);
        return this.getResources(normalizedPath, resolver);
    }

    @Override
    public List<String> getTokenizedSQLScriptContentFromResource(String resourcePath) {
        String content = this.getTextContentFromResource(resourcePath);
        return this.tokenizeSQLScriptContent(content);
    }

    @Override
    public String getTextContentFromResource(String resourcePath) {
        String normalizedPath = this.normalizePath(this.resourcePath, resourcePath, false);
        normalizedPath = normalizedPath.replaceAll("\\*", "");
        Resource resource = this.resourceLoader.getResource(normalizedPath);
        return this.readResource(resourcePath, normalizedPath, resource);
    }

    protected List<String> tokenizeSQLScriptContent(String content) {
        Assert.notNull((Object)content, (String)"SQL content is NULL!");
        LinkedList<String> result = new LinkedList<String>();
        int contentLength = content.length();
        boolean inString = false;
        int stringStartIndex = -1;
        boolean inComment = false;
        boolean lineComment = false;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < contentLength; ++i) {
            char currentChar = content.charAt(i);
            if (!inString && this.isLineComment(content, i, currentChar)) {
                lineComment = true;
                inComment = true;
                ++i;
                continue;
            }
            if (currentChar == '\n' && lineComment) {
                lineComment = false;
                inComment = false;
                continue;
            }
            if (!inString && this.isOpeningBlockComment(content, i, currentChar)) {
                inComment = true;
                ++i;
                continue;
            }
            if (inComment && !lineComment && this.isClosingBlockComment(content, i, currentChar)) {
                inComment = false;
                ++i;
                continue;
            }
            if (!inComment && (this.isStringDelimiter(content, i, stringStartIndex, currentChar, '\'') || this.isStringDelimiter(content, i, stringStartIndex, currentChar, '\"'))) {
                inString = !inString;
                stringStartIndex = inString ? i : -1;
                buffer.append(currentChar);
                continue;
            }
            if (currentChar == ';' && !inString && !inComment) {
                if (this.isLineDelimiter(content, i, currentChar)) {
                    this.addQuery(result, buffer);
                    buffer.setLength(0);
                    continue;
                }
                buffer.append(currentChar);
                ++i;
                continue;
            }
            if (inComment) continue;
            buffer.append(currentChar);
        }
        this.addQuery(result, buffer);
        return result;
    }

    protected Resource[] getResources(String normalizedPath, PathMatchingResourcePatternResolver resolver) {
        Resource[] resources;
        block2: {
            resources = null;
            try {
                resources = resolver.getResources(normalizedPath + "*");
                Arrays.sort(resources, new ResourceVersionComparator());
            }
            catch (IOException ex) {
                resources = this.tryToFindResourceListInDescriptor(resolver, normalizedPath, resources);
                if (resources != null) break block2;
                String msg = "Cannot get list of available resources from '" + normalizedPath + "' for db autoupdate!";
                log.fatal((Object)msg);
                throw new RuntimeException(msg, ex);
            }
        }
        return resources;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String readResource(String resourceName, String normalizedPath, Resource resource) {
        if (!resource.exists()) {
            if (!log.isWarnEnabled()) return null;
            log.warn((Object)("Can not find resource: " + normalizedPath));
            return null;
        }
        try (InputStream is = resource.getInputStream();){
            String content = this.toString(is, Charset.forName(this.encoding)).trim();
            if (content.endsWith(";")) {
                String string = content.substring(0, content.length() - 1);
                return string;
            }
            String string = content;
            return string;
        }
        catch (IOException ex) {
            String msg = "Unexpectedly cannot read resource: " + normalizedPath + resourceName;
            log.fatal((Object)msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    protected Resource[] tryToFindResourceListInDescriptor(PathMatchingResourcePatternResolver resolver, String normalizedPath, Resource[] resources) {
        Resource resource = resolver.getResource(normalizedPath + DESCRIPTOR_FILE);
        if (resource.exists()) {
            try (InputStream is = resource.getInputStream();){
                String list = this.toString(is, Charset.forName(this.encoding));
                LinkedList<Resource> result = new LinkedList<Resource>();
                StringTokenizer st = new StringTokenizer(list, "\n", false);
                while (st.hasMoreTokens()) {
                    String item = st.nextToken();
                    Resource res = resolver.getResource(item.trim());
                    if (res.exists()) {
                        result.add(res);
                        continue;
                    }
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("Descriptor contains reference to resource: " + res.toString() + " but it does not exist!"));
                }
                resources = new Resource[result.size()];
                for (int i = 0; i < result.size(); ++i) {
                    Resource res;
                    resources[i] = res = (Resource)result.get(i);
                }
            }
            catch (IOException ex) {
                String msg = "Cannot open descriptor resource at path: " + normalizedPath + DESCRIPTOR_FILE;
                log.error((Object)msg);
                throw new RuntimeException(msg, ex);
            }
        }
        return resources;
    }

    protected String normalizePath(String resourcePath, String resourceName, boolean directory) {
        if (!resourcePath.endsWith("/")) {
            resourcePath = resourcePath + "/";
        }
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        String finalName = resourcePath + resourceName;
        return directory && !finalName.endsWith("/") ? finalName + "/" : finalName;
    }

    private boolean isLineComment(String content, int currentPos, char currentChar) {
        int nextChar = currentPos + 1 < content.length() ? (int)content.charAt(currentPos + 1) : 45;
        return currentChar == '#' || currentChar == '-' && nextChar == 45;
    }

    private boolean isOpeningBlockComment(String content, int currentPos, char currentChar) {
        int nextChar = currentPos + 1 < content.length() ? (int)content.charAt(currentPos + 1) : 45;
        int nextNextChar = currentPos + 2 < content.length() ? (int)content.charAt(currentPos + 2) : 45;
        return currentChar == '/' && nextChar == 42 && nextNextChar != 33;
    }

    private boolean isClosingBlockComment(String content, int currentPos, char currentChar) {
        int nextChar = currentPos + 1 < content.length() ? (int)content.charAt(currentPos + 1) : 45;
        return currentChar == '*' && nextChar == 47;
    }

    private void addQuery(List<String> result, StringBuilder buffer) {
        String query = buffer.toString().trim();
        if (query.length() > 0 && (query.length() != 1 || query.charAt(0) != ';')) {
            result.add(query);
        }
    }

    private boolean isStringDelimiter(String content, int currentPos, int stringStartIndex, char currentChar, char delimiterChar) {
        char prevChar = currentPos - 1 >= 0 ? (char)content.charAt(currentPos - 1) : (char)'-';
        char nextChar = currentPos + 1 < content.length() ? (char)content.charAt(currentPos + 1) : (char)'-';
        boolean isDelimiter = currentChar == delimiterChar;
        boolean isNotEscaped = prevChar != '\\';
        boolean isNotDuplicatedAndInsideString = (prevChar != delimiterChar || stringStartIndex == currentPos - 1) && nextChar != delimiterChar;
        boolean isTriplecatedInsideString = prevChar == delimiterChar && nextChar == delimiterChar;
        return isDelimiter && isNotEscaped && (isNotDuplicatedAndInsideString || isTriplecatedInsideString);
    }

    private boolean isLineDelimiter(String content, int currentPos, char currentChar) {
        int nextChar = currentPos + 1 < content.length() ? (int)content.charAt(currentPos + 1) : 45;
        return currentChar == ';' && nextChar != 59;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultResourceAccessor)) {
            return false;
        }
        DefaultResourceAccessor other = (DefaultResourceAccessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResourceLoader this$resourceLoader = this.getResourceLoader();
        ResourceLoader other$resourceLoader = other.getResourceLoader();
        if (this$resourceLoader == null ? other$resourceLoader != null : !this$resourceLoader.equals(other$resourceLoader)) {
            return false;
        }
        String this$encoding = this.getEncoding();
        String other$encoding = other.getEncoding();
        if (this$encoding == null ? other$encoding != null : !this$encoding.equals(other$encoding)) {
            return false;
        }
        String this$resourcePath = this.getResourcePath();
        String other$resourcePath = other.getResourcePath();
        return !(this$resourcePath == null ? other$resourcePath != null : !this$resourcePath.equals(other$resourcePath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultResourceAccessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResourceLoader $resourceLoader = this.getResourceLoader();
        result = result * 59 + ($resourceLoader == null ? 43 : $resourceLoader.hashCode());
        String $encoding = this.getEncoding();
        result = result * 59 + ($encoding == null ? 43 : $encoding.hashCode());
        String $resourcePath = this.getResourcePath();
        result = result * 59 + ($resourcePath == null ? 43 : $resourcePath.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultResourceAccessor(resourceLoader=" + this.getResourceLoader() + ", encoding=" + this.getEncoding() + ", resourcePath=" + this.getResourcePath() + ")";
    }
}

