/*
 * Decompiled with CFR 0.152.
 */
package one.edee.darwin.storage;

import java.util.Objects;
import javax.sql.DataSource;
import one.edee.darwin.model.Platform;
import one.edee.darwin.resources.DefaultResourceAccessor;
import one.edee.darwin.resources.ResourceAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

public abstract class AbstractDatabaseStorage
implements InitializingBean,
ResourceLoaderAware {
    private static final Log log = LogFactory.getLog(AbstractDatabaseStorage.class);
    protected final DefaultResourceAccessor dbResourceAccessor = new DefaultResourceAccessor();
    protected ResourceLoader resourceLoader;
    protected ResourceAccessor resourceAccessor;
    protected PlatformTransactionManager transactionManager;
    protected DataSource dataSource;
    protected JdbcTemplate jdbcTemplate;
    private Platform platform;

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.dataSource, (String)"Darwin needs DataSource to be not null!");
        Assert.notNull((Object)this.resourceAccessor, (String)"Darwin needs ResourceAccessor to be not null!");
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        this.dbResourceAccessor.setResourceLoader(resourceLoader);
    }

    public Platform getPlatform() {
        if (this.platform == null) {
            this.platform = Platform.getPlatformFromJdbcUrl(Objects.requireNonNull(this.dataSource));
        }
        return this.platform;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public ResourceAccessor getResourceAccessor() {
        return this.resourceAccessor;
    }

    public void setResourceAccessor(ResourceAccessor resourceAccessor) {
        this.resourceAccessor = resourceAccessor;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

