/*
 * Decompiled with CFR 0.152.
 */
package one.edee.darwin.model;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Optional;
import one.edee.darwin.model.version.VersionComparator;
import one.edee.darwin.model.version.VersionDescriptor;
import one.edee.darwin.resources.DefaultResourceNameAnalyzer;
import one.edee.darwin.resources.ResourceNameAnalyzer;
import org.springframework.core.io.Resource;

public class ResourceVersionComparator
implements Comparator<Resource>,
Serializable {
    private static final long serialVersionUID = -7943722730050082245L;
    private final ResourceNameAnalyzer resourceNameAnalyzer = new DefaultResourceNameAnalyzer();
    private final VersionComparator versionComparator = new VersionComparator();

    @Override
    public int compare(Resource o1, Resource o2) {
        String bFileName;
        if (o1 == null || o2 == null) {
            throw new IllegalArgumentException("Resources to be compared against cannot be null!");
        }
        VersionDescriptor v1 = this.resourceNameAnalyzer.getVersionFromResource(o1);
        VersionDescriptor v2 = this.resourceNameAnalyzer.getVersionFromResource(o2);
        if (v1 != null && v2 == null) {
            return 1;
        }
        if (v2 != null) {
            return this.versionComparator.compare(v1, v2);
        }
        String aFileName = Optional.ofNullable(o1.getFilename()).map(String::toLowerCase).orElse("");
        int result = aFileName.compareToIgnoreCase(bFileName = Optional.ofNullable(o2.getFilename()).map(String::toLowerCase).orElse(""));
        if (result > 0) {
            return 1;
        }
        if (result < 0) {
            return -1;
        }
        return result;
    }
}

