/*
 * Decompiled with CFR 0.152.
 */
package one.edee.darwin.resources;

import java.time.LocalDateTime;
import one.edee.darwin.model.InitiatingPatch;
import one.edee.darwin.model.Patch;
import one.edee.darwin.model.Platform;
import one.edee.darwin.resources.PatchType;
import one.edee.darwin.resources.ResourceMatcher;
import one.edee.darwin.resources.ResourceNameAnalyzer;
import one.edee.darwin.storage.DarwinStorage;
import one.edee.darwin.storage.StorageChecker;
import org.springframework.core.io.Resource;

public class ResourcePatchMediator {
    private final ResourceMatcher resourceMatcher;
    private final ResourceNameAnalyzer resourceNameAnalyzer;

    public ResourcePatchMediator(ResourceMatcher resourceMatcher, ResourceNameAnalyzer resourceNameAnalyzer) {
        this.resourceMatcher = resourceMatcher;
        this.resourceNameAnalyzer = resourceNameAnalyzer;
    }

    public Patch[] getPatches(Resource[] resources, String componentName, Platform platform, DarwinStorage darwinStorage, StorageChecker storageChecker, PatchType patchType) {
        Patch[] patches = new Patch[resources.length];
        if (storageChecker.existPatchAndSqlTable()) {
            boolean anyPatchRecordedFor = darwinStorage.isAnyPatchRecordedFor(componentName);
            for (int i = 0; i < resources.length; ++i) {
                Resource resource = resources[i];
                String patchName = this.resourceNameAnalyzer.getPatchNameFromResource(resource);
                boolean dbPatch = anyPatchRecordedFor && patchType == PatchType.EVOLVE && this.resourceMatcher.isResourceAcceptable(PatchType.EVOLVE, patchName);
                patches[i] = dbPatch ? this.convertToPatchPersistedInDatabase(resource, componentName, platform, darwinStorage) : this.convertToVirtualPatch(resource, componentName, platform);
            }
        } else {
            for (int i = 0; i < resources.length; ++i) {
                patches[i] = this.convertToVirtualPatch(resources[i], componentName, platform);
            }
        }
        return patches;
    }

    private Patch convertToVirtualPatch(Resource resource, String componentName, Platform platform) {
        return new Patch(this.resourceNameAnalyzer.getPatchNameFromResource(resource), componentName, platform, LocalDateTime.now());
    }

    private Patch convertToPatchPersistedInDatabase(Resource o, String componentName, Platform platform, DarwinStorage darwinStorage) {
        return new InitiatingPatch(this.resourceNameAnalyzer.getPatchNameFromResource(o), componentName, LocalDateTime.now(), platform, darwinStorage);
    }
}

