/*
 * Decompiled with CFR 0.152.
 */
package one.edee.darwin.resources;

import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import one.edee.darwin.resources.DefaultResourceAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ResourceLoader;

public class ScriptableResourceAccessor
extends DefaultResourceAccessor {
    private static final Log log = LogFactory.getLog(ScriptableResourceAccessor.class);
    private static final Configuration CONFIGURATION = new Configuration(Configuration.VERSION_2_3_28);
    private final SimpleHash vars = new SimpleHash(CONFIGURATION.getObjectWrapper());

    public ScriptableResourceAccessor() {
    }

    public ScriptableResourceAccessor(ResourceLoader resourceLoader, String encoding, String resourcePath) {
        super(resourceLoader, encoding, resourcePath);
    }

    public void setVars(Map<String, Object> vars) {
        this.vars.putAll(vars);
    }

    @Override
    public String getTextContentFromResource(String resourcePath) {
        String text = super.getTextContentFromResource(resourcePath);
        if (text == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Can not find resource: " + resourcePath));
            }
            return null;
        }
        try {
            Template template = new Template("darwinUpdateTempTemplate", (Reader)new StringReader(text), CONFIGURATION);
            StringWriter writer = new StringWriter(text.length() * 2);
            template.process((Object)this.vars, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            String msg = "Error in SQL script preprocessing: " + e.getMessage();
            log.fatal((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }
}

