/*
 * Decompiled with CFR 0.152.
 */
package one.edee.darwin.locker;

import one.edee.darwin.locker.Locker;
import one.edee.darwin.resources.ResourceAccessor;
import org.springframework.context.ApplicationContext;

public class LockerBuilder {
    private final ApplicationContext applicationContext;
    private boolean skipIfDataSourceNotPresent = true;
    private String dataSourceName = "dataSource";
    private String transactionManagerName = "transactionManager";
    private ResourceAccessor resourceAccessor;

    public LockerBuilder(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public LockerBuilder withSkipIfDataSourceNotPresent(boolean skipIfDataSourceNotPresent) {
        this.skipIfDataSourceNotPresent = skipIfDataSourceNotPresent;
        return this;
    }

    public LockerBuilder withDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
        return this;
    }

    public LockerBuilder withTransactionManagerName(String transactionManagerName) {
        this.transactionManagerName = transactionManagerName;
        return this;
    }

    public LockerBuilder withResourceAccessor(ResourceAccessor resourceAccessor) {
        this.resourceAccessor = resourceAccessor;
        return this;
    }

    public Locker build() {
        Locker locker = new Locker();
        locker.setApplicationContext(this.applicationContext);
        locker.setSkipIfDataSourceNotPresent(this.skipIfDataSourceNotPresent);
        locker.setDataSourceName(this.dataSourceName);
        locker.setTransactionManagerName(this.transactionManagerName);
        locker.setResourceAccessor(this.resourceAccessor);
        return locker;
    }
}

