/*
 * Decompiled with CFR 0.152.
 */
package one.edee.darwin.locker.internal;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.TimerTask;
import one.edee.darwin.exception.ProcessIsLockedException;
import one.edee.darwin.locker.LockRestorer;
import one.edee.darwin.locker.Locker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CheckLockTimerTask
extends TimerTask {
    private static final Log log = LogFactory.getLog(CheckLockTimerTask.class);
    private static final int MAX_RENEW_COUNT = 10;
    private final Locker locker;
    private final String processName;
    private final String unlockKey;
    private final long renewTime;
    private int renewCount;

    public CheckLockTimerTask(Locker locker, String processName, String unlockKey, long renewTime) {
        this.locker = locker;
        this.processName = processName;
        this.unlockKey = unlockKey;
        this.renewTime = renewTime;
    }

    @Override
    public void run() {
        block13: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("CheckLockTimerTask check lock of process: " + this.processName));
            }
            ++this.renewCount;
            if (this.renewCount > 10) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Count of renew gain max value. Lock is not renewed.");
                }
                this.cancel();
                return;
            }
            Map<String, LockRestorer> processMap = this.locker.getProcessMap();
            LockRestorer restorer = processMap.get(this.processName + this.unlockKey);
            if (restorer == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Process '" + this.processName + "' not found in processMap. Process was probably finished."));
                }
                this.cancel();
                return;
            }
            try {
                if (restorer.isFinished()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Process is finish. Don't renew a lock.");
                    }
                    processMap.remove(this.processName + this.unlockKey);
                    this.cancel();
                    return;
                }
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Cannot get status(running/finished) of process: " + this.processName), (Throwable)e);
                }
                processMap.remove(this.processName + this.unlockKey);
                this.cancel();
                return;
            }
            LocalDateTime until = LocalDateTime.now().plus(this.renewTime, ChronoUnit.MILLIS);
            try {
                if (log.isDebugEnabled()) {
                    SimpleDateFormat fmt = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                    log.debug((Object)("Process " + this.processName + " is renewed until " + fmt.format(until) + ""));
                }
                this.locker.renewLease(this.processName, this.unlockKey, until);
            }
            catch (ProcessIsLockedException e) {
                if (!log.isErrorEnabled()) break block13;
                log.error((Object)("Cannot renew lock for process: " + this.processName), (Throwable)e);
            }
        }
    }
}

