/*
 * Decompiled with CFR 0.152.
 */
package one.edee.darwin.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import one.edee.darwin.exception.DatabaseConnectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public enum Platform {
    MYSQL(Pattern.compile("jdbc:mysql:.*"), "mysql"),
    ORACLE(Pattern.compile("jdbc:oracle:.*"), "oracle"),
    MSSQL(Pattern.compile("jdbc:sqlserver:.*"), "mssql"),
    H2(Pattern.compile("jdbc:h2:.*"), "h2");

    private static final Log log;
    private static final Map<String, Platform> CACHED_RESULTS;
    private static final String JDBC_DRIVE_NAME_PREFIX = "jdbc:";
    private final Pattern jdbcUrlPattern;
    private final String folderName;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Platform getPlatformFromJdbcUrl(DataSource dataSource) {
        Platform result = CACHED_RESULTS.get(Integer.toString(dataSource.hashCode()));
        if (result == null) {
            try (Connection connection = dataSource.getConnection();){
                String driverName = connection.getMetaData().getURL();
                result = Platform.getPlatformFromJdbcUrl(driverName);
                if (result != null) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Recognized database platform: " + (Object)((Object)result)));
                    }
                } else if (log.isErrorEnabled()) {
                    log.error((Object)("Unrecognized database platform for driver: " + driverName));
                }
                if (result == null) return result;
                CACHED_RESULTS.put(Integer.toString(dataSource.hashCode()), result);
                return result;
            }
            catch (SQLException ex) {
                String msg = "Cannot connect to database.";
                log.fatal((Object)"Cannot connect to database.", (Throwable)ex);
                throw new DatabaseConnectionException(ex);
            }
        } else {
            if (!log.isTraceEnabled()) return result;
            log.trace((Object)("Returning previously recognized platform: " + (Object)((Object)result)));
            return result;
        }
    }

    private static Platform getPlatformFromJdbcUrl(String jdbcUrl) {
        for (Platform platform : Platform.values()) {
            if (!platform.getJdbcUrlPattern().matcher(jdbcUrl).matches()) continue;
            return platform;
        }
        return null;
    }

    public static Platform identify(String platform) {
        for (Platform platformEnum : Platform.values()) {
            if (!platformEnum.name().equals(platform) && !platformEnum.getFolderName().equals(platform)) continue;
            return platformEnum;
        }
        throw new IllegalArgumentException("Platform " + platform + " not recognized!");
    }

    private Platform(Pattern jdbcUrlPattern, String folderName) {
        this.jdbcUrlPattern = jdbcUrlPattern;
        this.folderName = folderName;
    }

    public Pattern getJdbcUrlPattern() {
        return this.jdbcUrlPattern;
    }

    public String getFolderName() {
        return this.folderName;
    }

    static {
        log = LogFactory.getLog(Platform.class);
        CACHED_RESULTS = new ConcurrentHashMap<String, Platform>();
    }
}

