/*
 * Decompiled with CFR 0.152.
 */
package one.edee.darwin;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDateTime;
import javax.sql.DataSource;
import one.edee.darwin.exception.ProcessIsLockedException;
import one.edee.darwin.locker.Locker;
import one.edee.darwin.model.Patch;
import one.edee.darwin.model.Platform;
import one.edee.darwin.model.SchemaVersion;
import one.edee.darwin.model.SchemaVersionProvider;
import one.edee.darwin.model.version.VersionComparator;
import one.edee.darwin.model.version.VersionDescriptor;
import one.edee.darwin.resources.DefaultResourceAccessor;
import one.edee.darwin.resources.DefaultResourceMatcher;
import one.edee.darwin.resources.DefaultResourceNameAnalyzer;
import one.edee.darwin.resources.PatchType;
import one.edee.darwin.resources.ResourceAccessor;
import one.edee.darwin.resources.ResourceMatcher;
import one.edee.darwin.resources.ResourceNameAnalyzer;
import one.edee.darwin.resources.ResourcePatchMediator;
import one.edee.darwin.storage.DarwinStorage;
import one.edee.darwin.storage.DefaultDatabaseDarwinStorage;
import one.edee.darwin.storage.DefaultDatabaseStorageChecker;
import one.edee.darwin.storage.DefaultDatabaseStorageUpdater;
import one.edee.darwin.storage.StorageChecker;
import one.edee.darwin.storage.StorageUpdater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class Darwin
implements InitializingBean,
ApplicationContextAware {
    private static final Log log = LogFactory.getLog(Darwin.class);
    public static final String DARWIN_COMPONENT_NAME = "darwin";
    public static final String DARWIN_COMPONENT_VERSION = "1.0";
    private String dataSourceName = "dataSource";
    private String transactionManagerName = "transactionManager";
    private ResourceAccessor resourceAccessor;
    private SchemaVersionProvider modelVersion;
    private boolean skipIfDataSourceNotPresent;
    private boolean switchOff;
    private Locker locker;
    private ResourceMatcher resourceMatcher = new DefaultResourceMatcher();
    private ResourceNameAnalyzer resourceNameAnalyzer = new DefaultResourceNameAnalyzer();
    private ResourcePatchMediator resourcePatchMediator;
    private DarwinStorage darwinStorage;
    private StorageUpdater storageUpdater;
    private StorageChecker storageChecker;
    private PlatformTransactionManager transactionManager;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void evolve() {
        this.afterPropertiesSet();
    }

    public void afterPropertiesSet() {
        this.initDefaults();
        if (!this.isSwitchOff()) {
            this.updateMyself();
            this.updateComponent(this.modelVersion.getComponentName(), this.modelVersion.getComponentVersion());
        }
    }

    public void initDefaults() {
        DataSource ds;
        boolean lockerPresent;
        if (this.resourceAccessor == null) {
            this.resourceAccessor = new DefaultResourceAccessor((ResourceLoader)this.applicationContext, "UTF-8", "classpath:/META-INF/darwin/sql/");
        }
        if (this.resourceMatcher == null) {
            this.resourceMatcher = new DefaultResourceMatcher();
        }
        if (this.resourceNameAnalyzer == null) {
            this.resourceNameAnalyzer = new DefaultResourceNameAnalyzer();
        }
        ConfigurableListableBeanFactory beanFactory = ((AbstractApplicationContext)this.applicationContext).getBeanFactory();
        boolean dataSourcePresent = beanFactory.containsBean(this.dataSourceName);
        boolean transactionManagerPresent = beanFactory.containsBean(this.transactionManagerName);
        boolean bl = lockerPresent = beanFactory.containsBean("locker") && beanFactory.getBean("locker") instanceof Locker;
        if (dataSourcePresent) {
            try {
                ds = (DataSource)this.applicationContext.getBean(this.dataSourceName, DataSource.class);
                Connection connection = ds.getConnection();
                Throwable throwable = null;
                if (connection != null) {
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
            catch (SQLException | NoSuchBeanDefinitionException e) {
                dataSourcePresent = false;
                transactionManagerPresent = false;
            }
        }
        if (dataSourcePresent) {
            ds = (DataSource)this.applicationContext.getBean(this.dataSourceName);
            this.transactionManager = transactionManagerPresent ? (PlatformTransactionManager)this.applicationContext.getBean(this.transactionManagerName) : null;
            this.resourcePatchMediator = new ResourcePatchMediator(this.resourceMatcher, this.resourceNameAnalyzer);
            if (this.storageChecker == null) {
                DefaultDatabaseStorageChecker defaultChecker = new DefaultDatabaseStorageChecker(this.resourcePatchMediator);
                defaultChecker.setDataSource(ds);
                defaultChecker.setTransactionManager(this.transactionManager);
                defaultChecker.setResourceAccessor(this.resourceAccessor);
                defaultChecker.setResourceMatcher(this.resourceMatcher);
                defaultChecker.setResourceNameAnalyzer(this.resourceNameAnalyzer);
                defaultChecker.setResourceLoader((ResourceLoader)this.applicationContext);
                this.storageChecker = defaultChecker;
            }
            if (this.darwinStorage == null) {
                DefaultDatabaseDarwinStorage defaultPersister = new DefaultDatabaseDarwinStorage(this.resourceNameAnalyzer, this.storageChecker);
                defaultPersister.setDataSource(ds);
                defaultPersister.setTransactionManager(this.transactionManager);
                defaultPersister.setResourceLoader((ResourceLoader)this.applicationContext);
                this.darwinStorage = defaultPersister;
            }
            if (this.storageUpdater == null) {
                DefaultDatabaseStorageUpdater defaultUpdater = new DefaultDatabaseStorageUpdater(this.storageChecker);
                defaultUpdater.setResourceAccessor(this.resourceAccessor);
                defaultUpdater.setDataSource(ds);
                defaultUpdater.setTransactionManager(this.transactionManager);
                defaultUpdater.setResourceLoader((ResourceLoader)this.applicationContext);
                this.storageUpdater = defaultUpdater;
            }
            if (this.locker == null) {
                if (lockerPresent) {
                    this.locker = (Locker)this.applicationContext.getBean("locker", Locker.class);
                } else {
                    this.locker = new Locker();
                    this.locker.setResourceAccessor(this.resourceAccessor);
                    this.locker.setApplicationContext(this.applicationContext);
                    this.locker.setSkipIfDataSourceNotPresent(this.skipIfDataSourceNotPresent);
                    this.locker.setDataSourceName(this.dataSourceName);
                    this.locker.setTransactionManagerName(this.transactionManagerName);
                    this.locker.afterPropertiesSet();
                }
            }
        } else {
            if (!this.skipIfDataSourceNotPresent) {
                throw new IllegalStateException("DataSource not accessible and skipIfDataSourceNotPresent flag is not set. Cannot perform database check (and possible update).");
            }
            this.switchOff = true;
        }
    }

    private void updateComponent(String componentName, String componentVersion) {
        this.updateComponent(componentName, componentVersion, this.resourceMatcher, this.resourceNameAnalyzer);
    }

    private void updateComponent(String componentName, String componentVersionString, ResourceMatcher resourceMatcher, ResourceNameAnalyzer resourceNameAnalyzer) {
        if (this.switchOff) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Darwin is switched off - no data source accessible.");
            }
        } else {
            VersionComparator versionComparator = new VersionComparator();
            VersionDescriptor lastStoredVersion = this.darwinStorage.getVersionDescriptorForComponent(componentName);
            VersionDescriptor currentVersion = new VersionDescriptor(componentVersionString);
            this.ensureRunsUniquely(componentName, lastStoredVersion, versionComparator, () -> this.doUpdateComponent(lastStoredVersion, componentName, resourceMatcher, versionComparator, currentVersion, resourceNameAnalyzer));
        }
    }

    private void updateMyself() {
        DefaultResourceAccessor resourceAccessor = new DefaultResourceAccessor((ResourceLoader)this.applicationContext, "UTF-8", "classpath:/META-INF/lib_db_darwin/sql/");
        SchemaVersion myVersion = new SchemaVersion(DARWIN_COMPONENT_NAME, DARWIN_COMPONENT_VERSION);
        Darwin meUpdater = new Darwin();
        meUpdater.setApplicationContext(this.applicationContext);
        meUpdater.setModelVersion(myVersion);
        meUpdater.setDataSourceName(this.dataSourceName);
        meUpdater.setTransactionManagerName(this.transactionManagerName);
        meUpdater.setSkipIfDataSourceNotPresent(this.skipIfDataSourceNotPresent);
        meUpdater.setResourceAccessor(resourceAccessor);
        meUpdater.initDefaults();
        this.updateComponent(myVersion.getComponentName(), myVersion.getComponentVersion());
    }

    private void doUpdateComponent(VersionDescriptor lastStoredVersion, String componentName, ResourceMatcher resourceMatcher, VersionComparator versionComparator, VersionDescriptor currentVersion, ResourceNameAnalyzer resourceNameAnalyzer) {
        Platform platform = this.storageChecker.getPlatform();
        TransactionTemplate transaction = new TransactionTemplate(this.transactionManager);
        VersionDescriptor storedVersion = (VersionDescriptor)transaction.execute(status -> {
            VersionDescriptor resultVersion = lastStoredVersion;
            if (resultVersion == null) {
                if (this.storageChecker != null) {
                    resultVersion = this.storageChecker.guessVersion(componentName, this.darwinStorage);
                    log.info((Object)("No version record found for this component. Guess script detected version: " + resultVersion));
                }
                if (resultVersion == null) {
                    this.createNewStorage(componentName, platform, resourceMatcher);
                } else {
                    log.info((Object)("There already exists version " + resultVersion + " of the component in database. Guess script matched it. Storing info to database."));
                    this.darwinStorage.updateVersionDescriptorForComponent(componentName, resultVersion.toString());
                }
            }
            return resultVersion;
        });
        this.updateStorage(storedVersion, componentName, currentVersion, platform, resourceMatcher, resourceNameAnalyzer, versionComparator);
    }

    private void updateStorage(final VersionDescriptor lastStoredVersion, final String componentName, final VersionDescriptor currentVersion, Platform platform, final ResourceMatcher resourceMatcher, final ResourceNameAnalyzer resourceNameAnalyzer, final VersionComparator versionComparator) {
        Patch[] patches = this.resourcePatchMediator.getPatches(this.resourceAccessor.getSortedResourceList(platform), componentName, platform, this.darwinStorage, this.storageChecker, PatchType.EVOLVE);
        if (patches != null) {
            this.fillMissingPatchesForComponentsCreatedBeforePatchTableWasAvailable(patches, componentName, versionComparator, lastStoredVersion);
            for (final Patch patch : patches) {
                TransactionTemplate transaction = new TransactionTemplate(this.transactionManager);
                transaction.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        if ((resourceMatcher.isResourceAcceptable(PatchType.EVOLVE, patch.getPatchName()) || resourceMatcher.isResourceAcceptable(PatchType.CREATE, patch.getPatchName())) && versionComparator.compare(resourceNameAnalyzer.getVersionFromPatch(patch), currentVersion) <= 0 && !Darwin.this.darwinStorage.isPatchFinishedInDb(patch)) {
                            VersionDescriptor resourceVersion = resourceNameAnalyzer.getVersionFromPatch(patch);
                            try {
                                if (Darwin.this.storageChecker.guessPatchAlreadyApplied(componentName, Darwin.this.darwinStorage, resourceVersion)) {
                                    log.info((Object)("Component " + componentName + " marked as updated to version " + resourceVersion + " because guessing logic matched database contents."));
                                    Darwin.this.darwinStorage.markPatchAsFinished(patch);
                                } else {
                                    Darwin.this.storageUpdater.executeScript(patch.getResourcesPath(), componentName, Darwin.this.darwinStorage, Darwin.this.storageChecker);
                                    log.info((Object)("Component " + componentName + " storage updated to version " + resourceVersion + "."));
                                }
                                if ((lastStoredVersion == null || versionComparator.compare(resourceVersion, lastStoredVersion) > 0) && resourceVersion != null) {
                                    Darwin.this.darwinStorage.updateVersionDescriptorForComponent(componentName, resourceVersion.toString());
                                }
                            }
                            catch (Exception ex) {
                                log.error((Object)("Failed to update " + componentName + " storage to version " + resourceVersion + ": " + ex.getMessage()));
                                throw ex;
                            }
                        }
                    }
                });
            }
        }
    }

    private void fillMissingPatchesForComponentsCreatedBeforePatchTableWasAvailable(final Patch[] patches, String componentName, final VersionComparator versionComparator, final VersionDescriptor storedVersion) {
        if (storedVersion != null && this.storageChecker.existPatchAndSqlTable()) {
            if (this.darwinStorage.isAnyPatchRecordedFor(componentName)) {
                for (final Patch patch : patches) {
                    if (!this.resourceMatcher.isResourceAcceptable(PatchType.CREATE, patch.getPatchName()) || this.darwinStorage.isPatchRecordedByResourcePath(patch.getResourcesPath(), patch.getComponentName())) continue;
                    TransactionTemplate transaction = new TransactionTemplate(this.transactionManager);
                    transaction.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                        protected void doInTransactionWithoutResult(TransactionStatus status) {
                            Darwin.this.darwinStorage.markPatchAsFinished(Darwin.this.darwinStorage.insertPatchToDatabase(patch.getPatchName(), patch.getComponentName(), LocalDateTime.now(), Darwin.this.storageChecker.getPlatform()));
                        }
                    });
                }
            } else {
                TransactionTemplate transaction = new TransactionTemplate(this.transactionManager);
                transaction.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        for (Patch patch : patches) {
                            if (!Darwin.this.resourceMatcher.isResourceAcceptable(PatchType.EVOLVE, patch.getPatchName()) && !Darwin.this.resourceMatcher.isResourceAcceptable(PatchType.CREATE, patch.getPatchName()) || versionComparator.compare(Darwin.this.resourceNameAnalyzer.getVersionFromPatch(patch), storedVersion) > 0) continue;
                            Darwin.this.darwinStorage.markPatchAsFinished(Darwin.this.darwinStorage.insertPatchToDatabase(patch.getPatchName(), patch.getComponentName(), LocalDateTime.now(), Darwin.this.storageChecker.getPlatform()));
                        }
                    }
                });
            }
        }
    }

    private void createNewStorage(final String componentName, Platform platform, final ResourceMatcher resourceMatcher) {
        Patch[] patches;
        if (log.isDebugEnabled()) {
            log.debug((Object)("No component " + componentName + " storage found. Creating new one."));
        }
        if ((patches = this.resourcePatchMediator.getPatches(this.resourceAccessor.getSortedResourceList(platform), componentName, platform, this.darwinStorage, this.storageChecker, PatchType.CREATE)) != null) {
            for (final Patch patch : patches) {
                TransactionTemplate transaction = new TransactionTemplate(this.transactionManager);
                transaction.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        if (resourceMatcher.isResourceAcceptable(PatchType.CREATE, patch.getPatchName())) {
                            try {
                                Darwin.this.storageUpdater.executeScript(patch.getResourcesPath(), componentName, Darwin.this.darwinStorage, Darwin.this.storageChecker);
                                log.info((Object)("Component " + componentName + " initial version of storage created."));
                            }
                            catch (Exception ex) {
                                log.error((Object)("Failed to create initial version of " + componentName + " storage: " + ex.getMessage()));
                                throw ex;
                            }
                        }
                    }
                });
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating new storage for component " + componentName + " finished."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureRunsUniquely(String componentName, VersionDescriptor existingVersion, VersionComparator comparator, Runnable logic) {
        String processName = this.getLockProcessName(componentName);
        String unlockKey = null;
        try {
            unlockKey = this.acquireProcessLockKey(componentName, existingVersion, comparator, processName);
            logic.run();
        }
        catch (ProcessIsLockedException ignored) {
            String msg = "Skipping darwin - another thread is performing darwin for component " + componentName;
            log.error((Object)msg);
        }
        finally {
            if (unlockKey != null) {
                try {
                    this.locker.releaseProcess(processName, unlockKey);
                }
                catch (ProcessIsLockedException e) {
                    throw new IllegalStateException("Process " + processName + " cannot be unlocked with " + unlockKey + " key!", e);
                }
            }
        }
    }

    private String acquireProcessLockKey(String componentName, VersionDescriptor storedVersion, VersionComparator versionComparator, String processName) throws ProcessIsLockedException {
        String unlockKey = null;
        if (this.lockFunctionalityAvailable(componentName, storedVersion, versionComparator)) {
            int i = 0;
            ProcessIsLockedException lastException = null;
            while (unlockKey == null && i < 20) {
                try {
                    ++i;
                    unlockKey = this.locker.leaseProcess(processName, LocalDateTime.now().plusMinutes(2L), 5000);
                }
                catch (ProcessIsLockedException ex) {
                    lastException = ex;
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Process " + processName + " is currently locked ... try " + i + " out of " + 20));
                }
            }
            if (unlockKey == null && lastException != null) {
                throw lastException;
            }
        }
        return unlockKey;
    }

    private boolean lockFunctionalityAvailable(String componentName, VersionDescriptor storedVersion, VersionComparator versionComparator) {
        return !DARWIN_COMPONENT_NAME.equals(componentName) || storedVersion != null && versionComparator.compare(storedVersion, new VersionDescriptor("1.1")) >= 1;
    }

    private String getLockProcessName(String componentName) {
        return componentName + ":darwinProcess";
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getTransactionManagerName() {
        return this.transactionManagerName;
    }

    public void setTransactionManagerName(String transactionManagerName) {
        this.transactionManagerName = transactionManagerName;
    }

    public ResourceAccessor getResourceAccessor() {
        return this.resourceAccessor;
    }

    public void setResourceAccessor(ResourceAccessor resourceAccessor) {
        this.resourceAccessor = resourceAccessor;
    }

    public SchemaVersionProvider getModelVersion() {
        return this.modelVersion;
    }

    public void setModelVersion(SchemaVersionProvider modelVersion) {
        this.modelVersion = modelVersion;
    }

    public boolean isSkipIfDataSourceNotPresent() {
        return this.skipIfDataSourceNotPresent;
    }

    public void setSkipIfDataSourceNotPresent(boolean skipIfDataSourceNotPresent) {
        this.skipIfDataSourceNotPresent = skipIfDataSourceNotPresent;
    }

    public boolean isSwitchOff() {
        return this.switchOff;
    }

    public void setSwitchOff(boolean switchOff) {
        this.switchOff = switchOff;
    }

    public Locker getLocker() {
        return this.locker;
    }

    public void setLocker(Locker locker) {
        this.locker = locker;
    }

    public ResourceMatcher getResourceMatcher() {
        return this.resourceMatcher;
    }

    public void setResourceMatcher(ResourceMatcher resourceMatcher) {
        this.resourceMatcher = resourceMatcher;
    }

    public ResourceNameAnalyzer getResourceNameAnalyzer() {
        return this.resourceNameAnalyzer;
    }

    public void setResourceNameAnalyzer(ResourceNameAnalyzer resourceNameAnalyzer) {
        this.resourceNameAnalyzer = resourceNameAnalyzer;
    }

    public ResourcePatchMediator getResourcePatchMediator() {
        return this.resourcePatchMediator;
    }

    public void setResourcePatchMediator(ResourcePatchMediator resourcePatchMediator) {
        this.resourcePatchMediator = resourcePatchMediator;
    }

    public DarwinStorage getDarwinStorage() {
        return this.darwinStorage;
    }

    public void setDarwinStorage(DarwinStorage darwinStorage) {
        this.darwinStorage = darwinStorage;
    }

    public StorageUpdater getStorageUpdater() {
        return this.storageUpdater;
    }

    public void setStorageUpdater(StorageUpdater storageUpdater) {
        this.storageUpdater = storageUpdater;
    }

    public StorageChecker getStorageChecker() {
        return this.storageChecker;
    }

    public void setStorageChecker(StorageChecker storageChecker) {
        this.storageChecker = storageChecker;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

