/*
 * Decompiled with CFR 0.152.
 */
package one.edee.darwin;

import one.edee.darwin.Darwin;
import one.edee.darwin.locker.Locker;
import one.edee.darwin.model.SchemaVersion;
import one.edee.darwin.model.SchemaVersionProvider;
import one.edee.darwin.resources.DefaultResourceAccessor;
import one.edee.darwin.resources.DefaultResourceMatcher;
import one.edee.darwin.resources.DefaultResourceNameAnalyzer;
import one.edee.darwin.resources.ResourceAccessor;
import one.edee.darwin.resources.ResourceMatcher;
import one.edee.darwin.resources.ResourceNameAnalyzer;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ResourceLoader;

public class DarwinBuilder {
    private final ApplicationContext ctx;
    private final SchemaVersionProvider componentDescriptor;
    private ResourceAccessor resourceAccessor;
    private boolean skipIfDataSourceNotPresent;
    private ResourceMatcher resourceMatcher = new DefaultResourceMatcher();
    private ResourceNameAnalyzer resourceNameAnalyzer = new DefaultResourceNameAnalyzer();
    private Locker locker;
    private String dataSourceName = "dataSource";
    private String transactionManagerName = "transactionManager";

    public DarwinBuilder(ApplicationContext ctx, String componentName, String componentVersion) {
        this.ctx = ctx;
        this.componentDescriptor = new SchemaVersion(componentName, componentVersion);
    }

    public DarwinBuilder withResourcePath(String resourcePath) {
        this.resourceAccessor = new DefaultResourceAccessor((ResourceLoader)this.ctx, "UTF-8", resourcePath);
        return this;
    }

    public DarwinBuilder withResourceAccessor(ResourceAccessor resourceAccessor) {
        this.resourceAccessor = resourceAccessor;
        return this;
    }

    public DarwinBuilder withSkipIfDataSourceNotPresent(boolean skipIfDataSourceNotPresent) {
        this.skipIfDataSourceNotPresent = skipIfDataSourceNotPresent;
        return this;
    }

    public DarwinBuilder withResourceMatcher(ResourceMatcher resourceMatcher) {
        this.resourceMatcher = resourceMatcher;
        return this;
    }

    public DarwinBuilder withResourceNameAnalyzer(ResourceNameAnalyzer resourceNameAnalyzer) {
        this.resourceNameAnalyzer = resourceNameAnalyzer;
        return this;
    }

    public DarwinBuilder withDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
        return this;
    }

    public DarwinBuilder withTransactionManagerName(String transactionManagerName) {
        this.transactionManagerName = transactionManagerName;
        return this;
    }

    public DarwinBuilder withLocker(Locker locker) {
        this.locker = locker;
        return this;
    }

    public Darwin build() {
        Darwin darwin = new Darwin();
        darwin.setApplicationContext(this.ctx);
        darwin.setSkipIfDataSourceNotPresent(this.skipIfDataSourceNotPresent);
        darwin.setResourceMatcher(this.resourceMatcher);
        darwin.setResourceNameAnalyzer(this.resourceNameAnalyzer);
        darwin.setResourceAccessor(this.resourceAccessor);
        darwin.setModelVersion(this.componentDescriptor);
        darwin.setDataSourceName(this.dataSourceName);
        darwin.setTransactionManagerName(this.transactionManagerName);
        darwin.setLocker(this.locker);
        return darwin;
    }
}

