/*
 * Decompiled with CFR 0.152.
 */
package one.edee.darwin.locker;

import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import one.edee.darwin.exception.ProcessIsLockedException;
import one.edee.darwin.locker.InstanceIdProvider;
import one.edee.darwin.locker.LockRestorer;
import one.edee.darwin.locker.internal.CheckLockTimerTask;
import one.edee.darwin.model.LockState;
import one.edee.darwin.resources.DefaultResourceAccessor;
import one.edee.darwin.resources.ResourceAccessor;
import one.edee.darwin.storage.DefaultDatabaseLockStorage;
import one.edee.darwin.storage.LockStorage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

public class Locker
implements InitializingBean,
ApplicationContextAware {
    private static final Log log = LogFactory.getLog(Locker.class);
    private static final float CHECK_RENEW_RATIO = 0.7f;
    private final Map<String, LockRestorer> processMap = new ConcurrentHashMap<String, LockRestorer>();
    private boolean skipIfDataSourceNotPresent = true;
    private String dataSourceName = "dataSource";
    private String transactionManagerName = "transactionManager";
    private String preferredScheduledExecutorService;
    private String preferredInstanceIdProvider;
    private int retryTimes = 20;
    private long defaultRetryWaitTime = 3000L;
    private ApplicationContext applicationContext;
    private LockStorage lockStorage;
    private ResourceAccessor resourceAccessor;
    private ScheduledExecutorService scheduledExecutorService;
    private InstanceIdProvider instanceIdProvider;
    private boolean switchOff;

    public static LockStorage createDefaultLockStorage(DataSource ds, PlatformTransactionManager transactionManager, ResourceAccessor resourceAccessor, ResourceLoader resourceLoader) {
        DefaultDatabaseLockStorage lockPersister = new DefaultDatabaseLockStorage();
        lockPersister.setResourceAccessor(resourceAccessor);
        lockPersister.setDataSource(ds);
        lockPersister.setTransactionManager(transactionManager);
        lockPersister.setResourceLoader(resourceLoader);
        TransactionTemplate transactionTemplate = new TransactionTemplate(transactionManager);
        transactionTemplate.setPropagationBehavior(4);
        lockPersister.setTransactionTemplate(transactionTemplate);
        return lockPersister;
    }

    public void afterPropertiesSet() {
        if (this.resourceAccessor == null) {
            this.resourceAccessor = new DefaultResourceAccessor((ResourceLoader)this.applicationContext, "UTF-8", "classpath:/META-INF/darwin/sql/");
        }
        ConfigurableListableBeanFactory beanFactory = ((AbstractApplicationContext)this.applicationContext).getBeanFactory();
        boolean dataSourcePresent = beanFactory.containsBean(this.dataSourceName);
        boolean transactionManagerPresent = beanFactory.containsBean(this.transactionManagerName);
        if (dataSourcePresent) {
            PlatformTransactionManager transactionManager;
            DataSource ds = (DataSource)this.applicationContext.getBean(this.dataSourceName);
            PlatformTransactionManager platformTransactionManager = transactionManager = transactionManagerPresent ? (PlatformTransactionManager)this.applicationContext.getBean(this.transactionManagerName) : null;
            if (this.lockStorage == null) {
                this.lockStorage = Locker.createDefaultLockStorage(ds, transactionManager, this.resourceAccessor, (ResourceLoader)this.applicationContext);
            }
        } else if (this.skipIfDataSourceNotPresent) {
            this.switchOff = true;
        } else {
            throw new IllegalStateException("DataSource not accessible and skipIfDataSourceNotPresent flag is not set. Cannot perform database locking.");
        }
    }

    public boolean canLease(String processName) {
        return this.lockStorage.getProcessLock(processName, this.normalizeDate(LocalDateTime.now())) != LockState.LEASED;
    }

    public String leaseProcess(String processName, LocalDateTime until, int waitForLockInMilliseconds) throws ProcessIsLockedException {
        return this.doWithRetry(() -> {
            try {
                return this.leaseProcess(processName, until);
            }
            catch (ProcessIsLockedException e) {
                throw new RuntimeException(e);
            }
        }, waitForLockInMilliseconds, this.retryTimes);
    }

    public String leaseProcess(String processName, LocalDateTime until) throws ProcessIsLockedException {
        this.checkStatus();
        this.checkExistingLock(processName);
        try {
            until = this.normalizeDate(until);
            String unlockKey = this.enhanceUnlockKey(Long.toHexString(System.currentTimeMillis()));
            LockState lockState = this.lockStorage.createLock(processName, until, unlockKey);
            Assert.isTrue((lockState == LockState.LEASED ? 1 : 0) != 0, (String)"Lock was not created!");
            String cleanedUnlockKey = this.cleanUnlockKey(unlockKey);
            if (log.isDebugEnabled()) {
                SimpleDateFormat fmt = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                log.debug((Object)("Process " + processName + " locked with unlockKey " + cleanedUnlockKey + " until " + fmt.format(until)));
            }
            return cleanedUnlockKey;
        }
        catch (DataIntegrityViolationException ex) {
            String msg = "Process " + processName + " has a foreign valid lock. Cannot register new one!";
            log.warn((Object)msg);
            throw new ProcessIsLockedException(msg);
        }
    }

    public String leaseProcess(String processName, LocalDateTime until, LockRestorer lockerRestorer) throws ProcessIsLockedException {
        String unlockKey = this.leaseProcess(processName, until);
        this.setupCheckLockTimerTask(processName, until, lockerRestorer, LocalDateTime.now(), this.enhanceUnlockKey(unlockKey));
        return this.cleanUnlockKey(unlockKey);
    }

    public String leaseProcess(String processName, LocalDateTime until, int waitForLockInMilliseconds, LockRestorer lockerRestorer) throws ProcessIsLockedException {
        String unlockKey = this.leaseProcess(processName, until, waitForLockInMilliseconds);
        this.setupCheckLockTimerTask(processName, until, lockerRestorer, LocalDateTime.now(), this.enhanceUnlockKey(unlockKey));
        return this.cleanUnlockKey(unlockKey);
    }

    public void renewLease(String processName, String unlockKey, LocalDateTime until) throws ProcessIsLockedException {
        String enhancedUnlockKey = this.enhanceUnlockKey(unlockKey);
        this.checkStatus();
        this.doWithRetry(() -> {
            LocalDateTime normalizedUntil = this.normalizeDate(until);
            LockState result = this.lockStorage.renewLease(processName, enhancedUnlockKey, normalizedUntil);
            if (result == LockState.AVAILABLE) {
                String msg = "Failed renew lock, process is locked with different unlock key, or lock does not exist!";
                log.error((Object)"Failed renew lock, process is locked with different unlock key, or lock does not exist!");
                throw new RuntimeException(new ProcessIsLockedException("Failed renew lock, process is locked with different unlock key, or lock does not exist!"));
            }
            return null;
        }, this.defaultRetryWaitTime, this.retryTimes);
    }

    public int releaseProcessesForInstance() {
        String instanceId = this.getInstanceId();
        List<String> processesToRemove = this.processMap.keySet().stream().filter(i -> i.endsWith(instanceId)).collect(Collectors.toList());
        processesToRemove.forEach(this.processMap::remove);
        int removedLocks = this.lockStorage.releaseProcessesForInstance(instanceId);
        if (removedLocks > 0) {
            log.info((Object)("Removed " + removedLocks + " old locks for instance `" + instanceId + "`"));
        }
        return removedLocks;
    }

    public void releaseProcess(String processName, String unlockKey) throws ProcessIsLockedException {
        String enhancedUnlockKey = this.enhanceUnlockKey(unlockKey);
        this.checkStatus();
        this.doWithRetry(() -> {
            if (processName == null) {
                String msg = "Cannot release process without a processName (method was called with null processName).";
                log.error((Object)msg);
                throw new IllegalArgumentException(msg);
            }
            if (enhancedUnlockKey == null) {
                String msg = "Cannot release process without an unlockKey (method was called with null unlockKey).";
                log.error((Object)msg);
                throw new IllegalArgumentException(msg);
            }
            this.processMap.remove(processName + enhancedUnlockKey);
            LockState lockState = this.lockStorage.releaseProcess(processName, enhancedUnlockKey);
            Assert.isTrue((lockState == LockState.AVAILABLE ? 1 : 0) != 0, (String)"Lock was not released!");
            return null;
        }, this.defaultRetryWaitTime, this.retryTimes);
    }

    private void setupCheckLockTimerTask(String processName, LocalDateTime until, LockRestorer lockerRestorer, LocalDateTime now, String unlockKey) {
        if (lockerRestorer != null) {
            long delayTime = this.getDelayTimeInMilliseconds(now, until);
            long renewTime = Duration.between(now, until).toMillis();
            this.processMap.put(processName + unlockKey, lockerRestorer);
            CheckLockTimerTask timerTask = new CheckLockTimerTask(this, processName, unlockKey, renewTime);
            if (this.scheduledExecutorService == null) {
                Map scheduledExecutors = this.applicationContext.getBeansOfType(ScheduledExecutorService.class);
                if (!scheduledExecutors.isEmpty()) {
                    this.scheduledExecutorService = scheduledExecutors.size() == 1 ? (ScheduledExecutorService)scheduledExecutors.values().iterator().next() : (ScheduledExecutorService)scheduledExecutors.get(this.preferredScheduledExecutorService);
                }
                Assert.notNull((Object)this.scheduledExecutorService, (String)"Scheduled executor service not found!");
            }
            this.scheduledExecutorService.scheduleAtFixedRate(timerTask, delayTime, renewTime, TimeUnit.MILLISECONDS);
        }
    }

    private String cleanUnlockKey(String unlockKey) {
        if (unlockKey == null) {
            return null;
        }
        return unlockKey.replace(this.getInstanceId(), "");
    }

    private String enhanceUnlockKey(String unlockKey) {
        if (unlockKey == null || unlockKey.endsWith(this.getInstanceId())) {
            return unlockKey;
        }
        return unlockKey + this.getInstanceId();
    }

    private String getInstanceId() {
        return "_" + this.getInstanceIdProvider().getInstanceId();
    }

    private InstanceIdProvider getInstanceIdProvider() {
        if (this.instanceIdProvider == null) {
            Map instanceIdProviders = this.applicationContext.getBeansOfType(InstanceIdProvider.class);
            if (!instanceIdProviders.isEmpty()) {
                this.instanceIdProvider = instanceIdProviders.size() == 1 ? (InstanceIdProvider)instanceIdProviders.values().iterator().next() : (InstanceIdProvider)instanceIdProviders.get(this.preferredInstanceIdProvider);
            }
            if (this.instanceIdProvider == null) {
                this.instanceIdProvider = () -> "DEFAULT";
            }
        }
        return this.instanceIdProvider;
    }

    private long getDelayTimeInMilliseconds(LocalDateTime now, LocalDateTime until) {
        long millis = (long)((float)Duration.between(now, until).toMillis() * 0.7f);
        if (millis > 0L) {
            return millis;
        }
        return 0L;
    }

    private void checkExistingLock(String processName) throws ProcessIsLockedException {
        this.checkStatus();
        LockState lockState = this.lockStorage.getProcessLock(processName, this.normalizeDate(LocalDateTime.now()));
        if (lockState == LockState.LEASED) {
            String msg = "Process " + processName + " has a foreign valid lock. Cannot register new one!";
            log.info((Object)msg);
            throw new ProcessIsLockedException(msg);
        }
        if (lockState == LockState.LEASED_EXPIRED) {
            LockState theLockState;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Releasing expired lock for process " + processName));
            }
            Assert.isTrue(((theLockState = this.lockStorage.releaseProcess(processName, null)) == LockState.AVAILABLE ? 1 : 0) != 0, (String)"Lock was not released!");
        }
    }

    private LocalDateTime normalizeDate(LocalDateTime until) {
        Duration diff = Duration.between(LocalDateTime.now(), until);
        LocalDateTime databaseTime = this.lockStorage.getCurrentDatabaseTime();
        return databaseTime.plus(diff);
    }

    private void checkStatus() {
        if (this.switchOff) {
            String msg = "Locker is switched off - no data source accessible.";
            log.error((Object)msg);
            throw new IllegalStateException(msg);
        }
    }

    private <T> T doWithRetry(Supplier<T> supplier, long waitForLockInMilliseconds, int times) throws ProcessIsLockedException {
        for (int i = 1; i <= times; ++i) {
            try {
                return supplier.get();
            }
            catch (RuntimeException ex) {
                if (ex.getCause() instanceof ProcessIsLockedException) {
                    log.info((Object)("Lock is already leased, waiting " + waitForLockInMilliseconds + " milliseconds to get it."));
                } else {
                    log.warn((Object)("Exception was returned: " + ex.getMessage() + ". Waiting " + waitForLockInMilliseconds + " milliseconds to retry the attempt."));
                }
                try {
                    Thread.sleep(waitForLockInMilliseconds);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (i < times) continue;
                if (ex.getCause() instanceof ProcessIsLockedException) {
                    throw (ProcessIsLockedException)ex.getCause();
                }
                throw ex;
            }
        }
        throw new IllegalStateException("Not expected to reach there - either exception should be already thrown or result should be returned!");
    }

    public Map<String, LockRestorer> getProcessMap() {
        return this.processMap;
    }

    public void setSkipIfDataSourceNotPresent(boolean skipIfDataSourceNotPresent) {
        this.skipIfDataSourceNotPresent = skipIfDataSourceNotPresent;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public void setTransactionManagerName(String transactionManagerName) {
        this.transactionManagerName = transactionManagerName;
    }

    public void setPreferredScheduledExecutorService(String preferredScheduledExecutorService) {
        this.preferredScheduledExecutorService = preferredScheduledExecutorService;
    }

    public void setPreferredInstanceIdProvider(String preferredInstanceIdProvider) {
        this.preferredInstanceIdProvider = preferredInstanceIdProvider;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public void setDefaultRetryWaitTime(long defaultRetryWaitTime) {
        this.defaultRetryWaitTime = defaultRetryWaitTime;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setLockStorage(LockStorage lockStorage) {
        this.lockStorage = lockStorage;
    }

    public void setResourceAccessor(ResourceAccessor resourceAccessor) {
        this.resourceAccessor = resourceAccessor;
    }
}

