/*
 * Decompiled with CFR 0.152.
 */
package one.edee.darwin.model;

import java.time.LocalDateTime;
import one.edee.darwin.exception.PatchFormatException;
import one.edee.darwin.model.Platform;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Patch {
    private static final Log log = LogFactory.getLog(Patch.class);
    private final Integer patchId;
    private final String patchName;
    private final String componentName;
    private final LocalDateTime detectedOn;
    private final Platform platform;
    private int processTime;
    private LocalDateTime finishedOn;

    public Patch(Integer patchId, String patchName, String componentName, LocalDateTime detectedOn, Platform platform) {
        this.validatePatch(patchId, patchName, componentName, detectedOn, platform);
        this.patchId = patchId;
        this.patchName = patchName;
        this.componentName = componentName;
        this.detectedOn = detectedOn;
        this.platform = platform;
    }

    public Patch(Integer patchId, String patchName, String componentName, LocalDateTime detectedOn, Platform platform, LocalDateTime finishedOn) {
        this.validatePatch(patchId, patchName, componentName, detectedOn, platform);
        this.patchId = patchId;
        this.patchName = patchName;
        this.componentName = componentName;
        this.detectedOn = detectedOn;
        this.platform = platform;
        this.finishedOn = finishedOn;
    }

    public Patch(String patchName, String componentName, Platform platform, LocalDateTime detectedOn) {
        this.patchId = null;
        this.patchName = patchName;
        this.componentName = componentName;
        this.platform = platform;
        this.detectedOn = detectedOn;
    }

    public boolean isInDb() {
        return this.patchId != null;
    }

    public String getResourcesPath() {
        return this.getPlatform().getFolderName() + "/" + this.getPatchName();
    }

    private void validatePatch(Integer patchId, String patchName, String componentName, LocalDateTime detectedOn, Platform platform) throws PatchFormatException {
        if (patchName.isEmpty()) {
            throw new PatchFormatException("PatchName must not be empty! patchId: " + patchId + " patchName: " + patchName + " componentName: " + componentName + " detectedOn: " + detectedOn + " platform: " + (Object)((Object)platform));
        }
        if (componentName.isEmpty()) {
            throw new PatchFormatException("Component name must not empty!  patchId: " + patchId + " patchName: " + patchName + " componentName: " + componentName + " detectedOn: " + detectedOn + " platform: " + (Object)((Object)platform));
        }
        if (detectedOn == null) {
            throw new PatchFormatException("Date can not be null! patchId: " + patchId + " patchName: " + patchName + " componentName: " + componentName + " platform: " + (Object)((Object)platform));
        }
        if (platform == null) {
            throw new PatchFormatException("Patch must be applied on some platform! patchId: " + patchId + " patchName: " + patchName + " componentName: " + componentName + " detectedOn: " + detectedOn);
        }
    }

    public Integer getPatchId() {
        return this.patchId;
    }

    public String getPatchName() {
        return this.patchName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public LocalDateTime getDetectedOn() {
        return this.detectedOn;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public LocalDateTime getFinishedOn() {
        return this.finishedOn;
    }

    public void setProcessTime(int processTime) {
        this.processTime = processTime;
    }

    public void setFinishedOn(LocalDateTime finishedOn) {
        this.finishedOn = finishedOn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Patch)) {
            return false;
        }
        Patch other = (Patch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProcessTime() != other.getProcessTime()) {
            return false;
        }
        Integer this$patchId = this.getPatchId();
        Integer other$patchId = other.getPatchId();
        if (this$patchId == null ? other$patchId != null : !((Object)this$patchId).equals(other$patchId)) {
            return false;
        }
        String this$patchName = this.getPatchName();
        String other$patchName = other.getPatchName();
        if (this$patchName == null ? other$patchName != null : !this$patchName.equals(other$patchName)) {
            return false;
        }
        String this$componentName = this.getComponentName();
        String other$componentName = other.getComponentName();
        if (this$componentName == null ? other$componentName != null : !this$componentName.equals(other$componentName)) {
            return false;
        }
        LocalDateTime this$detectedOn = this.getDetectedOn();
        LocalDateTime other$detectedOn = other.getDetectedOn();
        if (this$detectedOn == null ? other$detectedOn != null : !((Object)this$detectedOn).equals(other$detectedOn)) {
            return false;
        }
        Platform this$platform = this.getPlatform();
        Platform other$platform = other.getPlatform();
        if (this$platform == null ? other$platform != null : !((Object)((Object)this$platform)).equals((Object)other$platform)) {
            return false;
        }
        LocalDateTime this$finishedOn = this.getFinishedOn();
        LocalDateTime other$finishedOn = other.getFinishedOn();
        return !(this$finishedOn == null ? other$finishedOn != null : !((Object)this$finishedOn).equals(other$finishedOn));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Patch;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getProcessTime();
        Integer $patchId = this.getPatchId();
        result = result * 59 + ($patchId == null ? 43 : ((Object)$patchId).hashCode());
        String $patchName = this.getPatchName();
        result = result * 59 + ($patchName == null ? 43 : $patchName.hashCode());
        String $componentName = this.getComponentName();
        result = result * 59 + ($componentName == null ? 43 : $componentName.hashCode());
        LocalDateTime $detectedOn = this.getDetectedOn();
        result = result * 59 + ($detectedOn == null ? 43 : ((Object)$detectedOn).hashCode());
        Platform $platform = this.getPlatform();
        result = result * 59 + ($platform == null ? 43 : ((Object)((Object)$platform)).hashCode());
        LocalDateTime $finishedOn = this.getFinishedOn();
        result = result * 59 + ($finishedOn == null ? 43 : ((Object)$finishedOn).hashCode());
        return result;
    }

    public String toString() {
        return "Patch(patchId=" + this.getPatchId() + ", patchName=" + this.getPatchName() + ", componentName=" + this.getComponentName() + ", detectedOn=" + this.getDetectedOn() + ", platform=" + (Object)((Object)this.getPlatform()) + ", processTime=" + this.getProcessTime() + ", finishedOn=" + this.getFinishedOn() + ")";
    }
}

