/*
 * Decompiled with CFR 0.152.
 */
package one.edee.darwin.model;

import java.time.LocalDateTime;
import one.edee.darwin.exception.SqlCommandFormatException;

public class SqlCommand {
    private final int patchId;
    private final String statement;
    private final long processTime;
    private final LocalDateTime finishedOn;
    private Exception exception;

    public SqlCommand(int patchId, String statement, long processTime, LocalDateTime finishedOn) {
        this.validateSqlCommand(patchId, statement, processTime);
        this.patchId = patchId;
        this.statement = statement;
        this.processTime = processTime;
        this.finishedOn = finishedOn;
        this.exception = null;
    }

    public SqlCommand(int patchId, String statement, long processTime, LocalDateTime finishedOn, Exception exception) {
        this.validateSqlCommand(patchId, statement, processTime);
        this.patchId = patchId;
        this.statement = statement;
        this.processTime = processTime;
        this.finishedOn = finishedOn;
        this.exception = exception;
    }

    private void validateSqlCommand(int patchId, String statement, long processTime) throws SqlCommandFormatException {
        if (patchId <= 0) {
            throw new SqlCommandFormatException("PatchID can not be 0 or lower! patchId: " + patchId + " statement: " + statement);
        }
        if (statement.isEmpty()) {
            throw new SqlCommandFormatException("Sql statement can not be empty! patchId: " + patchId + " statement: " + statement);
        }
        if (processTime < 0L) {
            throw new SqlCommandFormatException("ProcessTime can not be lower then 0! patchId: " + patchId + " statement: " + statement);
        }
    }

    public int getPatchId() {
        return this.patchId;
    }

    public String getStatement() {
        return this.statement;
    }

    public long getProcessTime() {
        return this.processTime;
    }

    public LocalDateTime getFinishedOn() {
        return this.finishedOn;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlCommand)) {
            return false;
        }
        SqlCommand other = (SqlCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPatchId() != other.getPatchId()) {
            return false;
        }
        if (this.getProcessTime() != other.getProcessTime()) {
            return false;
        }
        String this$statement = this.getStatement();
        String other$statement = other.getStatement();
        if (this$statement == null ? other$statement != null : !this$statement.equals(other$statement)) {
            return false;
        }
        LocalDateTime this$finishedOn = this.getFinishedOn();
        LocalDateTime other$finishedOn = other.getFinishedOn();
        if (this$finishedOn == null ? other$finishedOn != null : !((Object)this$finishedOn).equals(other$finishedOn)) {
            return false;
        }
        Exception this$exception = this.getException();
        Exception other$exception = other.getException();
        return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SqlCommand;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPatchId();
        long $processTime = this.getProcessTime();
        result = result * 59 + (int)($processTime >>> 32 ^ $processTime);
        String $statement = this.getStatement();
        result = result * 59 + ($statement == null ? 43 : $statement.hashCode());
        LocalDateTime $finishedOn = this.getFinishedOn();
        result = result * 59 + ($finishedOn == null ? 43 : ((Object)$finishedOn).hashCode());
        Exception $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        return result;
    }

    public String toString() {
        return "SqlCommand(patchId=" + this.getPatchId() + ", statement=" + this.getStatement() + ", processTime=" + this.getProcessTime() + ", finishedOn=" + this.getFinishedOn() + ", exception=" + this.getException() + ")";
    }
}

