/*
 * Decompiled with CFR 0.152.
 */
package one.edee.darwin.model.version;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class VersionDescriptor {
    private static final String VERSION_DELIMITER = ".";
    private static final String VERSION_DELIMITERS = "._-";
    private static final String SNAPSHOT_POSTFIX = "SNAPSHOT";
    private final List<Serializable> identification = new LinkedList<Serializable>();
    private boolean snapshot;

    public VersionDescriptor(String fullVersion) {
        int i;
        StringTokenizer st = new StringTokenizer(fullVersion, VERSION_DELIMITERS, false);
        while (st.hasMoreTokens()) {
            String version = st.nextToken();
            try {
                if (!SNAPSHOT_POSTFIX.equals(version)) {
                    int numberVersion = Integer.parseInt(version);
                    this.identification.add(Integer.valueOf(numberVersion));
                    continue;
                }
                this.snapshot = true;
            }
            catch (NumberFormatException ex) {
                this.identification.add((Serializable)((Object)version));
            }
        }
        int lastIndex = this.identification.size();
        for (i = this.identification.size() - 1; i >= 0; --i) {
            Serializable version = this.identification.get(i);
            if (!(version instanceof Integer) || (Integer)version == 0) continue;
            lastIndex = i + 1;
            break;
        }
        i = lastIndex;
        while (i < this.identification.size()) {
            if (this.identification.get(i) instanceof Integer) {
                this.identification.remove(i);
                continue;
            }
            ++i;
        }
    }

    public VersionDescriptor addNumericVersion(int version) {
        this.identification.add(Integer.valueOf(version));
        return this;
    }

    public VersionDescriptor addAlphanumericVersion(String version) {
        this.identification.add((Serializable)((Object)version));
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionDescriptor that = (VersionDescriptor)o;
        return this.identification.equals(that.identification);
    }

    public int hashCode() {
        return this.identification.hashCode();
    }

    public String toString() {
        StringBuilder fullVersion = new StringBuilder();
        for (int i = 0; i < this.identification.size(); ++i) {
            Serializable version = this.identification.get(i);
            fullVersion.append(version);
            if (i >= this.identification.size() - 1) continue;
            fullVersion.append(VERSION_DELIMITER);
        }
        return fullVersion.toString();
    }

    public List<Serializable> getIdentification() {
        return this.identification;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }
}

