/*
 * Decompiled with CFR 0.152.
 */
package one.edee.darwin.storage;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import one.edee.darwin.model.Patch;
import one.edee.darwin.model.Platform;
import one.edee.darwin.model.SqlCommand;
import one.edee.darwin.model.version.VersionDescriptor;
import one.edee.darwin.resources.ResourceNameAnalyzer;
import one.edee.darwin.storage.AbstractDatabaseStorage;
import one.edee.darwin.storage.DarwinStorage;
import one.edee.darwin.storage.StorageChecker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.util.Assert;
import org.springframework.util.DigestUtils;

public class DefaultDatabaseDarwinStorage
extends AbstractDatabaseStorage
implements DarwinStorage {
    private static final Log log = LogFactory.getLog(DefaultDatabaseDarwinStorage.class);
    private static final Map<StatementTypeWithPlatform, String> STATEMENTS_CACHE = new ConcurrentHashMap<StatementTypeWithPlatform, String>();
    private final ResourceNameAnalyzer resourceNameAnalyzer;
    private final StorageChecker storageChecker;
    private boolean patchAndTableExists;

    public DefaultDatabaseDarwinStorage(ResourceNameAnalyzer resourceNameAnalyzer, StorageChecker storageChecker) {
        Assert.notNull((Object)resourceNameAnalyzer);
        Assert.notNull((Object)storageChecker);
        this.resourceNameAnalyzer = resourceNameAnalyzer;
        this.storageChecker = storageChecker;
    }

    @Override
    public VersionDescriptor getVersionDescriptorForComponent(String componentName) {
        String versionScript = STATEMENTS_CACHE.computeIfAbsent(this.getKey(StorageStatement.GET_VERSION), this::readContentFromResource);
        try {
            String version = (String)this.jdbcTemplate.queryForObject(versionScript, String.class, new Object[]{componentName});
            if (version != null && !version.trim().isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Detected version of component " + componentName + " is " + version));
                }
                return new VersionDescriptor(version.trim());
            }
            return null;
        }
        catch (EmptyResultDataAccessException | BadSqlGrammarException ignored) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No version of component " + componentName + " detected."));
            }
            return null;
        }
    }

    @Override
    public void updateVersionDescriptorForComponent(String componentName, String version) {
        VersionDescriptor storedVersion = this.getVersionDescriptorForComponent(componentName);
        if (storedVersion == null) {
            String insertScript = STATEMENTS_CACHE.computeIfAbsent(this.getKey(StorageStatement.INSERT_COMPONENT), this::readContentFromResource);
            this.jdbcTemplate.update(insertScript, new Object[]{componentName, version});
        } else {
            String updateScript = STATEMENTS_CACHE.computeIfAbsent(this.getKey(StorageStatement.UPDATE_COMPONENT), this::readContentFromResource);
            this.jdbcTemplate.update(updateScript, new Object[]{version, componentName});
        }
    }

    @Override
    public void insertSqlScriptToDB(Patch patch, SqlCommand sqlCommand) {
        this.insertSqlScriptToDB(patch, sqlCommand.getStatement(), sqlCommand.getProcessTime(), sqlCommand.getFinishedOn(), sqlCommand.getException());
    }

    @Override
    public void updateSqlScriptInDB(Patch patch, SqlCommand sqlCommand) {
        this.updateSqlScriptInDB(patch, sqlCommand.getStatement(), sqlCommand.getProcessTime(), sqlCommand.getFinishedOn(), sqlCommand.getException());
    }

    @Override
    public Patch insertPatchToDatabase(String patchName, String componentName, LocalDateTime detectedOn, Platform platform) {
        String sqlCommandWhichThrewException = "";
        try {
            String sql;
            sqlCommandWhichThrewException = sql = STATEMENTS_CACHE.computeIfAbsent(this.getKey(StorageStatement.INSERT_PATCH), this::readContentFromResource);
            this.jdbcTemplate.update(sql, new Object[]{componentName, patchName, 0, Timestamp.valueOf(detectedOn), null, platform.name()});
            return this.getPatchFromDb(patchName, componentName, platform);
        }
        catch (DuplicateKeyException ignored) {
            return this.getPatchFromDb(patchName, componentName, platform);
        }
        catch (DataIntegrityViolationException ex) {
            VersionDescriptor component = this.getVersionDescriptorForComponent(componentName);
            if (component == null) {
                log.debug((Object)("Component information not present in database - creating new record for " + componentName + "."));
                this.insertComponentToDatabase(componentName);
                return this.insertPatchToDatabase(patchName, componentName, detectedOn, platform);
            }
            log.error((Object)("Can't insert patch into the database: " + ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        catch (DataAccessException ex) {
            log.error((Object)("Failed to execute script!!!" + sqlCommandWhichThrewException), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void markPatchAsFinished(Patch patch) {
        if (patch.isInDb()) {
            String sql = STATEMENTS_CACHE.computeIfAbsent(this.getKey(StorageStatement.MARK_PATCH_AS_FINISHED), this::readContentFromResource);
            this.jdbcTemplate.update(sql, new Object[]{Timestamp.valueOf(LocalDateTime.now()), patch.getPatchName(), patch.getComponentName(), patch.getPlatform().name()});
        }
    }

    @Override
    public Patch getPatchByResourcePath(String resourcePath, String componentName) {
        String[] strings = this.resourceNameAnalyzer.getPlatformAndNameFromResourcePath(resourcePath);
        if (this.storageChecker.existPatchAndSqlTable()) {
            Patch patchFromDb = this.getPatchFromDb(strings[1], componentName, Platform.identify(strings[0]));
            if (patchFromDb == null) {
                return this.insertPatchToDatabase(strings[1], componentName, LocalDateTime.now(), Platform.identify(strings[0]));
            }
            return patchFromDb;
        }
        return new Patch(componentName, strings[1], Platform.identify(strings[0]), LocalDateTime.now());
    }

    @Override
    public boolean isPatchRecordedByResourcePath(String resourcePath, String componentName) {
        String[] strings = this.resourceNameAnalyzer.getPlatformAndNameFromResourcePath(resourcePath);
        if (!this.storageChecker.existPatchAndSqlTable()) {
            return false;
        }
        Patch patchFromDb = this.getPatchFromDb(strings[1], componentName, Platform.identify(strings[0]));
        return patchFromDb != null;
    }

    @Override
    public boolean isPatchFinishedInDb(Patch patch) {
        Patch patchFromDb;
        try {
            patchFromDb = this.getPatchFromDb(patch.getPatchName(), patch.getComponentName(), patch.getPlatform());
        }
        catch (BadSqlGrammarException ignored) {
            return false;
        }
        return patchFromDb != null && patchFromDb.getFinishedOn() != null;
    }

    @Override
    public boolean isAnyPatchRecordedFor(String componentName) {
        String sql = STATEMENTS_CACHE.computeIfAbsent(this.getKey(StorageStatement.IS_ANY_PATCH_FOR_COMPONENT), this::readContentFromResource);
        int countOfPatchesInDb = this.jdbcTemplate.queryForList(sql, new Object[]{componentName}).size();
        return countOfPatchesInDb != 0;
    }

    @Override
    public void insertComponentToDatabase(String componentName) {
        String sql = STATEMENTS_CACHE.computeIfAbsent(this.getKey(StorageStatement.INSERT_COMPONENT), this::readContentFromResource);
        this.jdbcTemplate.update(sql, new Object[]{componentName, "1.0"});
    }

    @Override
    public DarwinStorage.SqlScriptStatus wasSqlCommandAlreadyExecuted(int patchId, String script, int occurrence) {
        if (this.storageChecker.existPatchAndSqlTable()) {
            String sql = STATEMENTS_CACHE.computeIfAbsent(this.getKey(StorageStatement.WAS_SQL_EXECUTED), this::readContentFromResource);
            List finishedDates = this.jdbcTemplate.queryForList(sql, Date.class, new Object[]{patchId, occurrence > 1 ? "-- occurrence: " + occurrence + "\n" + script : script});
            if (!finishedDates.isEmpty()) {
                boolean atLeastOneFinished = false;
                for (Date executedDate : finishedDates) {
                    if (executedDate == null) continue;
                    atLeastOneFinished = true;
                    break;
                }
                return atLeastOneFinished ? DarwinStorage.SqlScriptStatus.EXECUTED_FINISHED : DarwinStorage.SqlScriptStatus.EXECUTED_FAILED;
            }
        }
        return DarwinStorage.SqlScriptStatus.NOT_EXECUTED;
    }

    private void insertSqlScriptToDB(Patch patch, String statement, long processTime, LocalDateTime finishedOn, Exception exception) {
        if (patch.isInDb()) {
            String sql = STATEMENTS_CACHE.computeIfAbsent(this.getKey(StorageStatement.INSERT_SQL_SCRIPT), this::readContentFromResource);
            this.jdbcTemplate.update(sql, new Object[]{patch.getPatchId(), statement, this.computeHash(statement), processTime, Timestamp.valueOf(finishedOn), exception != null ? this.exceptionToString(exception) : null});
        }
    }

    private void updateSqlScriptInDB(Patch patch, String statement, long processTime, LocalDateTime finishedOn, Exception exception) {
        if (patch.isInDb()) {
            String sql = STATEMENTS_CACHE.computeIfAbsent(this.getKey(StorageStatement.UPDATE_SQL_SCRIPT), this::readContentFromResource);
            this.jdbcTemplate.update(sql, new Object[]{processTime, Timestamp.valueOf(finishedOn), exception != null ? this.exceptionToString(exception) : null, patch.getPatchId(), this.computeHash(statement)});
        }
    }

    private String computeHash(String statement) {
        return DigestUtils.md5DigestAsHex((byte[])statement.getBytes(StandardCharsets.UTF_8));
    }

    private Patch getPatchFromDb(String patchName, String componentName, Platform platform) {
        try {
            String sql = STATEMENTS_CACHE.computeIfAbsent(this.getKey(StorageStatement.GET_PATCH), this::readContentFromResource);
            return (Patch)this.jdbcTemplate.queryForObject(sql, new Object[]{patchName, componentName, platform.name()}, (rs, rowNum) -> new Patch(rs.getInt("id"), rs.getString("patchName"), rs.getString("componentName"), rs.getTimestamp("detectedOn").toLocalDateTime(), Platform.identify(rs.getString("platform")), Optional.ofNullable(rs.getTimestamp("finishedOn")).map(Timestamp::toLocalDateTime).orElse(null)));
        }
        catch (EmptyResultDataAccessException ignored) {
            return null;
        }
    }

    private String exceptionToString(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private StatementTypeWithPlatform getKey(StorageStatement statementType) {
        return new StatementTypeWithPlatform(statementType, this.getPlatform());
    }

    private String readContentFromResource(StatementTypeWithPlatform statementTypeWithPlatform) {
        return this.dbResourceAccessor.getTextContentFromResource(statementTypeWithPlatform.getPlatform().getFolderName() + "/" + statementTypeWithPlatform.getStatementType().getFileName());
    }

    public ResourceNameAnalyzer getResourceNameAnalyzer() {
        return this.resourceNameAnalyzer;
    }

    public StorageChecker getStorageChecker() {
        return this.storageChecker;
    }

    public boolean isPatchAndTableExists() {
        return this.patchAndTableExists;
    }

    public void setPatchAndTableExists(boolean patchAndTableExists) {
        this.patchAndTableExists = patchAndTableExists;
    }

    private static class StatementTypeWithPlatform {
        private final StorageStatement statementType;
        private final Platform platform;

        public StatementTypeWithPlatform(StorageStatement statementType, Platform platform) {
            this.statementType = statementType;
            this.platform = platform;
        }

        public StorageStatement getStatementType() {
            return this.statementType;
        }

        public Platform getPlatform() {
            return this.platform;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatementTypeWithPlatform)) {
                return false;
            }
            StatementTypeWithPlatform other = (StatementTypeWithPlatform)o;
            if (!other.canEqual(this)) {
                return false;
            }
            StorageStatement this$statementType = this.getStatementType();
            StorageStatement other$statementType = other.getStatementType();
            if (this$statementType == null ? other$statementType != null : !((Object)((Object)this$statementType)).equals((Object)other$statementType)) {
                return false;
            }
            Platform this$platform = this.getPlatform();
            Platform other$platform = other.getPlatform();
            return !(this$platform == null ? other$platform != null : !((Object)((Object)this$platform)).equals((Object)other$platform));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StatementTypeWithPlatform;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            StorageStatement $statementType = this.getStatementType();
            result = result * 59 + ($statementType == null ? 43 : ((Object)((Object)$statementType)).hashCode());
            Platform $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : ((Object)((Object)$platform)).hashCode());
            return result;
        }

        public String toString() {
            return "DefaultDatabaseDarwinStorage.StatementTypeWithPlatform(statementType=" + (Object)((Object)this.getStatementType()) + ", platform=" + (Object)((Object)this.getPlatform()) + ")";
        }
    }

    private static enum StorageStatement {
        INSERT_COMPONENT("insert_component.sql"),
        UPDATE_COMPONENT("update_component.sql"),
        IS_ANY_PATCH_FOR_COMPONENT("select_isAnyPatchRecordedForComponent.sql"),
        GET_PATCH("select_patchFromDb.sql"),
        INSERT_PATCH("insert_patch.sql"),
        MARK_PATCH_AS_FINISHED("update_markPatchAsFinished.sql"),
        UPDATE_SQL_SCRIPT("update_script.sql"),
        GET_VERSION("version.sql"),
        WAS_SQL_EXECUTED("select_wasSqlCommandAlreadyExecuted.sql"),
        INSERT_SQL_SCRIPT("insert_script.sql");

        private final String fileName;

        private StorageStatement(String fileName) {
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

