/*
 * Decompiled with CFR 0.152.
 */
package one.edee.darwin.storage;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import one.edee.darwin.model.LockState;
import one.edee.darwin.model.Platform;
import one.edee.darwin.storage.TransactionalDatabaseLockStorage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.EmptyResultDataAccessException;

public class DefaultDatabaseLockStorage
extends TransactionalDatabaseLockStorage {
    private static final Log log = LogFactory.getLog(DefaultDatabaseLockStorage.class);
    private static final Map<LockStorageStatementWithPlatform, String> STATEMENTS_CACHE = new ConcurrentHashMap<LockStorageStatementWithPlatform, String>();

    @Override
    protected int releaseDbLocksForInstance(String instanceId) {
        String instanceDeleteScript = STATEMENTS_CACHE.computeIfAbsent(this.getKey(LockStorageStatement.LOCK_INSTANCE_DELETE), this::readContentFromResource);
        try {
            return this.jdbcTemplate.update(instanceDeleteScript, new Object[]{"%" + instanceId});
        }
        catch (EmptyResultDataAccessException ignored) {
            return 0;
        }
    }

    @Override
    protected LockState getDbProcessLock(String processName, LocalDateTime currentDate) {
        String checkScript = STATEMENTS_CACHE.computeIfAbsent(this.getKey(LockStorageStatement.LOCK_CHECK), this::readContentFromResource);
        try {
            LocalDateTime leaseUntil = (LocalDateTime)this.jdbcTemplate.queryForObject(checkScript, new Object[]{processName}, LocalDateTime.class);
            if (leaseUntil != null) {
                if (leaseUntil.isAfter(currentDate)) {
                    if (log.isDebugEnabled()) {
                        SimpleDateFormat fmt = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                        log.debug((Object)("Found unexpired lock on process " + processName + ". Lock will expire automatically on " + fmt.format(leaseUntil)));
                    }
                    return LockState.LEASED;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found expired lock on process " + processName + ". Lock could be broken."));
                }
                return LockState.LEASED_EXPIRED;
            }
            return LockState.AVAILABLE;
        }
        catch (EmptyResultDataAccessException ignored) {
            return LockState.AVAILABLE;
        }
    }

    @Override
    protected LockState createDbLock(String processName, LocalDateTime until, String unlockKey) {
        String insertScript = STATEMENTS_CACHE.computeIfAbsent(this.getKey(LockStorageStatement.LOCK_INSERT), this::readContentFromResource);
        this.jdbcTemplate.update(insertScript, new Object[]{processName, Timestamp.valueOf(until), unlockKey});
        return LockState.LEASED;
    }

    @Override
    protected LockState releaseDbProcess(String processName, String unlockKey) throws IllegalStateException {
        String deleteScript = STATEMENTS_CACHE.computeIfAbsent(this.getKey(LockStorageStatement.LOCK_DELETE), this::readContentFromResource);
        if (this.jdbcTemplate.update(deleteScript, new Object[]{processName, unlockKey}) == 0) {
            String msg = "No lock for process" + processName + " and unlockKey " + unlockKey + " was found!";
            log.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        return LockState.AVAILABLE;
    }

    @Override
    protected LockState renewDbLease(LocalDateTime until, String processName, String unlockKey) {
        String updateScript = STATEMENTS_CACHE.computeIfAbsent(this.getKey(LockStorageStatement.LOCK_UPDATE), this::readContentFromResource);
        if (this.jdbcTemplate.update(updateScript, new Object[]{Timestamp.valueOf(until), processName, unlockKey}) > 0) {
            return LockState.LEASED;
        }
        return LockState.AVAILABLE;
    }

    private LockStorageStatementWithPlatform getKey(LockStorageStatement statementType) {
        return new LockStorageStatementWithPlatform(statementType, this.getPlatform());
    }

    private String readContentFromResource(LockStorageStatementWithPlatform statementTypeWithPlatform) {
        return this.dbResourceAccessor.getTextContentFromResource(statementTypeWithPlatform.getPlatform().getFolderName() + "/" + statementTypeWithPlatform.getStatementType().getFileName());
    }

    private static class LockStorageStatementWithPlatform {
        private final LockStorageStatement statementType;
        private final Platform platform;

        public LockStorageStatementWithPlatform(LockStorageStatement statementType, Platform platform) {
            this.statementType = statementType;
            this.platform = platform;
        }

        public LockStorageStatement getStatementType() {
            return this.statementType;
        }

        public Platform getPlatform() {
            return this.platform;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LockStorageStatementWithPlatform)) {
                return false;
            }
            LockStorageStatementWithPlatform other = (LockStorageStatementWithPlatform)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LockStorageStatement this$statementType = this.getStatementType();
            LockStorageStatement other$statementType = other.getStatementType();
            if (this$statementType == null ? other$statementType != null : !((Object)((Object)this$statementType)).equals((Object)other$statementType)) {
                return false;
            }
            Platform this$platform = this.getPlatform();
            Platform other$platform = other.getPlatform();
            return !(this$platform == null ? other$platform != null : !((Object)((Object)this$platform)).equals((Object)other$platform));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LockStorageStatementWithPlatform;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LockStorageStatement $statementType = this.getStatementType();
            result = result * 59 + ($statementType == null ? 43 : ((Object)((Object)$statementType)).hashCode());
            Platform $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : ((Object)((Object)$platform)).hashCode());
            return result;
        }

        public String toString() {
            return "DefaultDatabaseLockStorage.LockStorageStatementWithPlatform(statementType=" + (Object)((Object)this.getStatementType()) + ", platform=" + (Object)((Object)this.getPlatform()) + ")";
        }
    }

    private static enum LockStorageStatement {
        LOCK_CHECK("lock_check.sql"),
        LOCK_CURRENT_TIME("lock_current_time.sql"),
        LOCK_DELETE("lock_delete.sql"),
        LOCK_INSTANCE_DELETE("lock_instance_delete.sql"),
        LOCK_INSERT("lock_insert.sql"),
        LOCK_UPDATE("lock_update.sql");

        private final String fileName;

        private LockStorageStatement(String fileName) {
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

