/*
 * Decompiled with CFR 0.152.
 */
package one.edee.darwin.storage;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import one.edee.darwin.model.Patch;
import one.edee.darwin.model.Platform;
import one.edee.darwin.model.version.VersionDescriptor;
import one.edee.darwin.resources.PatchType;
import one.edee.darwin.resources.ResourceMatcher;
import one.edee.darwin.resources.ResourceNameAnalyzer;
import one.edee.darwin.resources.ResourcePatchMediator;
import one.edee.darwin.storage.AbstractDatabaseStorage;
import one.edee.darwin.storage.DarwinStorage;
import one.edee.darwin.storage.StorageChecker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.BadSqlGrammarException;

public class DefaultDatabaseStorageChecker
extends AbstractDatabaseStorage
implements StorageChecker {
    private static final Log log = LogFactory.getLog(DefaultDatabaseStorageChecker.class);
    private final ResourcePatchMediator resourcePatchMediator;
    private ResourceMatcher resourceMatcher;
    private ResourceNameAnalyzer resourceNameAnalyzer;
    private boolean patchAndTableExists;

    @Override
    public VersionDescriptor guessVersion(String componentName, DarwinStorage darwinStorage) {
        Platform platform = this.getPlatform();
        Resource[] sortedResourceList = this.resourceAccessor.getSortedResourceList(platform);
        Patch[] patches = this.resourcePatchMediator.getPatches(sortedResourceList, componentName, platform, darwinStorage, this, PatchType.GUESS);
        VersionDescriptor guessedVersion = null;
        for (Patch patch : patches) {
            if (!this.resourceMatcher.isResourceAcceptable(PatchType.GUESS, patch.getPatchName())) continue;
            VersionDescriptor resourceVersion = this.resourceNameAnalyzer.getVersionFromPatch(patch);
            long start = System.currentTimeMillis();
            boolean result = this.executeScript(patch);
            long stop = System.currentTimeMillis();
            if (result) {
                guessedVersion = resourceVersion;
                this.markGuessedPatchAsFinished(darwinStorage, patch, resourceVersion, start, stop);
                continue;
            }
            if (!log.isDebugEnabled()) break;
            log.debug((Object)("Storage not compatible with version: " + resourceVersion));
            break;
        }
        return guessedVersion;
    }

    @Override
    public boolean guessPatchAlreadyApplied(String componentName, DarwinStorage darwinStorage, VersionDescriptor checkedVersion) {
        Patch[] patches;
        Platform platform = this.getPlatform();
        Resource[] sortedResourceList = this.resourceAccessor.getSortedResourceList(platform);
        for (Patch patch : patches = this.resourcePatchMediator.getPatches(sortedResourceList, componentName, platform, darwinStorage, this, PatchType.GUESS)) {
            VersionDescriptor patchVersion;
            if (!this.resourceMatcher.isResourceAcceptable(PatchType.GUESS, patch.getPatchName()) || (patchVersion = this.resourceNameAnalyzer.getVersionFromPatch(patch)) == null || !Objects.equals(patchVersion, checkedVersion)) continue;
            long start = System.currentTimeMillis();
            boolean result = this.executeScript(patch);
            long stop = System.currentTimeMillis();
            if (!result) continue;
            this.markGuessedPatchAsFinished(darwinStorage, patch, patchVersion, start, stop);
            return true;
        }
        return false;
    }

    private void markGuessedPatchAsFinished(DarwinStorage darwinStorage, Patch patch, VersionDescriptor resourceVersion, long start, long stop) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Storage compatible with version: " + resourceVersion));
        }
        if (this.existPatchAndSqlTable()) {
            long duration = stop - start;
            patch.setProcessTime((int)duration);
            patch.setFinishedOn(LocalDateTime.now());
            darwinStorage.markPatchAsFinished(darwinStorage.insertPatchToDatabase(patch.getPatchName(), patch.getComponentName(), LocalDateTime.now(), this.getPlatform()));
        }
    }

    @Override
    public boolean existPatchAndSqlTable() {
        if (this.patchAndTableExists) {
            return true;
        }
        return this.existsPatchAndSqlTableNoCache();
    }

    public boolean existsPatchAndSqlTableNoCache() {
        String sqlForPatch = this.dbResourceAccessor.getTextContentFromResource(this.getPlatform().getFolderName() + "/check_patchTableExist.sql");
        String sqlForSQL = this.dbResourceAccessor.getTextContentFromResource(this.getPlatform().getFolderName() + "/check_sqlCommandTableExists.sql");
        try {
            this.jdbcTemplate.execute(sqlForPatch);
            this.jdbcTemplate.execute(sqlForSQL);
            this.patchAndTableExists = true;
            return true;
        }
        catch (BadSqlGrammarException ignored) {
            return false;
        }
    }

    private boolean executeScript(Patch patch) {
        List<String> tokenizedScript = this.resourceAccessor.getTokenizedSQLScriptContentFromResource(patch.getResourcesPath());
        try {
            for (String sql : tokenizedScript) {
                if (sql.trim().toLowerCase().matches("select\\s*count\\(.*")) {
                    Integer result = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
                    if (result != 0) continue;
                    return false;
                }
                this.jdbcTemplate.execute(sql);
            }
            return true;
        }
        catch (BadSqlGrammarException ex) {
            return false;
        }
        catch (DataAccessException ex) {
            String msg = "Failed to execute script: " + this.resourceAccessor.getTextContentFromResource(patch.getResourcesPath());
            log.error((Object)msg, (Throwable)ex);
            return false;
        }
    }

    public DefaultDatabaseStorageChecker(ResourcePatchMediator resourcePatchMediator) {
        this.resourcePatchMediator = resourcePatchMediator;
    }

    public void setResourceMatcher(ResourceMatcher resourceMatcher) {
        this.resourceMatcher = resourceMatcher;
    }

    public ResourceMatcher getResourceMatcher() {
        return this.resourceMatcher;
    }

    public void setResourceNameAnalyzer(ResourceNameAnalyzer resourceNameAnalyzer) {
        this.resourceNameAnalyzer = resourceNameAnalyzer;
    }

    public ResourceNameAnalyzer getResourceNameAnalyzer() {
        return this.resourceNameAnalyzer;
    }

    public void setPatchAndTableExists(boolean patchAndTableExists) {
        this.patchAndTableExists = patchAndTableExists;
    }

    public boolean isPatchAndTableExists() {
        return this.patchAndTableExists;
    }
}

