/*
 * Decompiled with CFR 0.152.
 */
package one.edee.darwin.storage;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import one.edee.darwin.model.LockState;
import one.edee.darwin.storage.AbstractDatabaseStorage;
import one.edee.darwin.storage.LockStorage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class TransactionalDatabaseLockStorage
extends AbstractDatabaseStorage
implements LockStorage {
    private static final Log log = LogFactory.getLog(TransactionalDatabaseLockStorage.class);
    private TransactionTemplate transactionTemplate;

    @Override
    public LocalDateTime getCurrentDatabaseTime() {
        String dateScript = this.dbResourceAccessor.getTextContentFromResource(this.getPlatform().getFolderName() + "/lock_current_time.sql");
        Object databaseNow = this.jdbcTemplate.queryForObject(dateScript, Object.class);
        if (databaseNow instanceof Instant) {
            return LocalDateTime.ofInstant((Instant)databaseNow, ZoneId.systemDefault());
        }
        if (databaseNow instanceof LocalDateTime) {
            return (LocalDateTime)databaseNow;
        }
        if (databaseNow instanceof Timestamp) {
            return ((Timestamp)databaseNow).toLocalDateTime();
        }
        if (databaseNow instanceof OffsetDateTime) {
            return ((OffsetDateTime)databaseNow).toLocalDateTime();
        }
        throw new IllegalStateException("Unknown type returned by database: " + Optional.ofNullable(databaseNow).map(Object::getClass).orElse(null));
    }

    @Override
    public LockState getProcessLock(String processName, LocalDateTime currentDate) {
        if (this.transactionTemplate != null) {
            return (LockState)((Object)this.transactionTemplate.execute(status -> this.getDbProcessLock(processName, currentDate)));
        }
        return this.getDbProcessLock(processName, currentDate);
    }

    @Override
    public int releaseProcessesForInstance(String instanceId) {
        if (this.transactionTemplate != null) {
            return (Integer)this.transactionTemplate.execute(status -> this.releaseDbLocksForInstance(instanceId));
        }
        return this.releaseDbLocksForInstance(instanceId);
    }

    @Override
    public LockState createLock(String processName, LocalDateTime until, String unlockKey) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating lock for: " + processName + " with unlock key " + unlockKey));
        }
        if (this.transactionTemplate != null) {
            return (LockState)((Object)this.transactionTemplate.execute(status -> this.createDbLock(processName, until, unlockKey)));
        }
        return this.createDbLock(processName, until, unlockKey);
    }

    @Override
    public LockState releaseProcess(String processName, String unlockKey) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing lock for: " + processName + " with unlock key " + unlockKey + " (or expired)."));
        }
        if (this.transactionTemplate != null) {
            return (LockState)((Object)this.transactionTemplate.execute(status -> this.releaseDbProcess(processName, unlockKey)));
        }
        return this.releaseDbProcess(processName, unlockKey);
    }

    @Override
    public LockState renewLease(String processName, String unlockKey, LocalDateTime until) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Renewing lock for: " + processName + " with unlock key " + unlockKey + " until " + until.format(DateTimeFormatter.BASIC_ISO_DATE)));
        }
        if (this.transactionTemplate != null) {
            return (LockState)((Object)this.transactionTemplate.execute(status -> this.renewDbLease(until, processName, unlockKey)));
        }
        return this.renewDbLease(until, processName, unlockKey);
    }

    protected abstract int releaseDbLocksForInstance(String var1);

    protected abstract LockState getDbProcessLock(String var1, LocalDateTime var2);

    protected abstract LockState createDbLock(String var1, LocalDateTime var2, String var3);

    protected abstract LockState releaseDbProcess(String var1, String var2);

    protected abstract LockState renewDbLease(LocalDateTime var1, String var2, String var3);

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionalDatabaseLockStorage)) {
            return false;
        }
        TransactionalDatabaseLockStorage other = (TransactionalDatabaseLockStorage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TransactionTemplate this$transactionTemplate = this.getTransactionTemplate();
        TransactionTemplate other$transactionTemplate = other.getTransactionTemplate();
        return !(this$transactionTemplate == null ? other$transactionTemplate != null : !this$transactionTemplate.equals(other$transactionTemplate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionalDatabaseLockStorage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TransactionTemplate $transactionTemplate = this.getTransactionTemplate();
        result = result * 59 + ($transactionTemplate == null ? 43 : $transactionTemplate.hashCode());
        return result;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public String toString() {
        return "TransactionalDatabaseLockStorage(transactionTemplate=" + this.getTransactionTemplate() + ")";
    }
}

