/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.pmptt.dao.mysql;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import one.edee.oss.pmptt.dao.DbHierarchyStorage;
import one.edee.oss.pmptt.dao.HierarchyStorage;
import one.edee.oss.pmptt.dao.mysql.HierarchyItemRowMapper;
import one.edee.oss.pmptt.dao.mysql.HierarchyRowMapper;
import one.edee.oss.pmptt.dao.mysql.SectionRowMapper;
import one.edee.oss.pmptt.model.DbHierarchy;
import one.edee.oss.pmptt.model.Hierarchy;
import one.edee.oss.pmptt.model.HierarchyItem;
import one.edee.oss.pmptt.model.HierarchyItemWithHistory;
import one.edee.oss.pmptt.model.SectionWithBucket;
import one.edee.oss.pmptt.spi.HierarchyChangeListener;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

public class MySqlStorage
implements DbHierarchyStorage {
    private final List<HierarchyChangeListener> changeListeners = new LinkedList<HierarchyChangeListener>();
    private final PlatformTransactionManager transactionManager;
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public MySqlStorage(DataSource dataSource, PlatformTransactionManager transactionManager) {
        this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
        this.transactionManager = transactionManager;
    }

    public void registerChangeListener(HierarchyChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void createHierarchy(Hierarchy hierarchy) {
        TransactionTemplate txTemplate = new TransactionTemplate(this.transactionManager);
        txTemplate.execute(transactionStatus -> {
            this.namedParameterJdbcTemplate.update("insert into T_MPTT_HIERARCHY (code, levels, sectionSize) values (:code, :levels, :sectionSize)", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)hierarchy));
            return null;
        });
        hierarchy.setStorage((HierarchyStorage)this);
    }

    public DbHierarchy getHierarchy(String code) {
        try {
            return (DbHierarchy)((Object)this.namedParameterJdbcTemplate.queryForObject("select * from T_MPTT_HIERARCHY where code = :code", Collections.singletonMap("code", code), (RowMapper)new HierarchyRowMapper(this)));
        }
        catch (EmptyResultDataAccessException ex) {
            return null;
        }
    }

    public Collection<String> getExistingHierarchyCodes() {
        return this.namedParameterJdbcTemplate.queryForList("select code from T_MPTT_HIERARCHY", Collections.emptyMap()).stream().map(it -> (String)it.get("code")).collect(Collectors.toList());
    }

    public boolean removeHierarchy(String code) {
        return this.namedParameterJdbcTemplate.update("delete from T_MPTT_HIERARCHY where code = :code", Collections.singletonMap("code", code)) > 0;
    }

    public void createItem(HierarchyItem newItem, HierarchyItem parent) {
        this.namedParameterJdbcTemplate.update("insert into T_MPTT_ITEM (code, hierarchyCode, level, leftBound, rightBound, numberOfChildren, `order`, bucket, hierarchy_id) values (:code, :hierarchyCode, :level, :leftBound, :rightBound, :numberOfChildren, :order, :bucket, (select id from T_MPTT_HIERARCHY where code = :hierarchyCode))", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)newItem));
        for (HierarchyChangeListener changeListener : this.changeListeners) {
            changeListener.itemCreated(newItem);
        }
    }

    public void updateItem(HierarchyItem updatedItem) {
        int affectedRows = this.namedParameterJdbcTemplate.update("update T_MPTT_ITEM set numberOfChildren = :numberOfChildren,     `leftBound` = :leftBound,     `rightBound` = :rightBound,     `level` = :level,     `order` = :order,     `bucket` = :bucket where code = :code and hierarchyCode = :hierarchyCode", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)updatedItem));
        Assert.isTrue((affectedRows == 1 ? 1 : 0) != 0, (String)("Removed unexpected count of rows: " + affectedRows + "!"));
        for (HierarchyChangeListener changeListener : this.changeListeners) {
            Assert.isTrue((boolean)(updatedItem instanceof HierarchyItemWithHistory));
            HierarchyItemWithHistory hiwh = (HierarchyItemWithHistory)updatedItem;
            changeListener.itemUpdated((HierarchyItem)hiwh.getDelegate(), (HierarchyItem)hiwh.getOriginal());
        }
    }

    public void removeItem(HierarchyItem removedItem) {
        int affectedRows = this.namedParameterJdbcTemplate.update("delete from T_MPTT_ITEM where code = :code and hierarchyCode = :hierarchyCode", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)removedItem));
        Assert.isTrue((affectedRows == 1 ? 1 : 0) != 0, (String)("Removed unexpected count of rows: " + affectedRows + "!"));
        for (HierarchyChangeListener changeListener : this.changeListeners) {
            changeListener.itemRemoved(removedItem);
        }
    }

    public HierarchyItem getItem(String hierarchyCode, String code) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("code", code);
            params.put("hierarchyCode", hierarchyCode);
            return (HierarchyItem)this.namedParameterJdbcTemplate.queryForObject("select * from T_MPTT_ITEM where code = :code and hierarchyCode = :hierarchyCode", params, (RowMapper)new HierarchyItemRowMapper());
        }
        catch (EmptyResultDataAccessException ex) {
            return null;
        }
    }

    public HierarchyItem getParentItem(HierarchyItem pivot) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("hierarchyCode", pivot.getHierarchyCode());
            params.put("level", (short)(pivot.getLevel() - 1));
            params.put("leftBound", pivot.getLeftBound());
            params.put("rightBound", pivot.getRightBound());
            return (HierarchyItem)this.namedParameterJdbcTemplate.queryForObject("select * from T_MPTT_ITEM where hierarchyCode = :hierarchyCode   and level = :level   and leftBound <= :leftBound   and rightBound >= :rightBound ", params, (RowMapper)new HierarchyItemRowMapper());
        }
        catch (EmptyResultDataAccessException ex) {
            return null;
        }
    }

    @Nonnull
    public List<HierarchyItem> getParentsOfItem(HierarchyItem pivot) {
        return this.namedParameterJdbcTemplate.query("select * from T_MPTT_ITEM where hierarchyCode = :hierarchyCode   and level < :level   and leftBound <= :leftBound   and rightBound >= :rightBound order by level asc", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)pivot), (RowMapper)new HierarchyItemRowMapper());
    }

    @Nonnull
    public List<HierarchyItem> getRootItems(String hierarchyCode) {
        return this.namedParameterJdbcTemplate.query("select * from T_MPTT_ITEM where hierarchyCode = :hierarchyCode   and level = 1 order by `order` asc", Collections.singletonMap("hierarchyCode", hierarchyCode), (RowMapper)new HierarchyItemRowMapper());
    }

    @Nonnull
    public List<HierarchyItem> getChildItems(HierarchyItem parent) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("hierarchyCode", parent.getHierarchyCode());
        params.put("level", (short)(parent.getLevel() + 1));
        params.put("leftBound", parent.getLeftBound());
        params.put("rightBound", parent.getRightBound());
        return this.namedParameterJdbcTemplate.query("select * from T_MPTT_ITEM where hierarchyCode = :hierarchyCode   and level = :level   and leftBound >= :leftBound   and rightBound <= :rightBound order by `order` asc", params, (RowMapper)new HierarchyItemRowMapper());
    }

    @Nonnull
    public List<HierarchyItem> getAllChildrenItems(HierarchyItem parent) {
        return this.namedParameterJdbcTemplate.query("select * from T_MPTT_ITEM where hierarchyCode = :hierarchyCode   and level > :level   and leftBound >= :leftBound   and rightBound <= :rightBound order by level asc, `order` asc", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)parent), (RowMapper)new HierarchyItemRowMapper());
    }

    @Nonnull
    public List<HierarchyItem> getLeafItems(HierarchyItem parent) {
        return this.namedParameterJdbcTemplate.query("select * from T_MPTT_ITEM where hierarchyCode = :hierarchyCode   and level > :level   and leftBound >= :leftBound   and rightBound <= :rightBound   and numberOfChildren = 0 order by level asc, `order` asc", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)parent), (RowMapper)new HierarchyItemRowMapper());
    }

    @Nonnull
    public List<HierarchyItem> getLeafItems(String hierarchyCode) {
        return this.namedParameterJdbcTemplate.query("select * from T_MPTT_ITEM where hierarchyCode = :hierarchyCode   and numberOfChildren = 0 order by leftBound asc, rightBound asc", Collections.singletonMap("hierarchyCode", hierarchyCode), (RowMapper)new HierarchyItemRowMapper());
    }

    @Nullable
    public SectionWithBucket getFirstEmptySection(String hierarchyCode, long sectionSize, short maxCount) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("hierarchyCode", hierarchyCode);
        params.put("sectionSize", sectionSize);
        Short childrenCount = (Short)this.namedParameterJdbcTemplate.queryForObject("select count(0) from T_MPTT_ITEM where hierarchyCode = :hierarchyCode and level = 1", params, Short.class);
        if (childrenCount >= maxCount) {
            return null;
        }
        if (childrenCount == 0) {
            return new SectionWithBucket(Long.valueOf(1L), Long.valueOf(sectionSize), 1);
        }
        try {
            return (SectionWithBucket)this.namedParameterJdbcTemplate.queryForObject("select t1.leftBound - :sectionSize as leftBound, t1.leftBound - 1 as rightBound, t1.bucket - 1 as bucket from T_MPTT_ITEM t1 left join T_MPTT_ITEM t2 on t2.leftBound = t1.leftBound - :sectionSize and t2.hierarchyCode = t1.hierarchyCode and t2.level = 1 where t1.hierarchyCode = :hierarchyCode   and t1.level = 1   and t1.leftBound - :sectionSize > 0   and t2.leftBound is null  order by t1.leftBound asc limit 1", params, (RowMapper)new SectionRowMapper());
        }
        catch (EmptyResultDataAccessException ex) {
            return new SectionWithBucket(Long.valueOf((long)childrenCount.shortValue() * sectionSize + 1L), Long.valueOf((long)(childrenCount + 1) * sectionSize), (short)(childrenCount + 1));
        }
    }

    @Nullable
    public SectionWithBucket getFirstEmptySection(String hierarchyCode, long sectionSize, short maxCount, HierarchyItem parent) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("hierarchyCode", hierarchyCode);
        params.put("sectionSize", sectionSize);
        params.put("level", parent.getLevel() + 1);
        params.put("parentCode", parent.getCode());
        params.put("parentLeftBound", parent.getLeftBound());
        params.put("parentRightBound", parent.getRightBound());
        Short childrenCount = (Short)this.namedParameterJdbcTemplate.queryForObject("select count(0) from T_MPTT_ITEM where hierarchyCode = :hierarchyCode   and level = :level   and leftBound >= :parentLeftBound  and rightBound <= :parentRightBound", params, Short.class);
        if (childrenCount >= maxCount) {
            return null;
        }
        if (childrenCount == 0) {
            return new SectionWithBucket(Long.valueOf(parent.getLeftBound() + 1L), Long.valueOf(parent.getLeftBound() + sectionSize), 1);
        }
        try {
            return (SectionWithBucket)this.namedParameterJdbcTemplate.queryForObject("select t1.leftBound - :sectionSize as leftBound, t1.leftBound - 1 as rightBound, t1.bucket - 1 as bucket from T_MPTT_ITEM t1 left join T_MPTT_ITEM t2 on t2.leftBound = t1.leftBound - :sectionSize and t2.hierarchyCode = t1.hierarchyCode and t2.level = :level where t1.hierarchyCode = :hierarchyCode   and t1.level = :level   and t1.leftBound - :sectionSize > :parentLeftBound   and t1.rightBound < :parentRightBound   and t2.leftBound is null  order by t1.leftBound asc limit 1", params, (RowMapper)new SectionRowMapper());
        }
        catch (EmptyResultDataAccessException ex) {
            return new SectionWithBucket(Long.valueOf(parent.getLeftBound() + (long)childrenCount.shortValue() * sectionSize + 1L), Long.valueOf(parent.getLeftBound() + (long)(childrenCount + 1) * sectionSize), (short)(childrenCount + 1));
        }
    }

    @Override
    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }
}

