/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.pmptt.model;

import javax.annotation.Nonnull;
import one.edee.oss.pmptt.dao.DbHierarchyStorage;
import one.edee.oss.pmptt.dao.HierarchyStorage;
import one.edee.oss.pmptt.exception.MaxLevelExceeded;
import one.edee.oss.pmptt.exception.PivotHierarchyNodeNotFound;
import one.edee.oss.pmptt.exception.SectionExhausted;
import one.edee.oss.pmptt.model.Hierarchy;
import one.edee.oss.pmptt.model.HierarchyItem;
import one.edee.oss.pmptt.util.Assert;
import org.springframework.transaction.support.TransactionTemplate;

public class DbHierarchy
extends Hierarchy {
    private TransactionTemplate txTemplate;

    public DbHierarchy(String code, short levels, short sectionSize) {
        super(code, levels, sectionSize);
    }

    public DbHierarchy(String code, short levels, short sectionSize, DbHierarchyStorage storage) {
        super(code, levels, sectionSize);
        this.setStorage(storage);
    }

    public void setStorage(HierarchyStorage storage) {
        super.setStorage(storage);
        Assert.isTrue((boolean)(storage instanceof DbHierarchyStorage), (String)"Storage is expected to be of type DbHierarchyStorage.");
        this.txTemplate = new TransactionTemplate(((DbHierarchyStorage)storage).getTransactionManager());
    }

    @Nonnull
    public HierarchyItem createRootItem(@Nonnull String externalId) throws SectionExhausted {
        return (HierarchyItem)this.txTemplate.execute(transactionStatus -> super.createRootItem(externalId));
    }

    @Nonnull
    public HierarchyItem createRootItem(@Nonnull String externalId, String before) throws PivotHierarchyNodeNotFound, SectionExhausted {
        return (HierarchyItem)this.txTemplate.execute(transactionStatus -> super.createRootItem(externalId, before));
    }

    @Nonnull
    public HierarchyItem createItem(@Nonnull String externalId, @Nonnull String withParent) throws PivotHierarchyNodeNotFound, SectionExhausted, MaxLevelExceeded {
        return (HierarchyItem)this.txTemplate.execute(transactionStatus -> super.createItem(externalId, withParent));
    }

    @Nonnull
    public HierarchyItem createItem(@Nonnull String externalId, @Nonnull String withParent, String before) throws PivotHierarchyNodeNotFound, SectionExhausted, MaxLevelExceeded {
        return (HierarchyItem)this.txTemplate.execute(transactionStatus -> super.createItem(externalId, withParent, before));
    }

    public void removeItem(@Nonnull String externalId) throws PivotHierarchyNodeNotFound {
        this.txTemplate.execute(transactionStatus -> {
            super.removeItem(externalId);
            return null;
        });
    }

    public void moveItemBetweenLevelsBefore(@Nonnull String externalId, @Nonnull String withParent, @Nonnull String before) {
        this.txTemplate.execute(transactionStatus -> {
            super.moveItemBetweenLevelsBefore(externalId, withParent, before);
            return null;
        });
    }

    public void moveItemBetweenLevelsBefore(@Nonnull String externalId, @Nonnull String before) {
        this.txTemplate.execute(transactionStatus -> {
            super.moveItemBetweenLevelsBefore(externalId, before);
            return null;
        });
    }

    public void moveItemBetweenLevelsAfter(@Nonnull String externalId, @Nonnull String withParent, @Nonnull String after) {
        this.txTemplate.execute(transactionStatus -> {
            super.moveItemBetweenLevelsAfter(externalId, withParent, after);
            return null;
        });
    }

    public void moveItemBetweenLevelsAfter(@Nonnull String externalId, @Nonnull String after) {
        this.txTemplate.execute(transactionStatus -> {
            super.moveItemBetweenLevelsAfter(externalId, after);
            return null;
        });
    }

    public void moveItemBetweenLevelsFirst(@Nonnull String externalId) {
        this.txTemplate.execute(transactionStatus -> {
            super.moveItemBetweenLevelsFirst(externalId);
            return null;
        });
    }

    public void moveItemBetweenLevelsFirst(@Nonnull String externalId, @Nonnull String withParent) {
        this.txTemplate.execute(transactionStatus -> {
            super.moveItemBetweenLevelsFirst(externalId, withParent);
            return null;
        });
    }

    public void moveItemBetweenLevelsLast(@Nonnull String externalId, @Nonnull String withParent) {
        this.txTemplate.execute(transactionStatus -> {
            super.moveItemBetweenLevelsLast(externalId, withParent);
            return null;
        });
    }

    public void moveItemBetweenLevelsLast(@Nonnull String externalId) {
        this.txTemplate.execute(transactionStatus -> {
            super.moveItemBetweenLevelsLast(externalId);
            return null;
        });
    }

    public void moveItemBefore(@Nonnull String externalId, @Nonnull String before) throws PivotHierarchyNodeNotFound {
        this.txTemplate.execute(transactionStatus -> {
            super.moveItemBefore(externalId, before);
            return null;
        });
    }

    public void moveItemAfter(@Nonnull String externalId, @Nonnull String after) throws PivotHierarchyNodeNotFound {
        this.txTemplate.execute(transactionStatus -> {
            super.moveItemAfter(externalId, after);
            return null;
        });
    }

    public void moveItemToFirst(@Nonnull String externalId) throws PivotHierarchyNodeNotFound {
        this.txTemplate.execute(transactionStatus -> {
            super.moveItemToFirst(externalId);
            return null;
        });
    }

    public void moveItemToLast(@Nonnull String externalId) throws PivotHierarchyNodeNotFound {
        this.txTemplate.execute(transactionStatus -> {
            super.moveItemToLast(externalId);
            return null;
        });
    }
}

