/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.trait;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import one.edee.oss.proxycian.DispatcherInvocationHandler;
import one.edee.oss.proxycian.PredicateMethodClassification;
import one.edee.oss.proxycian.ProxyStateWithConstructorArgs;
import one.edee.oss.proxycian.trait.ProxyStateAccessor;
import one.edee.oss.proxycian.util.ReflectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface SerializableProxy
extends Serializable {
    public static <T extends Serializable> PredicateMethodClassification<ProxyStateAccessor, Void, T> getWriteReplaceMethodInvoker(DeserializationProxyFactory deserializationProxyFactory) {
        return new PredicateMethodClassification<ProxyStateAccessor, Void, Serializable>("SerializableProxy.writeReplace()", (method, proxyState) -> ReflectionUtils.isMethodDeclaredOn(method, SerializableProxy.class, "writeReplace", new Class[0]), (method, proxyState) -> null, (proxy, method, args, methodContext, proxyState, invokeSuper) -> new SerializableProxyDescriptor(deserializationProxyFactory, proxy, (Serializable)proxyState, (Class[])SerializableProxy.combineInterfaces(proxy.getClass().getSuperclass(), proxy.getClass().getInterfaces(), deserializationProxyFactory.getExcludedInterfaces()), null));
    }

    public static Class<?>[] combineInterfaces(Class<?> superclass, Class<?>[] interfaces, Set<Class<?>> excludedClasses) {
        LinkedList combined = new LinkedList();
        if (!Object.class.equals(superclass) && !excludedClasses.contains(superclass)) {
            combined.add(superclass);
        }
        for (Class<?> anInterface : interfaces) {
            if (excludedClasses.contains(anInterface)) continue;
            combined.add(anInterface);
        }
        return combined.toArray(new Class[0]);
    }

    public Object writeReplace() throws ObjectStreamException;

    public static class SerializableProxyDescriptor<T extends Serializable>
    implements Serializable {
        private static final Logger log = LogManager.getLogger(SerializableProxyDescriptor.class);
        private static final long serialVersionUID = 8401525823871149500L;
        private final Class<?>[] interfaces;
        private final T proxyState;
        private final DeserializationProxyFactory deserializationProxyFactory;
        private final Map<String, Serializable> fieldValues;

        private SerializableProxyDescriptor(DeserializationProxyFactory deserializationProxyFactory, Object proxy, T proxyState, Class<?> ... interfaces) {
            this.interfaces = interfaces;
            this.proxyState = proxyState;
            this.deserializationProxyFactory = deserializationProxyFactory;
            this.fieldValues = !interfaces[0].isInterface() ? this.gatherFieldValues(proxy, interfaces[0]) : Collections.emptyMap();
        }

        protected Object readResolve() throws ObjectStreamException {
            Object deserializedProxy = this.proxyState instanceof ProxyStateWithConstructorArgs ? this.deserializationProxyFactory.deserialize((ProxyStateWithConstructorArgs)this.proxyState, this.interfaces, ((ProxyStateWithConstructorArgs)this.proxyState).getConstructorTypes(), ((ProxyStateWithConstructorArgs)this.proxyState).getConstructorArgs()) : this.deserializationProxyFactory.deserialize((Serializable)this.proxyState, this.interfaces);
            this.writeFieldValues(deserializedProxy, this.fieldValues);
            return deserializedProxy;
        }

        private Map<String, Serializable> gatherFieldValues(Object pojo, Class<?> mainClass) {
            HashMap<String, Serializable> data = new HashMap<String, Serializable>();
            try {
                for (Class<?> currentClass = mainClass; currentClass != null && !currentClass.equals(Object.class); currentClass = currentClass.getSuperclass()) {
                    for (Field field : currentClass.getDeclaredFields()) {
                        if (Modifier.isStatic(field.getModifiers())) continue;
                        try {
                            this.makeAccessible(field);
                            Object value = field.get(pojo);
                            if (value instanceof DispatcherInvocationHandler) continue;
                            if (value instanceof Serializable) {
                                data.put(field.getName(), (Serializable)value);
                                continue;
                            }
                            log.warn("Field value: " + currentClass.getName() + "#" + field.getName() + " is not Serializable!");
                        }
                        catch (Exception ignored) {
                            log.warn("Cannot access field: " + currentClass.getName() + "#" + field.getName());
                        }
                    }
                }
            }
            catch (Exception ex) {
                log.warn("Cannot serialize additional fields of: " + pojo.getClass().getName() + " (" + ex.getMessage() + ")");
            }
            return data;
        }

        private void writeFieldValues(Object proxy, Map<String, Serializable> fieldValues) {
            Class<?> currentClass = proxy.getClass();
            do {
                Iterator<Map.Entry<String, Serializable>> it = fieldValues.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Serializable> fieldEntry = it.next();
                    try {
                        Field field = currentClass.getDeclaredField(fieldEntry.getKey());
                        this.makeAccessible(field);
                        field.set(proxy, fieldEntry.getValue());
                        it.remove();
                    }
                    catch (NoSuchFieldException field) {
                    }
                    catch (IllegalAccessException ex) {
                        log.warn("Cannot deserialize class field " + currentClass.getName() + "#" + fieldEntry.getKey() + " (" + ex.getMessage() + ")");
                    }
                }
                currentClass = currentClass.getSuperclass();
            } while (!fieldValues.isEmpty() && !Object.class.equals(currentClass));
            if (!fieldValues.isEmpty()) {
                log.warn("Fields " + String.join((CharSequence)", ", fieldValues.keySet()) + "  were not deserialized, there are no matching fields in " + proxy.getClass().getName() + " class.");
            }
        }

        private void makeAccessible(Field field) {
            if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
                field.setAccessible(true);
            }
        }

        /* synthetic */ SerializableProxyDescriptor(DeserializationProxyFactory x0, Object x1, Serializable x2, Class[] x3, 1 x4) {
            this(x0, x1, x2, x3);
        }
    }

    public static interface DeserializationProxyFactory
    extends Serializable {
        @Nonnull
        public Set<Class<?>> getExcludedInterfaces();

        public Object deserialize(@Nonnull Serializable var1, @Nonnull Class<?>[] var2);

        public Object deserialize(@Nonnull ProxyStateWithConstructorArgs var1, @Nonnull Class<?>[] var2, @Nonnull Class<?>[] var3, @Nonnull Object[] var4);
    }
}

