/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.util;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface ReflectionUtils {
    public static final Map<Class<?>, Map<String, PropertyDescriptor>> PROPERTY_ACCESSOR_CACHE = new WeakHashMap(128);

    public static String[] getParameterNames(Method method) {
        String[] parameterNames = new String[method.getParameterCount()];
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter param = parameters[i];
            if (!param.isNamePresent()) {
                throw new IllegalStateException("Source code is not compiled with -parameters argument!");
            }
            parameterNames[i] = param.getName();
        }
        return parameterNames;
    }

    public static Object getProperty(Object object, String propertyName) {
        Map beanDescriptors = PROPERTY_ACCESSOR_CACHE.computeIfAbsent(object.getClass(), aClass -> {
            try {
                return Stream.of(Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors()).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
            }
            catch (IntrospectionException e) {
                throw new IllegalArgumentException("Can't introspect class " + object.getClass().getName() + "!", e);
            }
        });
        return Optional.ofNullable(beanDescriptors.get(propertyName)).map(pd -> {
            try {
                return pd.getReadMethod().invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).orElse(null);
    }

    public static MethodHandle findMethodHandle(Method method) {
        try {
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
            constructor.setAccessible(true);
            Class<?> declaringClass = method.getDeclaringClass();
            return ((MethodHandles.Lookup)constructor.newInstance(declaringClass)).unreflectSpecial(method, declaringClass);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't find handle to method " + method.toGenericString() + "!", ex);
        }
    }

    public static boolean isMethodDeclaredOn(Method method, Class<?> onClass, String withSameName, Class<?> ... withSameTypes) {
        try {
            return method.equals(onClass.getMethod(withSameName, withSameTypes));
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Matcher " + onClass.getName() + " failed to process " + method.toGenericString() + ": " + ex.getMessage(), ex);
        }
    }

    public static boolean isNonPublicMethodDeclaredOn(Method method, Class<?> onClass, String withSameName, Class<?> ... withSameTypes) {
        try {
            Method lookedUpMethod = onClass.getDeclaredMethod(withSameName, withSameTypes);
            return method.equals(lookedUpMethod) && !Modifier.isPublic(lookedUpMethod.getModifiers());
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Matcher " + onClass.getName() + " failed to process " + method.toGenericString() + ": " + ex.getMessage(), ex);
        }
    }

    public static boolean isMethodMatching(Method method, String name, Class<?> ... withSameTypes) {
        return name.equals(method.getName()) && Arrays.equals(withSameTypes, method.getParameterTypes());
    }

    public static boolean isMatchingMethodPresentOn(Method method, Class<?> ... onClass) {
        for (Class<?> aClass : onClass) {
            try {
                aClass.getMethod(method.getName(), method.getParameterTypes());
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception ex) {
                throw new IllegalStateException("Matcher " + aClass.getName() + " failed to process " + method.toGenericString() + ": " + ex.getMessage(), ex);
            }
        }
        return false;
    }

    public static boolean isMatchingMethodNotPresentOn(Method method, Class<?> ... onClass) {
        return !ReflectionUtils.isMatchingMethodPresentOn(method, onClass);
    }
}

