/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.cache;

import java.util.Arrays;
import java.util.Objects;

public class ConstructorCacheKey {
    private static final Class<?>[] EMPTY_ARGS = new Class[0];
    private final Class<?> clazz;
    private final Class<?>[] argumentTypes;
    private final int hashCode;

    public ConstructorCacheKey(Class<?> clazz) {
        this.clazz = clazz;
        this.argumentTypes = EMPTY_ARGS;
        this.hashCode = clazz.hashCode();
    }

    public ConstructorCacheKey(Class<?> clazz, Class<?>[] argumentTypes) {
        this.clazz = clazz;
        this.argumentTypes = argumentTypes;
        int hashCode = Objects.hash(clazz);
        this.hashCode = hashCode = 31 * hashCode + Arrays.hashCode(argumentTypes);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (((ConstructorCacheKey)o).hashCode != this.hashCode) {
            return false;
        }
        ConstructorCacheKey that = (ConstructorCacheKey)o;
        return this.clazz.equals(that.clazz) && Arrays.equals(this.argumentTypes, that.argumentTypes);
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Class<?>[] getArgumentTypes() {
        return this.argumentTypes;
    }
}

