/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.utils;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class GenericsUtils {
    public static Class<?> getMethodReturnType(Class<?> mainClass, Method method) {
        List<GenericBundle> resolvedTypes;
        Class<?> returnType;
        Type genericReturnType = method.getGenericReturnType();
        if (genericReturnType == (returnType = method.getReturnType())) {
            return returnType;
        }
        if (!(genericReturnType instanceof Class) && mainClass != null && !(resolvedTypes = GenericsUtils.getGenericType(mainClass, genericReturnType)).isEmpty()) {
            return resolvedTypes.get(0).getResolvedType();
        }
        return returnType;
    }

    public static List<GenericBundle> getNestedMethodReturnTypes(Class<?> mainClass, Method method) {
        List<GenericBundle> resolvedTypes;
        Class<?> returnType;
        Type genericReturnType = method.getGenericReturnType();
        if (genericReturnType == (returnType = method.getReturnType())) {
            return Collections.singletonList(new GenericBundle(returnType));
        }
        if (!(genericReturnType instanceof Class) && mainClass != null && !(resolvedTypes = GenericsUtils.getGenericType(mainClass, genericReturnType)).isEmpty()) {
            return resolvedTypes;
        }
        return Collections.singletonList(new GenericBundle(returnType));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Class<?> getGenericTypeFromCollection(Class<?> mainClass, Type returnType) {
        List<GenericBundle> arguments;
        if (!(returnType instanceof ParameterizedType)) return null;
        ParameterizedType type = (ParameterizedType)returnType;
        Type[] typeArguments = type.getActualTypeArguments();
        if (typeArguments.length != 1) throw new IllegalArgumentException("Expected single generic type in method return declaration!");
        Type typeArgument = typeArguments[0];
        if (typeArgument instanceof Class) {
            return (Class)typeArgument;
        }
        if (typeArgument instanceof ParameterizedType) {
            return (Class)((ParameterizedType)typeArgument).getRawType();
        }
        if (mainClass != null) {
            arguments = GenericsUtils.getGenericType(mainClass, typeArgument);
        } else {
            if (!(typeArgument instanceof WildcardType)) throw new IllegalArgumentException("Cannot handle generic type: " + returnType);
            Type[] upperBounds = ((WildcardType)typeArgument).getUpperBounds();
            if (upperBounds == null || upperBounds.length != 1) throw new IllegalArgumentException("Cannot handle generic type: " + returnType);
            arguments = Collections.singletonList(GenericsUtils.getClass(upperBounds[0], Collections.emptyMap()));
        }
        if (!arguments.isEmpty() && arguments.get(0) != null) {
            return arguments.get(0).getResolvedType();
        }
        try {
            return (Class)((TypeVariable)typeArgument).getBounds()[0];
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot handle generic type: " + returnType, ex);
        }
    }

    public static List<GenericBundle> getGenericType(Class<?> childClass, Type searchedType) {
        HashMap<Type, Type> resolvedTypes = new HashMap<Type, Type>();
        HashSet<Type> examinedTypes = new HashSet<Type>();
        GenericsUtils.classWalk(childClass, examinedTypes, resolvedTypes);
        Type[] actualTypeArguments = searchedType instanceof Class ? ((GenericDeclaration)((Object)searchedType)).getTypeParameters() : (searchedType instanceof ParameterizedType ? ((ParameterizedType)searchedType).getActualTypeArguments() : new Type[]{searchedType});
        ArrayList<GenericBundle> typeArgumentsAsClasses = new ArrayList<GenericBundle>(actualTypeArguments.length);
        for (Type baseType : actualTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(GenericsUtils.getClass(baseType, resolvedTypes));
        }
        return typeArgumentsAsClasses;
    }

    public static GenericBundle getClass(Type type, Map<Type, Type> resolvedTypes) {
        if (type instanceof Class) {
            return new GenericBundle((Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            GenericBundle[] childBundles = new GenericBundle[actualTypeArguments.length];
            for (Type actualTypeArgument : actualTypeArguments) {
                childBundles[0] = GenericsUtils.getClass(actualTypeArgument, resolvedTypes);
            }
            return new GenericBundle(GenericsUtils.getClass(parameterizedType.getRawType(), resolvedTypes).getResolvedType(), childBundles);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Type componentType = arrayType.getGenericComponentType();
            Class<?> componentClass = GenericsUtils.getClass(componentType, resolvedTypes).getResolvedType();
            if (componentClass != null) {
                return new GenericBundle(Array.newInstance(componentClass, 0).getClass());
            }
            return null;
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            Type resolvedType = resolvedTypes.get(typeVariable);
            return resolvedType == null ? null : GenericsUtils.getClass(resolvedType, resolvedTypes);
        }
        return null;
    }

    private static void classWalk(Type type, Set<Type> examinedTypes, Map<Type, Type> resolvedTypes) {
        if (type instanceof Class) {
            Type[] interfaces;
            Class typeClass = (Class)type;
            examinedTypes.add(typeClass);
            Type superClass = typeClass.getGenericSuperclass();
            if (superClass != null) {
                GenericsUtils.classWalk(superClass, examinedTypes, resolvedTypes);
            }
            for (Type anInterface : interfaces = typeClass.getGenericInterfaces()) {
                GenericsUtils.classWalk(anInterface, examinedTypes, resolvedTypes);
            }
        } else if (type != null) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                Type alreadyResolvedType = resolvedTypes.get(typeParameters[i]);
                if (alreadyResolvedType instanceof Class) continue;
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
            }
            GenericsUtils.classWalk(rawType, examinedTypes, resolvedTypes);
        }
    }

    private GenericsUtils() {
    }

    public static class GenericBundle {
        private final Class<?> resolvedType;
        private final GenericBundle[] genericTypes;

        public GenericBundle(@Nonnull Class<?> resolvedType) {
            this.resolvedType = resolvedType;
            this.genericTypes = null;
        }

        public Class<?> getResolvedType() {
            return this.resolvedType;
        }

        public GenericBundle[] getGenericTypes() {
            return this.genericTypes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GenericBundle)) {
                return false;
            }
            GenericBundle other = (GenericBundle)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$resolvedType = this.getResolvedType();
            Class<?> other$resolvedType = other.getResolvedType();
            if (this$resolvedType == null ? other$resolvedType != null : !this$resolvedType.equals(other$resolvedType)) {
                return false;
            }
            return Arrays.deepEquals(this.getGenericTypes(), other.getGenericTypes());
        }

        protected boolean canEqual(Object other) {
            return other instanceof GenericBundle;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $resolvedType = this.getResolvedType();
            result = result * 59 + ($resolvedType == null ? 43 : $resolvedType.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getGenericTypes());
            return result;
        }

        public String toString() {
            return "GenericsUtils.GenericBundle(resolvedType=" + this.getResolvedType() + ", genericTypes=" + Arrays.deepToString(this.getGenericTypes()) + ")";
        }

        public GenericBundle(Class<?> resolvedType, GenericBundle[] genericTypes) {
            this.resolvedType = resolvedType;
            this.genericTypes = genericTypes;
        }
    }
}

