/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.javassist;

import com.fg.edee.proxy.internal.javassist.util.proxy.MethodHandler;
import com.fg.edee.proxy.internal.javassist.util.proxy.Proxy;
import com.fg.edee.proxy.internal.javassist.util.proxy.ProxyFactory;
import com.fg.edee.proxy.internal.javassist.util.proxy.ProxyObject;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import one.edee.oss.proxycian.CurriedMethodContextInvocationHandler;
import one.edee.oss.proxycian.OnInstantiationCallback;
import one.edee.oss.proxycian.PredicateMethodClassification;
import one.edee.oss.proxycian.ProxyStateWithConstructorArgs;
import one.edee.oss.proxycian.cache.ClassMethodCacheKey;
import one.edee.oss.proxycian.cache.ConstructorCacheKey;
import one.edee.oss.proxycian.javassist.JavassistDispatcherInvocationHandler;
import one.edee.oss.proxycian.recipe.ProxyRecipe;
import one.edee.oss.proxycian.trait.ProxyStateAccessor;
import one.edee.oss.proxycian.trait.SerializableProxy;

public class JavassistProxyGenerator {
    public static final Set<Class<?>> EXCLUDED_CLASSES = new HashSet<Class>(Arrays.asList(ProxyObject.class, ProxyStateAccessor.class));
    static final Map<ClassMethodCacheKey, CurriedMethodContextInvocationHandler<?, ?>> CLASSIFICATION_CACHE = new ConcurrentHashMap(32);
    private static final Map<List<Class<?>>, Class<?>> CACHED_PROXY_CLASSES = new ConcurrentHashMap(64);
    private static final Map<ConstructorCacheKey, Constructor<?>> CACHED_PROXY_CONSTRUCTORS = new ConcurrentHashMap(64);

    public static void clearMethodClassificationCache() {
        CLASSIFICATION_CACHE.clear();
    }

    public static void clearClassCache() {
        CACHED_PROXY_CLASSES.clear();
        CACHED_PROXY_CONSTRUCTORS.clear();
    }

    public static <T> T instantiate(MethodHandler methodHandler, Class<?> ... interfaces) {
        return (T)JavassistProxyGenerator.instantiateProxy(JavassistProxyGenerator.getProxyClass(interfaces), null, methodHandler, null);
    }

    public static <T> T instantiate(MethodHandler methodHandler, Class<?>[] interfaces, Class<?>[] constructorTypes, Object[] constructorArgs) {
        return (T)JavassistProxyGenerator.instantiateProxy(JavassistProxyGenerator.getProxyClass(interfaces), null, methodHandler, null, constructorTypes, constructorArgs);
    }

    public static <T> T instantiate(ProxyRecipe proxyRecipe, Object proxyState, Class<?>[] constructorTypes, Object[] constructorArgs) {
        proxyRecipe.verifyProxyState(proxyState);
        return (T)JavassistProxyGenerator.instantiateProxy(JavassistProxyGenerator.getProxyClass(proxyRecipe.getInterfaces()), proxyState, new JavassistDispatcherInvocationHandler<Object>(proxyState, proxyRecipe.getMethodClassificationsWith(new PredicateMethodClassification[0])), proxyRecipe.getInstantiationCallback(), constructorTypes, constructorArgs);
    }

    public static <T> T instantiate(ProxyRecipe proxyRecipe, Object proxyState) {
        proxyRecipe.verifyProxyState(proxyState);
        return (T)JavassistProxyGenerator.instantiateProxy(JavassistProxyGenerator.getProxyClass(proxyRecipe.getInterfacesWith(new Class[]{ProxyStateAccessor.class})), proxyState, new JavassistDispatcherInvocationHandler<Object>(proxyState, proxyRecipe.getMethodClassificationsWith(new PredicateMethodClassification[0])), proxyRecipe.getInstantiationCallback());
    }

    public static <T> T instantiateSerializable(ProxyRecipe proxyRecipe, Serializable proxyState) {
        proxyRecipe.verifyProxyState((Object)proxyState);
        return (T)JavassistProxyGenerator.instantiateProxy(JavassistProxyGenerator.getProxyClass(proxyRecipe.getInterfacesWith(new Class[]{SerializableProxy.class})), proxyState, new JavassistDispatcherInvocationHandler<Serializable>(proxyState, proxyRecipe.getMethodClassificationsWith(new PredicateMethodClassification[]{SerializableProxy.getWriteReplaceMethodInvoker((SerializableProxy.DeserializationProxyFactory)new ProxyRecipeDeserializationProxyFactory(proxyRecipe))})), proxyRecipe.getInstantiationCallback());
    }

    public static <T> T instantiateSerializable(ProxyRecipe proxyRecipe, ProxyStateWithConstructorArgs proxyState, Class<?>[] constructorTypes, Object[] constructorArgs) {
        proxyRecipe.verifyProxyState((Object)proxyState);
        return (T)JavassistProxyGenerator.instantiateProxy(JavassistProxyGenerator.getProxyClass(proxyRecipe.getInterfacesWith(new Class[]{SerializableProxy.class})), proxyState, new JavassistDispatcherInvocationHandler<ProxyStateWithConstructorArgs>(proxyState, proxyRecipe.getMethodClassificationsWith(new PredicateMethodClassification[]{SerializableProxy.getWriteReplaceMethodInvoker((SerializableProxy.DeserializationProxyFactory)new ProxyRecipeDeserializationProxyFactory(proxyRecipe))})), proxyRecipe.getInstantiationCallback(), constructorTypes, constructorArgs);
    }

    public static Class<?> getProxyClass(Class<?> ... interfaces) {
        return CACHED_PROXY_CLASSES.computeIfAbsent(Arrays.asList(interfaces), classes -> {
            ProxyFactory fct = new ProxyFactory();
            fct.setUseCache(false);
            if (interfaces[0].isInterface()) {
                Class[] finalContract = new Class[interfaces.length + 1];
                finalContract[0] = ProxyStateAccessor.class;
                System.arraycopy(interfaces, 0, finalContract, 1, interfaces.length);
                fct.setInterfaces(finalContract);
            } else {
                Class[] finalContract = new Class[interfaces.length];
                finalContract[0] = ProxyStateAccessor.class;
                System.arraycopy(interfaces, 1, finalContract, 1, interfaces.length - 1);
                fct.setSuperclass(interfaces[0]);
                fct.setInterfaces(finalContract);
            }
            fct.setFilter(method -> !Objects.equals(method.getName(), "finalize"));
            fct.setUseCache(false);
            return fct.createClass();
        });
    }

    private static <T> T instantiateProxy(Class<T> proxyClass, Object proxyState, MethodHandler methodHandler, OnInstantiationCallback instantiationCallback) {
        try {
            T proxy = JavassistProxyGenerator.getDefaultConstructor(proxyClass).newInstance(new Object[0]);
            if (instantiationCallback != null) {
                instantiationCallback.proxyCreated(proxy, proxyState);
            }
            ((Proxy)proxy).setHandler(methodHandler);
            return proxy;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("What the heck? Can't create proxy: " + e.getMessage(), e);
        }
    }

    private static <T> T instantiateProxy(Class<T> proxyClass, Object proxyState, MethodHandler methodHandler, OnInstantiationCallback instantiationCallback, Class<?>[] constructorTypes, Object[] constructorArgs) {
        try {
            T proxy = JavassistProxyGenerator.getConstructor(proxyClass, constructorTypes).newInstance(constructorArgs);
            if (instantiationCallback != null) {
                instantiationCallback.proxyCreated(proxy, proxyState);
            }
            ((Proxy)proxy).setHandler(methodHandler);
            return proxy;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("What the heck? Can't create proxy: " + e.getMessage(), e);
        }
    }

    private static <T> Constructor<T> getDefaultConstructor(Class<T> clazz) {
        return CACHED_PROXY_CONSTRUCTORS.computeIfAbsent(new ConstructorCacheKey(clazz), aClass -> {
            try {
                return aClass.getClazz().getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("What the heck? Can't find default constructor on abstract class: " + e.getMessage(), e);
            }
        });
    }

    private static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?>[] constructorArgs) {
        return CACHED_PROXY_CONSTRUCTORS.computeIfAbsent(new ConstructorCacheKey(clazz, (Class[])constructorArgs), aClass -> {
            try {
                return aClass.getClazz().getConstructor(aClass.getArgumentTypes());
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("What the heck? Can't find constructor with arguments " + Arrays.stream(constructorArgs).map(Class::toGenericString).collect(Collectors.joining(", ")) + " on abstract class: " + e.getMessage(), e);
            }
        });
    }

    private static class ProxyRecipeDeserializationProxyFactory
    implements SerializableProxy.DeserializationProxyFactory {
        private static final long serialVersionUID = -4840857278948145538L;
        private final ProxyRecipe proxyRecipe;

        public ProxyRecipeDeserializationProxyFactory(ProxyRecipe proxyRecipe) {
            this.proxyRecipe = proxyRecipe;
        }

        @Nonnull
        public Set<Class<?>> getExcludedInterfaces() {
            return new HashSet(Collections.singletonList(Serializable.class));
        }

        public Object deserialize(@Nonnull Serializable proxyState, @Nonnull Class<?>[] interfaces) {
            return JavassistProxyGenerator.instantiateSerializable(this.proxyRecipe, proxyState);
        }

        public Object deserialize(@Nonnull ProxyStateWithConstructorArgs proxyState, @Nonnull Class<?>[] interfaces, @Nonnull Class<?>[] constructorTypes, @Nonnull Object[] constructorArgs) {
            return JavassistProxyGenerator.instantiateSerializable(this.proxyRecipe, proxyState, constructorTypes, constructorArgs);
        }
    }
}

