/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.javassist;

import com.fg.edee.proxy.internal.javassist.util.proxy.MethodHandler;
import com.fg.edee.proxy.internal.javassist.util.proxy.ProxyObject;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import one.edee.oss.proxycian.AbstractDispatcherInvocationHandler;
import one.edee.oss.proxycian.CurriedMethodContextInvocationHandler;
import one.edee.oss.proxycian.MethodClassification;
import one.edee.oss.proxycian.cache.ClassMethodCacheKey;
import one.edee.oss.proxycian.exception.InvalidSuperMethodCallException;
import one.edee.oss.proxycian.javassist.JavassistProxyGenerator;
import one.edee.oss.proxycian.trait.ProxyStateAccessor;
import one.edee.oss.proxycian.trait.StandardJavaMethods;
import one.edee.oss.proxycian.util.ReflectionUtils;

public class JavassistDispatcherInvocationHandler<T>
extends AbstractDispatcherInvocationHandler<T>
implements MethodHandler {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];

    public JavassistDispatcherInvocationHandler(T proxyState, MethodClassification<?, ?> ... methodClassifications) {
        super(proxyState, methodClassifications);
    }

    private JavassistDispatcherInvocationHandler(T proxyState, Collection<MethodClassification<?, ?>> methodClassifications) {
        super(proxyState, methodClassifications);
    }

    @Override
    public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        ClassMethodCacheKey cacheKey = this.createCacheKey(self.getClass(), this.proxyState, thisMethod);
        CurriedMethodContextInvocationHandler invocationHandler = JavassistProxyGenerator.CLASSIFICATION_CACHE.get(cacheKey);
        if (invocationHandler == null) {
            invocationHandler = this.getCurriedMethodContextInvocationHandler(thisMethod);
            JavassistProxyGenerator.CLASSIFICATION_CACHE.put(cacheKey, invocationHandler);
        }
        return invocationHandler.invoke(self, thisMethod, args, this.proxyState, (Callable)new MethodCall(proceed, self, args));
    }

    protected void addImplementationSpecificInvokers(List<MethodClassification<?, ?>> methodClassifications) {
        methodClassifications.add((MethodClassification<?, ?>)StandardJavaMethods.cloneMethodInvoker(objectToClone -> {
            try {
                JavassistDispatcherInvocationHandler originalDispatcher = (JavassistDispatcherInvocationHandler)((ProxyObject)objectToClone).getHandler();
                Object originalProxyState = objectToClone.getProxyState();
                Method cloneMethod = originalProxyState.getClass().getDeclaredMethod("clone", new Class[0]);
                cloneMethod.setAccessible(true);
                Object clonedState = cloneMethod.invoke(originalProxyState, new Object[0]);
                LinkedList interfaces = new LinkedList();
                Class<?> superClass = objectToClone.getClass().getSuperclass();
                if (!Object.class.equals(superClass)) {
                    interfaces.add(superClass);
                }
                for (Class<?> anInterface : objectToClone.getClass().getInterfaces()) {
                    if (ProxyStateAccessor.class.equals(anInterface) || ProxyObject.class.equals(anInterface)) continue;
                    interfaces.add(anInterface);
                }
                return (ProxyStateAccessor)JavassistProxyGenerator.instantiate(new JavassistDispatcherInvocationHandler<Object>(clonedState, originalDispatcher.methodClassifications), interfaces.toArray(EMPTY_CLASS_ARRAY));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new CloneNotSupportedException("Cannot clone the proxy instance due to: " + e.getMessage());
            }
        }));
    }

    private static class MethodCall
    implements Callable<Object> {
        private final Method proceed;
        private final Object self;
        private final Object[] arguments;

        @Override
        public Object call() {
            if (this.proceed == null) {
                throw new UnsupportedOperationException("Calling super method is not allowed!");
            }
            try {
                if (this.proceed.isDefault()) {
                    MethodHandle methodHandle = ReflectionUtils.findMethodHandle((Method)this.proceed);
                    return methodHandle.bindTo(this.self).invokeWithArguments(this.arguments);
                }
                return this.proceed.invoke(this.self, this.arguments);
            }
            catch (Throwable e) {
                throw new InvalidSuperMethodCallException(e);
            }
        }

        public MethodCall(Method proceed, Object self, Object[] arguments) {
            this.proceed = proceed;
            this.self = self;
            this.arguments = arguments;
        }
    }
}

