/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.cache;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ClassMethodCacheKey {
    private final Class<?> clazz;
    private final Object proxyStateCacheKey;
    private final Method method;
    private final Object[] cacheKey;
    private final int hash;

    public ClassMethodCacheKey(@Nonnull Class<?> clazz, @Nonnull Object proxyStateCacheKey, @Nonnull Method method, @Nonnull Object[] cacheKey) {
        this.clazz = clazz;
        this.proxyStateCacheKey = proxyStateCacheKey;
        this.method = method;
        this.cacheKey = cacheKey;
        this.hash = Objects.hash(clazz, proxyStateCacheKey, method, Arrays.hashCode(cacheKey));
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (((ClassMethodCacheKey)o).hash != this.hash) {
            return false;
        }
        ClassMethodCacheKey that = (ClassMethodCacheKey)o;
        return Objects.equals(this.clazz, that.clazz) && Objects.equals(this.proxyStateCacheKey, that.proxyStateCacheKey) && Objects.equals(this.method, that.method) && Arrays.equals(this.cacheKey, that.cacheKey);
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Object getProxyStateCacheKey() {
        return this.proxyStateCacheKey;
    }

    public Method getMethod() {
        return this.method;
    }
}

