/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.javassist.original;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Comparator;
import one.edee.oss.proxycian.javassist.original.javassistCannotCompileException;
import one.edee.oss.proxycian.javassist.original.javassistClassPool;
import one.edee.oss.proxycian.javassist.original.javassistCtClass;
import one.edee.oss.proxycian.javassist.original.javassistCtConstructor;
import one.edee.oss.proxycian.javassist.original.javassistCtField;
import one.edee.oss.proxycian.javassist.original.javassistCtMethod;
import one.edee.oss.proxycian.javassist.original.javassistNotFoundException;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.ClassFile;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.Descriptor;

public class javassistSerialVersionUID {
    public static void setSerialVersionUID(javassistCtClass clazz) throws javassistCannotCompileException, javassistNotFoundException {
        try {
            clazz.getDeclaredField("serialVersionUID");
            return;
        }
        catch (javassistNotFoundException javassistNotFoundException2) {
            if (!javassistSerialVersionUID.isSerializable(clazz)) {
                return;
            }
            javassistCtField field = new javassistCtField(javassistCtClass.longType, "serialVersionUID", clazz);
            field.setModifiers(26);
            clazz.addField(field, javassistSerialVersionUID.calculateDefault(clazz) + "L");
            return;
        }
    }

    private static boolean isSerializable(javassistCtClass clazz) throws javassistNotFoundException {
        javassistClassPool pool = clazz.getClassPool();
        return clazz.subtypeOf(pool.get("java.io.Serializable"));
    }

    public static long calculateDefault(javassistCtClass clazz) throws javassistCannotCompileException {
        try {
            int mods;
            int i;
            int i2;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bout);
            ClassFile classFile = clazz.getClassFile();
            String javaName = javassistSerialVersionUID.javaName(clazz);
            out.writeUTF(javaName);
            javassistCtMethod[] methods = clazz.getDeclaredMethods();
            int classMods = clazz.getModifiers();
            if ((classMods & 0x200) != 0) {
                classMods = methods.length > 0 ? (classMods |= 0x400) : (classMods &= 0xFFFFFBFF);
            }
            out.writeInt(classMods);
            Object[] interfaces = classFile.getInterfaces();
            for (i2 = 0; i2 < interfaces.length; ++i2) {
                interfaces[i2] = javassistSerialVersionUID.javaName((String)interfaces[i2]);
            }
            Arrays.sort(interfaces);
            for (i2 = 0; i2 < interfaces.length; ++i2) {
                out.writeUTF((String)interfaces[i2]);
            }
            javassistCtField[] fields = clazz.getDeclaredFields();
            Arrays.sort(fields, new Comparator<javassistCtField>(){

                @Override
                public int compare(javassistCtField field1, javassistCtField field2) {
                    return field1.getName().compareTo(field2.getName());
                }
            });
            for (int i3 = 0; i3 < fields.length; ++i3) {
                javassistCtField field = fields[i3];
                int mods2 = field.getModifiers();
                if ((mods2 & 2) != 0 && (mods2 & 0x88) != 0) continue;
                out.writeUTF(field.getName());
                out.writeInt(mods2);
                out.writeUTF(field.getFieldInfo2().getDescriptor());
            }
            if (classFile.getStaticInitializer() != null) {
                out.writeUTF("<clinit>");
                out.writeInt(8);
                out.writeUTF("()V");
            }
            javassistCtConstructor[] constructors = clazz.getDeclaredConstructors();
            Arrays.sort(constructors, new Comparator<javassistCtConstructor>(){

                @Override
                public int compare(javassistCtConstructor c1, javassistCtConstructor c2) {
                    return c1.getMethodInfo2().getDescriptor().compareTo(c2.getMethodInfo2().getDescriptor());
                }
            });
            for (i = 0; i < constructors.length; ++i) {
                javassistCtConstructor constructor = constructors[i];
                mods = constructor.getModifiers();
                if ((mods & 2) != 0) continue;
                out.writeUTF("<init>");
                out.writeInt(mods);
                out.writeUTF(constructor.getMethodInfo2().getDescriptor().replace('/', '.'));
            }
            Arrays.sort(methods, new Comparator<javassistCtMethod>(){

                @Override
                public int compare(javassistCtMethod m1, javassistCtMethod m2) {
                    int value = m1.getName().compareTo(m2.getName());
                    if (value == 0) {
                        value = m1.getMethodInfo2().getDescriptor().compareTo(m2.getMethodInfo2().getDescriptor());
                    }
                    return value;
                }
            });
            for (i = 0; i < methods.length; ++i) {
                javassistCtMethod method = methods[i];
                mods = method.getModifiers() & 0xD3F;
                if ((mods & 2) != 0) continue;
                out.writeUTF(method.getName());
                out.writeInt(mods);
                out.writeUTF(method.getMethodInfo2().getDescriptor().replace('/', '.'));
            }
            out.flush();
            MessageDigest digest = MessageDigest.getInstance("SHA");
            byte[] digested = digest.digest(bout.toByteArray());
            long hash = 0L;
            for (int i4 = Math.min(digested.length, 8) - 1; i4 >= 0; --i4) {
                hash = hash << 8 | (long)(digested[i4] & 0xFF);
            }
            return hash;
        }
        catch (IOException e) {
            throw new javassistCannotCompileException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new javassistCannotCompileException(e);
        }
    }

    private static String javaName(javassistCtClass clazz) {
        return Descriptor.toJavaName(Descriptor.toJvmName(clazz));
    }

    private static String javaName(String name) {
        return Descriptor.toJavaName(Descriptor.toJvmName(name));
    }
}

