/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.javassist.original.javassisttools.reflect;

import one.edee.oss.proxycian.javassist.original.javassistCannotCompileException;
import one.edee.oss.proxycian.javassist.original.javassistClassPool;
import one.edee.oss.proxycian.javassist.original.javassistCodeConverter;
import one.edee.oss.proxycian.javassist.original.javassistCtClass;
import one.edee.oss.proxycian.javassist.original.javassistCtField;
import one.edee.oss.proxycian.javassist.original.javassistCtMethod;
import one.edee.oss.proxycian.javassist.original.javassistCtNewMethod;
import one.edee.oss.proxycian.javassist.original.javassistModifier;
import one.edee.oss.proxycian.javassist.original.javassistNotFoundException;
import one.edee.oss.proxycian.javassist.original.javassistTranslator;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.BadBytecode;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.ClassFile;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.MethodInfo;
import one.edee.oss.proxycian.javassist.original.javassisttools.reflect.CannotReflectException;

public class Reflection
implements javassistTranslator {
    static final String classobjectField = "_classobject";
    static final String classobjectAccessor = "_getClass";
    static final String metaobjectField = "_metaobject";
    static final String metaobjectGetter = "_getMetaobject";
    static final String metaobjectSetter = "_setMetaobject";
    static final String readPrefix = "_r_";
    static final String writePrefix = "_w_";
    static final String metaobjectClassName = "one.edee.oss.proxycian.javassist.original.javassisttools.reflect.Metaobject";
    static final String classMetaobjectClassName = "one.edee.oss.proxycian.javassist.original.javassisttools.reflect.ClassMetaobject";
    protected javassistCtMethod trapMethod;
    protected javassistCtMethod trapStaticMethod;
    protected javassistCtMethod trapRead;
    protected javassistCtMethod trapWrite;
    protected javassistCtClass[] readParam;
    protected javassistClassPool classPool = null;
    protected javassistCodeConverter converter = new javassistCodeConverter();

    private boolean isExcluded(String name) {
        return name.startsWith("_m_") || name.equals(classobjectAccessor) || name.equals(metaobjectSetter) || name.equals(metaobjectGetter) || name.startsWith(readPrefix) || name.startsWith(writePrefix);
    }

    @Override
    public void start(javassistClassPool pool) throws javassistNotFoundException {
        this.classPool = pool;
        String msg = "one.edee.oss.proxycian.javassist.original.javassisttools.reflect.Sample is not found or broken.";
        try {
            javassistCtClass c = this.classPool.get("one.edee.oss.proxycian.javassist.original.javassisttools.reflect.Sample");
            this.rebuildClassFile(c.getClassFile());
            this.trapMethod = c.getDeclaredMethod("trap");
            this.trapStaticMethod = c.getDeclaredMethod("trapStatic");
            this.trapRead = c.getDeclaredMethod("trapRead");
            this.trapWrite = c.getDeclaredMethod("trapWrite");
            this.readParam = new javassistCtClass[]{this.classPool.get("java.lang.Object")};
        }
        catch (javassistNotFoundException e) {
            throw new RuntimeException("one.edee.oss.proxycian.javassist.original.javassisttools.reflect.Sample is not found or broken.");
        }
        catch (BadBytecode e) {
            throw new RuntimeException("one.edee.oss.proxycian.javassist.original.javassisttools.reflect.Sample is not found or broken.");
        }
    }

    @Override
    public void onLoad(javassistClassPool pool, String classname) throws javassistCannotCompileException, javassistNotFoundException {
        javassistCtClass clazz = pool.get(classname);
        clazz.instrument(this.converter);
    }

    public boolean makeReflective(String classname, String metaobject, String metaclass) throws javassistCannotCompileException, javassistNotFoundException {
        return this.makeReflective(this.classPool.get(classname), this.classPool.get(metaobject), this.classPool.get(metaclass));
    }

    public boolean makeReflective(Class<?> clazz, Class<?> metaobject, Class<?> metaclass) throws javassistCannotCompileException, javassistNotFoundException {
        return this.makeReflective(clazz.getName(), metaobject.getName(), metaclass.getName());
    }

    public boolean makeReflective(javassistCtClass clazz, javassistCtClass metaobject, javassistCtClass metaclass) throws javassistCannotCompileException, CannotReflectException, javassistNotFoundException {
        if (clazz.isInterface()) {
            throw new CannotReflectException("Cannot reflect an interface: " + clazz.getName());
        }
        if (clazz.subclassOf(this.classPool.get(classMetaobjectClassName))) {
            throw new CannotReflectException("Cannot reflect a subclass of ClassMetaobject: " + clazz.getName());
        }
        if (clazz.subclassOf(this.classPool.get(metaobjectClassName))) {
            throw new CannotReflectException("Cannot reflect a subclass of Metaobject: " + clazz.getName());
        }
        this.registerReflectiveClass(clazz);
        return this.modifyClassfile(clazz, metaobject, metaclass);
    }

    private void registerReflectiveClass(javassistCtClass clazz) {
        javassistCtField[] fs = clazz.getDeclaredFields();
        for (int i = 0; i < fs.length; ++i) {
            javassistCtField f = fs[i];
            int mod = f.getModifiers();
            if ((mod & 1) == 0 || (mod & 0x10) != 0) continue;
            String name = f.getName();
            this.converter.replaceFieldRead(f, clazz, readPrefix + name);
            this.converter.replaceFieldWrite(f, clazz, writePrefix + name);
        }
    }

    private boolean modifyClassfile(javassistCtClass clazz, javassistCtClass metaobject, javassistCtClass metaclass) throws javassistCannotCompileException, javassistNotFoundException {
        javassistCtField f;
        boolean addMeta;
        if (clazz.getAttribute("Reflective") != null) {
            return false;
        }
        clazz.setAttribute("Reflective", new byte[0]);
        javassistCtClass mlevel = this.classPool.get("one.edee.oss.proxycian.javassist.original.javassisttools.reflect.Metalevel");
        boolean bl = addMeta = !clazz.subtypeOf(mlevel);
        if (addMeta) {
            clazz.addInterface(mlevel);
        }
        this.processMethods(clazz, addMeta);
        this.processFields(clazz);
        if (addMeta) {
            f = new javassistCtField(this.classPool.get(metaobjectClassName), metaobjectField, clazz);
            f.setModifiers(4);
            clazz.addField(f, javassistCtField.Initializer.byNewWithParams(metaobject));
            clazz.addMethod(javassistCtNewMethod.getter(metaobjectGetter, f));
            clazz.addMethod(javassistCtNewMethod.setter(metaobjectSetter, f));
        }
        f = new javassistCtField(this.classPool.get(classMetaobjectClassName), classobjectField, clazz);
        f.setModifiers(10);
        clazz.addField(f, javassistCtField.Initializer.byNew(metaclass, new String[]{clazz.getName()}));
        clazz.addMethod(javassistCtNewMethod.getter(classobjectAccessor, f));
        return true;
    }

    private void processMethods(javassistCtClass clazz, boolean dontSearch) throws javassistCannotCompileException, javassistNotFoundException {
        javassistCtMethod[] ms = clazz.getMethods();
        for (int i = 0; i < ms.length; ++i) {
            javassistCtMethod m = ms[i];
            int mod = m.getModifiers();
            if (!javassistModifier.isPublic(mod) || javassistModifier.isAbstract(mod)) continue;
            this.processMethods0(mod, clazz, m, i, dontSearch);
        }
    }

    private void processMethods0(int mod, javassistCtClass clazz, javassistCtMethod m, int identifier, boolean dontSearch) throws javassistCannotCompileException, javassistNotFoundException {
        javassistCtMethod m2;
        String name = m.getName();
        if (this.isExcluded(name)) {
            return;
        }
        if (m.getDeclaringClass() == clazz) {
            if (javassistModifier.isNative(mod)) {
                return;
            }
            m2 = m;
            if (javassistModifier.isFinal(mod)) {
                m2.setModifiers(mod &= 0xFFFFFFEF);
            }
        } else {
            if (javassistModifier.isFinal(mod)) {
                return;
            }
            m2 = javassistCtNewMethod.delegator(this.findOriginal(m, dontSearch), clazz);
            m2.setModifiers(mod &= 0xFFFFFEFF);
            clazz.addMethod(m2);
        }
        m2.setName("_m_" + identifier + "_" + name);
        javassistCtMethod body = javassistModifier.isStatic(mod) ? this.trapStaticMethod : this.trapMethod;
        javassistCtMethod wmethod = javassistCtNewMethod.wrapped(m.getReturnType(), name, m.getParameterTypes(), m.getExceptionTypes(), body, javassistCtMethod.ConstParameter.integer(identifier), clazz);
        wmethod.setModifiers(mod);
        clazz.addMethod(wmethod);
    }

    private javassistCtMethod findOriginal(javassistCtMethod m, boolean dontSearch) throws javassistNotFoundException {
        if (dontSearch) {
            return m;
        }
        String name = m.getName();
        javassistCtMethod[] ms = m.getDeclaringClass().getDeclaredMethods();
        for (int i = 0; i < ms.length; ++i) {
            String orgName = ms[i].getName();
            if (!orgName.endsWith(name) || !orgName.startsWith("_m_") || !ms[i].getSignature().equals(m.getSignature())) continue;
            return ms[i];
        }
        return m;
    }

    private void processFields(javassistCtClass clazz) throws javassistCannotCompileException, javassistNotFoundException {
        javassistCtField[] fs = clazz.getDeclaredFields();
        for (int i = 0; i < fs.length; ++i) {
            javassistCtField f = fs[i];
            int mod = f.getModifiers();
            if ((mod & 1) == 0 || (mod & 0x10) != 0) continue;
            String name = f.getName();
            javassistCtClass ftype = f.getType();
            javassistCtMethod wmethod = javassistCtNewMethod.wrapped(ftype, readPrefix + name, this.readParam, null, this.trapRead, javassistCtMethod.ConstParameter.string(name), clazz);
            wmethod.setModifiers(mod |= 8);
            clazz.addMethod(wmethod);
            javassistCtClass[] writeParam = new javassistCtClass[]{this.classPool.get("java.lang.Object"), ftype};
            wmethod = javassistCtNewMethod.wrapped(javassistCtClass.voidType, writePrefix + name, writeParam, null, this.trapWrite, javassistCtMethod.ConstParameter.string(name), clazz);
            wmethod.setModifiers(mod);
            clazz.addMethod(wmethod);
        }
    }

    public void rebuildClassFile(ClassFile cf) throws BadBytecode {
        if (ClassFile.MAJOR_VERSION < 50) {
            return;
        }
        for (MethodInfo mi : cf.getMethods()) {
            mi.rebuildStackMap(this.classPool);
        }
    }
}

