/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import one.edee.oss.proxycian.cache.ConstructorCacheKey;

public class ClassUtils {
    @Nonnull
    public static Constructor<?> findConstructor(@Nonnull ConstructorCacheKey aClass, @Nonnull Class<?>[] constructorArgs) {
        Class<?> ownerClass = aClass.getClazz();
        try {
            Constructor<?> constructor = ownerClass.getDeclaredConstructor(aClass.getArgumentTypes());
            if (Modifier.isPrivate(constructor.getModifiers())) {
                throw new NoSuchMethodException();
            }
            if (Modifier.isProtected(constructor.getModifiers())) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        catch (NoSuchMethodException e) {
            block2: for (Constructor<?> declaredConstructor : ownerClass.getDeclaredConstructors()) {
                if (declaredConstructor.getParameterTypes().length != constructorArgs.length) continue;
                Class<?>[] requiredConstructorArgs = declaredConstructor.getParameterTypes();
                for (int i = 0; i < requiredConstructorArgs.length; ++i) {
                    Class<?> requiredConstructorArg = requiredConstructorArgs[i];
                    Class<?> providedConstructorArg = constructorArgs[i];
                    if (!requiredConstructorArg.isAssignableFrom(providedConstructorArg)) continue block2;
                }
                return declaredConstructor;
            }
            throw new IllegalArgumentException("What the heck? Can't find public/protected constructor with arguments " + Arrays.stream(constructorArgs).map(Class::toGenericString).collect(Collectors.joining(", ")) + " on abstract class: " + e.getMessage(), e);
        }
    }

    private ClassUtils() {
    }
}

