/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.utils;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GenericsUtils {
    public static Class<?> getMethodReturnType(Class<?> mainClass, Method methodInvocation) {
        return GenericsUtils.getMethodReturnType(mainClass, methodInvocation, null);
    }

    public static Class<?> getMethodReturnType(Class<?> mainClass, Method method, List<Class<?>> alreadyResolvedClasses) {
        Class<?> returnType;
        Type genericReturnType = method.getGenericReturnType();
        if (genericReturnType == (returnType = method.getReturnType())) {
            return returnType;
        }
        Class<?> result = null;
        if (!(genericReturnType instanceof Class)) {
            List<Class<?>> resolvedTypes;
            if (mainClass != null && !(resolvedTypes = GenericsUtils.getGenericType(mainClass, genericReturnType)).isEmpty()) {
                result = resolvedTypes.get(0);
            }
            if (result == null && alreadyResolvedClasses != null && !alreadyResolvedClasses.isEmpty()) {
                result = alreadyResolvedClasses.get(0);
            }
        }
        if (result == null) {
            result = returnType;
        }
        return result;
    }

    public static Class<?> getGenericTypeFromCollection(Class<?> mainClass, Type returnType) {
        return GenericsUtils.getGenericTypeFromCollection(mainClass, returnType, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Class<?> getGenericTypeFromCollection(Class<?> mainClass, Type returnType, List<Class<?>> alreadyResolvedTypes) {
        List<Class<?>> arguments;
        if (!(returnType instanceof ParameterizedType)) return null;
        ParameterizedType type = (ParameterizedType)returnType;
        Type[] typeArguments = type.getActualTypeArguments();
        if (typeArguments.length != 1) throw new IllegalArgumentException("Expected single generic type in method return declaration!");
        Type typeArgument = typeArguments[0];
        if (typeArgument instanceof Class) {
            return (Class)typeArgument;
        }
        if (typeArgument instanceof ParameterizedType) {
            return (Class)((ParameterizedType)typeArgument).getRawType();
        }
        if (alreadyResolvedTypes != null && !alreadyResolvedTypes.isEmpty()) {
            arguments = alreadyResolvedTypes;
        } else if (mainClass != null) {
            arguments = GenericsUtils.getGenericType(mainClass, typeArgument);
        } else {
            if (!(typeArgument instanceof WildcardType)) throw new IllegalArgumentException("Cannot handle generic type: " + returnType.toString());
            Type[] upperBounds = ((WildcardType)typeArgument).getUpperBounds();
            if (upperBounds == null || upperBounds.length != 1) throw new IllegalArgumentException("Cannot handle generic type: " + returnType.toString());
            arguments = Collections.singletonList(GenericsUtils.getClass(upperBounds[0]));
        }
        if (!arguments.isEmpty() && arguments.get(0) != null) {
            return arguments.get(0);
        }
        try {
            return (Class)((TypeVariable)typeArgument).getBounds()[0];
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot handle generic type: " + returnType.toString(), ex);
        }
    }

    public static List<Class<?>> getGenericType(Class<?> childClass, Type searchedType) {
        HashMap<Type, Type> resolvedTypes = new HashMap<Type, Type>();
        HashSet<Type> examinedTypes = new HashSet<Type>();
        GenericsUtils.classWalk(childClass, examinedTypes, resolvedTypes);
        Type[] actualTypeArguments = searchedType instanceof Class ? ((GenericDeclaration)((Object)searchedType)).getTypeParameters() : (searchedType instanceof ParameterizedType ? ((ParameterizedType)searchedType).getActualTypeArguments() : new Type[]{searchedType});
        ArrayList typeArgumentsAsClasses = new ArrayList();
        for (Type baseType : actualTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(GenericsUtils.getClass(baseType));
        }
        return typeArgumentsAsClasses;
    }

    public static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return GenericsUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = GenericsUtils.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    private static void classWalk(Type type, Set<Type> examinedTypes, Map<Type, Type> resolvedTypes) {
        if (type instanceof Class) {
            Type[] interfaces;
            Class typeClass = (Class)type;
            examinedTypes.add(typeClass);
            Type superClass = typeClass.getGenericSuperclass();
            if (superClass != null) {
                GenericsUtils.classWalk(superClass, examinedTypes, resolvedTypes);
            }
            for (Type anInterface : interfaces = typeClass.getGenericInterfaces()) {
                GenericsUtils.classWalk(anInterface, examinedTypes, resolvedTypes);
            }
        } else if (type != null) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                Type alreadyResolvedType = resolvedTypes.get(typeParameters[i]);
                if (alreadyResolvedType instanceof Class) continue;
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
            }
            GenericsUtils.classWalk(rawType, examinedTypes, resolvedTypes);
        }
    }

    private GenericsUtils() {
    }
}

