/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian.javassist.original;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Collection;
import one.edee.oss.proxycian.javassist.original.javassistCannotCompileException;
import one.edee.oss.proxycian.javassist.original.javassistClassMap;
import one.edee.oss.proxycian.javassist.original.javassistClassPool;
import one.edee.oss.proxycian.javassist.original.javassistCodeConverter;
import one.edee.oss.proxycian.javassist.original.javassistCtBehavior;
import one.edee.oss.proxycian.javassist.original.javassistCtConstructor;
import one.edee.oss.proxycian.javassist.original.javassistCtField;
import one.edee.oss.proxycian.javassist.original.javassistCtMethod;
import one.edee.oss.proxycian.javassist.original.javassistCtPrimitiveType;
import one.edee.oss.proxycian.javassist.original.javassistNotFoundException;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.ClassFile;
import one.edee.oss.proxycian.javassist.original.javassistbytecode.Descriptor;
import one.edee.oss.proxycian.javassist.original.javassistcompiler.AccessorMaker;
import one.edee.oss.proxycian.javassist.original.javassistexpr.ExprEditor;

public abstract class javassistCtClass {
    protected String qualifiedName;
    public static String debugDump = null;
    public static final String version = "3.29.0-GA";
    static final String javaLangObject = "java.lang.Object";
    public static javassistCtClass booleanType;
    public static javassistCtClass charType;
    public static javassistCtClass byteType;
    public static javassistCtClass shortType;
    public static javassistCtClass intType;
    public static javassistCtClass longType;
    public static javassistCtClass floatType;
    public static javassistCtClass doubleType;
    public static javassistCtClass voidType;
    static javassistCtClass[] primitiveTypes;

    public static void main(String[] args) {
        System.out.println("Javassist version 3.29.0-GA");
        System.out.println("Copyright (C) 1999-2022 Shigeru Chiba. All Rights Reserved.");
    }

    protected javassistCtClass(String name) {
        this.qualifiedName = name;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getName());
        buf.append('@');
        buf.append(Integer.toHexString(this.hashCode()));
        buf.append('[');
        this.extendToString(buf);
        buf.append(']');
        return buf.toString();
    }

    protected void extendToString(StringBuilder buffer) {
        buffer.append(this.getName());
    }

    public javassistClassPool getClassPool() {
        return null;
    }

    public ClassFile getClassFile() {
        this.checkModify();
        return this.getClassFile2();
    }

    public ClassFile getClassFile2() {
        return null;
    }

    public AccessorMaker getAccessorMaker() {
        return null;
    }

    public URL getURL() throws javassistNotFoundException {
        throw new javassistNotFoundException(this.getName());
    }

    public boolean isModified() {
        return false;
    }

    public boolean isFrozen() {
        return true;
    }

    public void freeze() {
    }

    void checkModify() throws RuntimeException {
        if (this.isFrozen()) {
            throw new RuntimeException(this.getName() + " class is frozen");
        }
    }

    public void defrost() {
        throw new RuntimeException("cannot defrost " + this.getName());
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isKotlin() {
        return this.hasAnnotation("kotlin.Metadata");
    }

    public javassistCtClass getComponentType() throws javassistNotFoundException {
        return null;
    }

    public boolean subtypeOf(javassistCtClass clazz) throws javassistNotFoundException {
        return this == clazz || this.getName().equals(clazz.getName());
    }

    public String getName() {
        return this.qualifiedName;
    }

    public final String getSimpleName() {
        String qname = this.qualifiedName;
        int index = qname.lastIndexOf(46);
        if (index < 0) {
            return qname;
        }
        return qname.substring(index + 1);
    }

    public final String getPackageName() {
        String qname = this.qualifiedName;
        int index = qname.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        return qname.substring(0, index);
    }

    public void setName(String name) {
        this.checkModify();
        if (name != null) {
            this.qualifiedName = name;
        }
    }

    public String getGenericSignature() {
        return null;
    }

    public void setGenericSignature(String sig) {
        this.checkModify();
    }

    public void replaceClassName(String oldName, String newName) {
        this.checkModify();
    }

    public void replaceClassName(javassistClassMap map) {
        this.checkModify();
    }

    public synchronized Collection<String> getRefClasses() {
        ClassFile cf = this.getClassFile2();
        if (cf != null) {
            javassistClassMap cm = new javassistClassMap(){
                private static final long serialVersionUID = 1L;

                @Override
                public String put(String oldname, String newname) {
                    return this.put0(oldname, newname);
                }

                @Override
                public String get(Object jvmClassName) {
                    String n = 1.toJavaName((String)jvmClassName);
                    this.put0(n, n);
                    return null;
                }

                @Override
                public void fix(String name) {
                }
            };
            cf.getRefClasses(cm);
            return cm.values();
        }
        return null;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isAnnotation() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public int getModifiers() {
        return 0;
    }

    public boolean hasAnnotation(Class<?> annotationType) {
        return this.hasAnnotation(annotationType.getName());
    }

    public boolean hasAnnotation(String annotationTypeName) {
        return false;
    }

    public Object getAnnotation(Class<?> clz) throws ClassNotFoundException {
        return null;
    }

    public Object[] getAnnotations() throws ClassNotFoundException {
        return new Object[0];
    }

    public Object[] getAvailableAnnotations() {
        return new Object[0];
    }

    public javassistCtClass[] getDeclaredClasses() throws javassistNotFoundException {
        return this.getNestedClasses();
    }

    public javassistCtClass[] getNestedClasses() throws javassistNotFoundException {
        return new javassistCtClass[0];
    }

    public void setModifiers(int mod) {
        this.checkModify();
    }

    public boolean subclassOf(javassistCtClass superclass) {
        return false;
    }

    public javassistCtClass getSuperclass() throws javassistNotFoundException {
        return null;
    }

    public void setSuperclass(javassistCtClass clazz) throws javassistCannotCompileException {
        this.checkModify();
    }

    public javassistCtClass[] getInterfaces() throws javassistNotFoundException {
        return new javassistCtClass[0];
    }

    public void setInterfaces(javassistCtClass[] list) {
        this.checkModify();
    }

    public void addInterface(javassistCtClass anInterface) {
        this.checkModify();
    }

    public javassistCtClass getDeclaringClass() throws javassistNotFoundException {
        return null;
    }

    @Deprecated
    public final javassistCtMethod getEnclosingMethod() throws javassistNotFoundException {
        javassistCtBehavior b = this.getEnclosingBehavior();
        if (b == null) {
            return null;
        }
        if (b instanceof javassistCtMethod) {
            return (javassistCtMethod)b;
        }
        throw new javassistNotFoundException(b.getLongName() + " is enclosing " + this.getName());
    }

    public javassistCtBehavior getEnclosingBehavior() throws javassistNotFoundException {
        return null;
    }

    public javassistCtClass makeNestedClass(String name, boolean isStatic) {
        throw new RuntimeException(this.getName() + " is not a class");
    }

    public javassistCtField[] getFields() {
        return new javassistCtField[0];
    }

    public javassistCtField getField(String name) throws javassistNotFoundException {
        return this.getField(name, null);
    }

    public javassistCtField getField(String name, String desc) throws javassistNotFoundException {
        throw new javassistNotFoundException(name);
    }

    javassistCtField getField2(String name, String desc) {
        return null;
    }

    public javassistCtField[] getDeclaredFields() {
        return new javassistCtField[0];
    }

    public javassistCtField getDeclaredField(String name) throws javassistNotFoundException {
        throw new javassistNotFoundException(name);
    }

    public javassistCtField getDeclaredField(String name, String desc) throws javassistNotFoundException {
        throw new javassistNotFoundException(name);
    }

    public javassistCtBehavior[] getDeclaredBehaviors() {
        return new javassistCtBehavior[0];
    }

    public javassistCtConstructor[] getConstructors() {
        return new javassistCtConstructor[0];
    }

    public javassistCtConstructor getConstructor(String desc) throws javassistNotFoundException {
        throw new javassistNotFoundException("no such constructor");
    }

    public javassistCtConstructor[] getDeclaredConstructors() {
        return new javassistCtConstructor[0];
    }

    public javassistCtConstructor getDeclaredConstructor(javassistCtClass[] params) throws javassistNotFoundException {
        String desc = Descriptor.ofConstructor(params);
        return this.getConstructor(desc);
    }

    public javassistCtConstructor getClassInitializer() {
        return null;
    }

    public javassistCtMethod[] getMethods() {
        return new javassistCtMethod[0];
    }

    public javassistCtMethod getMethod(String name, String desc) throws javassistNotFoundException {
        throw new javassistNotFoundException(name);
    }

    public javassistCtMethod[] getDeclaredMethods() {
        return new javassistCtMethod[0];
    }

    public javassistCtMethod getDeclaredMethod(String name, javassistCtClass[] params) throws javassistNotFoundException {
        throw new javassistNotFoundException(name);
    }

    public javassistCtMethod[] getDeclaredMethods(String name) throws javassistNotFoundException {
        throw new javassistNotFoundException(name);
    }

    public javassistCtMethod getDeclaredMethod(String name) throws javassistNotFoundException {
        throw new javassistNotFoundException(name);
    }

    public javassistCtConstructor makeClassInitializer() throws javassistCannotCompileException {
        throw new javassistCannotCompileException("not a class");
    }

    public void addConstructor(javassistCtConstructor c) throws javassistCannotCompileException {
        this.checkModify();
    }

    public void removeConstructor(javassistCtConstructor c) throws javassistNotFoundException {
        this.checkModify();
    }

    public void addMethod(javassistCtMethod m) throws javassistCannotCompileException {
        this.checkModify();
    }

    public void removeMethod(javassistCtMethod m) throws javassistNotFoundException {
        this.checkModify();
    }

    public void addField(javassistCtField f) throws javassistCannotCompileException {
        this.addField(f, (javassistCtField.Initializer)null);
    }

    public void addField(javassistCtField f, String init) throws javassistCannotCompileException {
        this.checkModify();
    }

    public void addField(javassistCtField f, javassistCtField.Initializer init) throws javassistCannotCompileException {
        this.checkModify();
    }

    public void removeField(javassistCtField f) throws javassistNotFoundException {
        this.checkModify();
    }

    public byte[] getAttribute(String name) {
        return null;
    }

    public void setAttribute(String name, byte[] data) {
        this.checkModify();
    }

    public void instrument(javassistCodeConverter converter) throws javassistCannotCompileException {
        this.checkModify();
    }

    public void instrument(ExprEditor editor) throws javassistCannotCompileException {
        this.checkModify();
    }

    public Class<?> toClass() throws javassistCannotCompileException {
        return this.getClassPool().toClass(this);
    }

    public Class<?> toClass(Class<?> neighbor) throws javassistCannotCompileException {
        return this.getClassPool().toClass(this, neighbor);
    }

    public Class<?> toClass(MethodHandles.Lookup lookup) throws javassistCannotCompileException {
        return this.getClassPool().toClass(this, lookup);
    }

    public Class<?> toClass(ClassLoader loader, ProtectionDomain domain) throws javassistCannotCompileException {
        javassistClassPool cp = this.getClassPool();
        if (loader == null) {
            loader = cp.getClassLoader();
        }
        return cp.toClass(this, null, loader, domain);
    }

    @Deprecated
    public final Class<?> toClass(ClassLoader loader) throws javassistCannotCompileException {
        return this.getClassPool().toClass(this, null, loader, null);
    }

    public void detach() {
        javassistClassPool cp = this.getClassPool();
        javassistCtClass obj = cp.removeCached(this.getName());
        if (obj != null && obj != this) {
            cp.cacheCtClass(this.getName(), obj, false);
        }
    }

    public boolean stopPruning(boolean stop) {
        return true;
    }

    public void prune() {
    }

    void incGetCounter() {
    }

    public void rebuildClassFile() {
    }

    public byte[] toBytecode() throws IOException, javassistCannotCompileException {
        ByteArrayOutputStream barray = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(barray);){
            this.toBytecode(out);
        }
        return barray.toByteArray();
    }

    public void writeFile() throws javassistNotFoundException, IOException, javassistCannotCompileException {
        this.writeFile(".");
    }

    public void writeFile(String directoryName) throws javassistCannotCompileException, IOException {
        try (DataOutputStream out = this.makeFileOutput(directoryName);){
            this.toBytecode(out);
        }
    }

    protected DataOutputStream makeFileOutput(String directoryName) {
        String dir;
        String classname = this.getName();
        String filename = directoryName + File.separatorChar + classname.replace('.', File.separatorChar) + ".class";
        int pos = filename.lastIndexOf(File.separatorChar);
        if (pos > 0 && !(dir = filename.substring(0, pos)).equals(".")) {
            new File(dir).mkdirs();
        }
        return new DataOutputStream(new BufferedOutputStream(new DelayedFileOutputStream(filename)));
    }

    public void debugWriteFile() {
        this.debugWriteFile(".");
    }

    public void debugWriteFile(String directoryName) {
        try {
            boolean p = this.stopPruning(true);
            this.writeFile(directoryName);
            this.defrost();
            this.stopPruning(p);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void toBytecode(DataOutputStream out) throws javassistCannotCompileException, IOException {
        throw new javassistCannotCompileException("not a class");
    }

    public String makeUniqueName(String prefix) {
        throw new RuntimeException("not available in " + this.getName());
    }

    void compress() {
    }

    static {
        primitiveTypes = new javassistCtClass[9];
        javassistCtClass.primitiveTypes[0] = booleanType = new javassistCtPrimitiveType("boolean", 'Z', "java.lang.Boolean", "booleanValue", "()Z", 172, 4, 1);
        javassistCtClass.primitiveTypes[1] = charType = new javassistCtPrimitiveType("char", 'C', "java.lang.Character", "charValue", "()C", 172, 5, 1);
        javassistCtClass.primitiveTypes[2] = byteType = new javassistCtPrimitiveType("byte", 'B', "java.lang.Byte", "byteValue", "()B", 172, 8, 1);
        javassistCtClass.primitiveTypes[3] = shortType = new javassistCtPrimitiveType("short", 'S', "java.lang.Short", "shortValue", "()S", 172, 9, 1);
        javassistCtClass.primitiveTypes[4] = intType = new javassistCtPrimitiveType("int", 'I', "java.lang.Integer", "intValue", "()I", 172, 10, 1);
        javassistCtClass.primitiveTypes[5] = longType = new javassistCtPrimitiveType("long", 'J', "java.lang.Long", "longValue", "()J", 173, 11, 2);
        javassistCtClass.primitiveTypes[6] = floatType = new javassistCtPrimitiveType("float", 'F', "java.lang.Float", "floatValue", "()F", 174, 6, 1);
        javassistCtClass.primitiveTypes[7] = doubleType = new javassistCtPrimitiveType("double", 'D', "java.lang.Double", "doubleValue", "()D", 175, 7, 2);
        javassistCtClass.primitiveTypes[8] = voidType = new javassistCtPrimitiveType("void", 'V', "java.lang.Void", null, null, 177, 0, 0);
    }

    static class DelayedFileOutputStream
    extends OutputStream {
        private FileOutputStream file = null;
        private String filename;

        DelayedFileOutputStream(String name) {
            this.filename = name;
        }

        private void init() throws IOException {
            if (this.file == null) {
                this.file = new FileOutputStream(this.filename);
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.init();
            this.file.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.init();
            this.file.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.init();
            this.file.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.init();
            this.file.flush();
        }

        @Override
        public void close() throws IOException {
            this.init();
            this.file.close();
        }
    }
}

