/*
 * Decompiled with CFR 0.152.
 */
package one.edee.oss.proxycian;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import one.edee.oss.proxycian.CacheKeyProvider;
import one.edee.oss.proxycian.CurriedMethodContextInvocationHandler;
import one.edee.oss.proxycian.DispatcherInvocationHandler;
import one.edee.oss.proxycian.MethodClassification;
import one.edee.oss.proxycian.TransparentMethodClassification;
import one.edee.oss.proxycian.cache.ClassMethodCacheKey;
import one.edee.oss.proxycian.trait.ProxyStateAccessor;
import one.edee.oss.proxycian.trait.StandardJavaMethods;

public abstract class AbstractDispatcherInvocationHandler<T>
implements DispatcherInvocationHandler {
    protected final T proxyState;
    protected final Object[] cacheKey;
    protected final List<MethodClassification<?, ?>> methodClassifications = new LinkedList();

    protected AbstractDispatcherInvocationHandler(T proxyState, MethodClassification<?, ?> ... methodClassifications) {
        this.proxyState = proxyState;
        this.methodClassifications.add(ProxyStateAccessor.getProxyStateMethodInvoker());
        Collections.addAll(this.methodClassifications, methodClassifications);
        this.methodClassifications.add(StandardJavaMethods.hashCodeMethodInvoker());
        this.methodClassifications.add(StandardJavaMethods.equalsMethodInvoker());
        this.methodClassifications.add(StandardJavaMethods.toStringMethodInvoker());
        this.addImplementationSpecificInvokers(this.methodClassifications);
        this.methodClassifications.add(StandardJavaMethods.realMethodInvoker());
        this.cacheKey = this.methodClassifications.stream().filter(it -> it instanceof CacheKeyProvider).map(it -> ((CacheKeyProvider)((Object)it)).getCacheKey()).filter(Objects::nonNull).toArray(Object[]::new);
    }

    protected AbstractDispatcherInvocationHandler(T proxyState, Collection<MethodClassification<?, ?>> methodClassifications) {
        this.proxyState = proxyState;
        this.methodClassifications.addAll(methodClassifications);
        this.cacheKey = this.methodClassifications.stream().filter(it -> it instanceof CacheKeyProvider).map(it -> ((CacheKeyProvider)((Object)it)).getCacheKey()).filter(Objects::nonNull).toArray(Object[]::new);
    }

    protected abstract void addImplementationSpecificInvokers(List<MethodClassification<?, ?>> var1);

    protected <U> CurriedMethodContextInvocationHandler<U, T> getCurriedMethodContextInvocationHandler(Method method) {
        LinkedList matchingHandlers = new LinkedList();
        for (MethodClassification<?, ?> methodClassification : this.methodClassifications) {
            CurriedMethodContextInvocationHandler<?, ?> curriedMethodInvocationHandler = methodClassification.createCurriedMethodContextInvocationHandler(method, this.proxyState);
            if (curriedMethodInvocationHandler == null) continue;
            matchingHandlers.add(curriedMethodInvocationHandler);
            if (methodClassification instanceof TransparentMethodClassification) continue;
            break;
        }
        if (matchingHandlers.isEmpty()) {
            return StandardJavaMethods.missingImplementationInvoker();
        }
        if (matchingHandlers.size() == 1) {
            return (CurriedMethodContextInvocationHandler)matchingHandlers.get(0);
        }
        return this.fabricateComposedMethodInvocationHandler(matchingHandlers);
    }

    protected ClassMethodCacheKey createCacheKey(@Nonnull Class<?> aClass, @Nonnull Object proxyState, @Nonnull Method method) {
        Object proxyStateCacheKey = proxyState instanceof CacheKeyProvider ? ((CacheKeyProvider)proxyState).getCacheKey() : proxyState.getClass();
        return new ClassMethodCacheKey(aClass, proxyStateCacheKey, method, this.cacheKey);
    }

    public <PROXY, PROXY_STATE> CurriedMethodContextInvocationHandler<PROXY, PROXY_STATE> fabricateComposedMethodInvocationHandler(List<CurriedMethodContextInvocationHandler<PROXY, PROXY_STATE>> nestedClassifications) {
        CurriedMethodContextInvocationHandler<PROXY, PROXY_STATE> translatedInvoker = new TailMethodInvocationHandler<PROXY, PROXY_STATE>(nestedClassifications.get(nestedClassifications.size() - 1));
        for (int i = nestedClassifications.size() - 2; i >= 0; --i) {
            CurriedMethodContextInvocationHandler<PROXY, PROXY_STATE> methodHandler = nestedClassifications.get(i);
            translatedInvoker = new DelegatingMethodInvocationHandler<PROXY, PROXY_STATE>(methodHandler, translatedInvoker);
        }
        return translatedInvoker;
    }

    private static class DelegatingMethodInvocationHandler<PROXY, PROXY_STATE>
    implements CurriedMethodContextInvocationHandler<PROXY, PROXY_STATE> {
        private final CurriedMethodContextInvocationHandler<PROXY, PROXY_STATE> delegate;
        private final CurriedMethodContextInvocationHandler<PROXY, PROXY_STATE> continuation;

        @Override
        public Object invoke(PROXY proxy, Method method, Object[] args, PROXY_STATE proxy_state, Callable<Object> invokeSuper) throws InvocationTargetException {
            return this.delegate.invoke(proxy, method, args, proxy_state, () -> this.continuation.invoke(proxy, method, args, proxy_state, invokeSuper));
        }

        public String toString() {
            return this.delegate.toString();
        }

        public DelegatingMethodInvocationHandler(CurriedMethodContextInvocationHandler<PROXY, PROXY_STATE> delegate, CurriedMethodContextInvocationHandler<PROXY, PROXY_STATE> continuation) {
            this.delegate = delegate;
            this.continuation = continuation;
        }
    }

    private static class TailMethodInvocationHandler<PROXY, PROXY_STATE>
    implements CurriedMethodContextInvocationHandler<PROXY, PROXY_STATE> {
        private final CurriedMethodContextInvocationHandler<PROXY, PROXY_STATE> delegate;

        @Override
        public Object invoke(PROXY proxy, Method method, Object[] args, PROXY_STATE proxy_state, Callable<Object> invokeSuper) throws InvocationTargetException {
            return this.delegate.invoke(proxy, method, args, proxy_state, invokeSuper);
        }

        public String toString() {
            return this.delegate.toString();
        }

        public TailMethodInvocationHandler(CurriedMethodContextInvocationHandler<PROXY, PROXY_STATE> delegate) {
            this.delegate = delegate;
        }
    }
}

